/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.dispatch.DispatchHelper;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.bpmn.engine.model.TimerStartEventScheduler;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessage;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.dms.context.ExecutionContext;
import oracle.integration.platform.blocks.scheduler.SchedulerJob;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import oracle.soa.management.ComponentDN;

public class TimerStartEventListener
implements SchedulerJob {
    public static final String CYCLE_EXPRESSION_PROPERTY = "CYCLE_EXPRESSION_PROPERTY";
    public static final String COMPONENT_NAME = "COMPONENT_NAME";
    public static final String START_TIMER_ID = "START_TIMER_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String compositeDN, String key, StringProperties stringProperties) {
        block7: {
            ICubeContext ctx = null;
            String timerStartEventId = stringProperties.get(START_TIMER_ID);
            String componentName = stringProperties.get(COMPONENT_NAME);
            ExecutionContext.deactivateContext();
            ExecutionContext.get();
            try {
                try {
                    ctx = CubeContextFactory.newInstance().create("bpmn");
                }
                catch (CubeException e) {
                    e.printStackTrace();
                }
                if (ctx == null) break block7;
                try {
                    this.createInstance(ctx, compositeDN, componentName, timerStartEventId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.scheduleAgain(ctx, compositeDN, componentName, timerStartEventId, stringProperties);
            }
            finally {
                ExecutionContext.deactivateContext();
            }
        }
    }

    private void createInstance(ICubeContext ctx, String compositeDN, String componentName, String timerStartEventId) throws Exception {
        ComponentDN componentId = new ComponentDN(compositeDN, componentName);
        Properties properties = this.prepareTrackingProperties();
        CreateComponentInstanceMessage em = new CreateComponentInstanceMessage(componentId, "bpmn", timerStartEventId, properties);
        DispatchHelper.scheduleLocal((IMessage)em, (ICubeContext)ctx);
    }

    private Properties prepareTrackingProperties() {
        Properties properties = new Properties();
        properties.put("tracking.ecwrap", ExecutionContext.wrapContext());
        return properties;
    }

    private void scheduleAgain(ICubeContext ctx, String compositeDN, String componentName, String timerStartEventId, StringProperties stringProperties) {
        String cycleExpression = stringProperties.get(CYCLE_EXPRESSION_PROPERTY);
        if (cycleExpression != null) {
            HashMap<String, URI> namespaces = new HashMap<String, URI>();
            for (Map.Entry entry : stringProperties.entrySet()) {
                if (!((String)entry.getKey()).startsWith("xmlns:")) continue;
                String prefix = ((String)entry.getKey()).substring("xmlns:".length());
                URI uri = URI.create((String)entry.getValue());
                namespaces.put(prefix, uri);
            }
            XPathExpression xpathCycleExpression = new XPathExpression(cycleExpression, namespaces);
            TimerStartEventScheduler.schedule(ctx, compositeDN, componentName, timerStartEventId, stringProperties, (Expression)xpathCycleExpression, null);
        }
    }
}

