/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import oracle.bpm.bpmn.engine.map.builder.ModelCreator;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.pml.service.DeployedProjectService;
import oracle.bpm.pml.service.util.DeployedProjectUtil;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;

public class ModelCreator_FromMetadata
implements ModelCreator {
    private ComponentModel component;
    private String relatedComponentName;

    public ModelCreator_FromMetadata() {
    }

    public ModelCreator_FromMetadata(ComponentModel component) {
        this(component, component.getName());
    }

    public ModelCreator_FromMetadata(ComponentModel compoment, String relatedComponentName) {
        this.component = compoment;
        this.relatedComponentName = relatedComponentName;
    }

    @Override
    public Process createModel() {
        Process processModel;
        String compositeDir = this.getCompositeDirectory();
        try {
            processModel = this.findProcessModel(compositeDir);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
        return processModel;
    }

    protected Process findProcessModel(String compositeDir) throws MetadataException {
        DeployedProjectService metadataService = BPMNServiceEngine.getDeployedProjectServiceImpl();
        String projectLocation = this.component.getComposite().getFolder() + "/" + compositeDir;
        Process process = null;
        int retry = 0;
        do {
            try {
                process = metadataService.findProcess(projectLocation, this.getComponentName());
            }
            catch (ProjectNotFoundException e) {
                System.out.println("Trying get the Project (try:" + retry + ")");
                try {
                    double millis = Math.pow(2.0, retry);
                    long waitTime = (long)(100.0 * millis);
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                ++retry;
            }
        } while (process == null && retry <= 6);
        return process;
    }

    protected String getBaseDir() {
        return "./gmds/soa-infra/deployed-composites/";
    }

    protected String getCompositeDirectory() {
        CompositeModel compositeModel = this.component.getComposite();
        return DeployedProjectUtil.buildDeployedCompositeName((String)compositeModel.getName(), (String)compositeModel.getRevision());
    }

    protected String getComponentName() {
        return this.relatedComponentName;
    }
}

