/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.deployment.DeploymentHelper;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.deployment.ProcessInstantiationException;
import com.collaxa.cube.lang.compiler.BPELCompilerLogger;
import com.collaxa.cube.lang.compiler.ICubeProcessor;
import com.oracle.bpel.client.util.ExceptionUtils;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.ModelCreator;
import oracle.bpm.bpmn.engine.map.builder.ModelCreatorFactoryHelper;
import oracle.bpm.bpmn.engine.model.BPMNProcess;
import oracle.bpm.bpmn.engine.model.TimerStartEventScheduler;
import oracle.bpm.bpmn.engine.model.deploy.validation.StrictGatewayValidation;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.component.implementation.BaseProcessImplementation;
import oracle.fabric.composite.model.ComponentModel;
import oracle.soa.scac.ValidateComposite;
import oracle.soa.scac.ValidationFault;

public class BPMNCubeProcessor
implements ICubeProcessor {
    private ComponentModel component;
    private Process processModel;

    public BPMNCubeProcessor(ComponentModel component) throws CubeException {
        this.component = component;
    }

    public void setOptions(Map<String, String> options) {
    }

    public boolean process(ValidationFault vf) throws CubeException {
        ModelCreator modelCreator = ModelCreatorFactoryHelper.getFactory().getModelCreator(this.component);
        this.processModel = modelCreator.createModel();
        return true;
    }

    public ICubeProcess createCubeProcess(ICubeContext ctx) throws CubeException {
        try {
            if (this.processModel == null) {
                ValidationFault vf = new ValidationFault();
                this.process(vf);
                StrictGatewayValidation validation = new StrictGatewayValidation();
                validation.validate(this.processModel, vf);
                ValidateComposite.dumpValidationFault((ValidationFault)vf, (int)10);
                BPELCompilerLogger.debug((String)"BPMNProcessor", (String)"createCubeProcess", (Object)"validation failed", (Object)vf);
                if (vf.hasErrors()) {
                    throw new CubeException((Throwable)new Exception("BPEL compilation failed"));
                }
            }
            BPMNProcess cs = new BPMNProcess();
            cs.setScaComponent(this.component);
            cs.setProcessModel(this.processModel);
            cs.setExtractContentRoot(DeploymentHelper.getScratchDirectory((ComponentModel)this.component));
            cs.load(ctx);
            DeploymentLogger.debug((String)"BPMNCubeProcessor", (String)"getCubeProcess", (Object)"Done loading process ", (Object)this.component.getComposite().getDN(), (Object)"/", (Object)this.component.getName());
            TimerStartEventScheduler.schedule(ctx, this.component.getComposite().getDN(), this.component.getName(), cs.getTimerEvents());
            return cs;
        }
        catch (CubeException ce) {
            DeploymentLogger.debug((String)"CubeProcessor", (String)"create", (Object)"Error creating process", (Throwable)ce);
            throw ce;
        }
        catch (Throwable t) {
            DeploymentLogger.debug((String)"CubeProcessor", (String)"create", (Object)"Error creating process", (Throwable)t);
            String msg = ExceptionUtils.getMessage((Throwable)t);
            throw new ProcessInstantiationException(5217, new Object[]{((BaseProcessImplementation)this.component.getImplementation()).getProcess(), this.component.getComposite().getDN(), this.component.getName(), msg}, t);
        }
    }

    public Object getProcessModel() {
        return this.processModel;
    }
}

