/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.microkernel;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstanceObserver;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.util.EngineDBUtils;
import com.collaxa.xml.XMLHelper;
import java.util.Collections;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDOutgoingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIBooleanBase;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIEntryReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeElementVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvoke;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageInputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageOutputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessSingleElementOutputDataAssociations;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessSingleElementlInputDataAssociations;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceiveCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReply;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIWorkItemIsComplete;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReply;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.resolver.ReceiveMetadataResolverImpl;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.composite.model.ComponentModel;

public class ServiceActivitiesMIHelper {
    private static final String SET_DATA_ASSOCIATION_INPUT_VARIABLE = "SetDataAssociationInputVariable";
    private static final String SET_DATA_ASSOCIATION_OUTPUT_VARIABLE = "SetDataAssociationOutputVariable";
    private static final String MARK_WORK_ITEM_AS_OPEN_PENDING_COMPLETE = "MarkWorkItemAsOpenPendingComplete";
    private static final String MARK_WORK_ITEM_AS_PERFORMER_IDEMPOTENT = "MarkWorkItemAsPerformerIdempotent";
    private static final String IS_IN_EVENT_HANDLER = "IsInEventHandler";
    private static final String FINALIZE_NODE = "FinalizeNode";
    private static final String MARK_WORK_ITEM_AS_COMPLETE = "MarkWorkItemAsComplete";
    private static final String ON_ACTIVITY_COMPLETE = "OnActivityComplete";
    private static final String ON_VARIABLE_CHANGE = "OnVariableChange";
    private static final String MARK_AS_PERFORMER_IDEMPOTENT_AND_COMPLETE = "MarkAsPerformerIdempotentAndComplete";

    public static IMicroInstruction<Object> createServiceTaskMI(MDServiceTask mdServiceTask) {
        return ServiceActivitiesMIHelper.createInvokeMI(mdServiceTask, true);
    }

    public static IMicroInstruction<Object> createServiceTaskCallbackMI(MDServiceTask mdServiceTask) {
        return ServiceActivitiesMIHelper.createInvokeCallbackMI(mdServiceTask, true);
    }

    public static IMicroInstruction<Object> createSignalEventMI(MDServiceTask mdServiceTask) {
        return ServiceActivitiesMIHelper.createInvokeMI(mdServiceTask, false);
    }

    public static IMicroInstruction<Object> createReceiveTaskMI(MDReceive mdReceive, boolean isMessage) {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdReceive, mdReceive);
        MIIfBlock ifBlockWorkItemComplete = new MIIfBlock();
        ifBlockWorkItemComplete.setExpression(ServiceActivitiesMIHelper.createWorkItemComplete());
        MISequenceBlock sequenceBlock = new MISequenceBlock();
        ServiceActivitiesMIHelper.addProcessOutputMI(sequenceBlock, mdReceive, mdReceive, mdInputVarDeclaration, isMessage);
        ifBlockWorkItemComplete.setIfBlock(sequenceBlock);
        ifBlockWorkItemComplete.setElseBlock(new MIBase(){

            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.getWorkItem().markAsOpenPendingComplete();
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.MARK_WORK_ITEM_AS_OPEN_PENDING_COMPLETE;
            }
        });
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(new MIBase(){

            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.getWorkItem().markAsPerformerIdempotent(true);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.MARK_WORK_ITEM_AS_PERFORMER_IDEMPOTENT;
            }
        });
        if (isMessage) {
            result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
        } else {
            result.addMicroInstruction(new MIInitializeElementVariable(mdInputVarDeclaration));
        }
        result.addMicroInstruction(ifBlockWorkItemComplete);
        result.addMicroInstruction(new MIReceive(mdReceive));
        return result;
    }

    public static void addProcessOutputMI(MISequenceBlock sequenceBlock, MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, MDVariableDeclaration mdVariableDeclaration, boolean isMessage) {
        FlowNode element = mdServiceActivity.getFlowElement();
        CatchEvent event = (CatchEvent)element.asAnyNode(CatchEvent.class);
        if (event != null && ModelVisitorUtil.isStartOfInlineEventHandler(event) && event.getEventTriggerType() != EventTriggerType.ERROR) {
            ServiceActivitiesMIHelper.addProcessOutputMIPart1(sequenceBlock, mdServiceActivity, mdIncomingMessage, mdVariableDeclaration, isMessage, false);
        } else {
            ServiceActivitiesMIHelper.addProcessOutputMIPart1(sequenceBlock, mdServiceActivity, mdIncomingMessage, mdVariableDeclaration, isMessage, true);
            ServiceActivitiesMIHelper.addProcessOutputMIPart2(sequenceBlock, mdServiceActivity, mdIncomingMessage, isMessage, true);
        }
    }

    public static void addProcessOutputMIPart1(MISequenceBlock sequenceBlock, MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, MDVariableDeclaration mdVariableDeclaration, boolean isMessage, boolean saveAsProperty) {
        sequenceBlock.addMicroInstruction(ServiceActivitiesMIHelper.createSetDataAssociationOutputVariable(mdVariableDeclaration));
        if (isMessage) {
            sequenceBlock.addMicroInstruction(new MIProcessMessageOutputDataAssociationsForService.Step1(mdServiceActivity, mdIncomingMessage, saveAsProperty));
        } else {
            sequenceBlock.addMicroInstruction(new MIProcessSingleElementOutputDataAssociations.Step1(mdServiceActivity, mdIncomingMessage, saveAsProperty));
        }
    }

    public static void addProcessOutputMIPart2(MISequenceBlock sequenceBlock, MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean isMessage, boolean saveAsProperty) {
        if (isMessage) {
            sequenceBlock.addMicroInstruction(new MIProcessMessageOutputDataAssociationsForService.Step2(mdServiceActivity, mdIncomingMessage, saveAsProperty));
        } else {
            sequenceBlock.addMicroInstruction(new MIProcessSingleElementOutputDataAssociations.Step2(mdServiceActivity, mdIncomingMessage, saveAsProperty));
        }
    }

    public static IMicroInstruction<Object> createReceiveTaskCallbackMI(final MDReceive mdReceive, boolean isMessage) {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdReceive, mdReceive);
        MIIfBlock ifBlockIsInEventHandler = new MIIfBlock();
        ifBlockIsInEventHandler.setExpression(new MIBooleanBase(){

            @Override
            protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
                ReceiveMetadataResolverImpl metadataResolver = new ReceiveMetadataResolverImpl(context, mdReceive);
                return metadataResolver.isInEventHandler();
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.IS_IN_EVENT_HANDLER;
            }
        });
        ifBlockIsInEventHandler.setIfBlock(new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.getWmp().getCubeNode().finalize(context.getWorkItem().getScope(), context.getCubeContext());
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.FINALIZE_NODE;
            }
        });
        ifBlockIsInEventHandler.setElseBlock(new MIBase(){

            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.getWorkItem().markAsComplete();
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.MARK_WORK_ITEM_AS_COMPLETE;
            }
        });
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(new MIReceiveCallback(mdReceive));
        result.addMicroInstruction(ServiceActivitiesMIHelper.createOnVariableChange(mdReceive));
        ServiceActivitiesMIHelper.addProcessOutputMI(result, mdReceive, mdReceive, mdInputVarDeclaration, isMessage);
        result.addMicroInstruction(ifBlockIsInEventHandler);
        result.addMicroInstruction(ServiceActivitiesMIHelper.createOnActivityComplete());
        return result;
    }

    public static IMicroInstruction<Object> createEntryReceiveMI(MDReceive mdReceive, boolean isMessage) {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdReceive, mdReceive);
        MISequenceBlock result = new MISequenceBlock();
        if (isMessage) {
            result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
        } else {
            result.addMicroInstruction(new MIInitializeElementVariable(mdInputVarDeclaration));
        }
        result.addMicroInstruction(new MIEntryReceive(mdReceive));
        ServiceActivitiesMIHelper.addProcessOutputMI(result, mdReceive, mdReceive, mdInputVarDeclaration, isMessage);
        result.addMicroInstruction(new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                IWorkItem workItem = context.getWorkItem();
                workItem.markAsPerformerIdempotent(!EngineDBUtils.isNextKeyLockingSupported());
                workItem.markAsComplete();
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.MARK_AS_PERFORMER_IDEMPOTENT_AND_COMPLETE;
            }
        });
        result.addMicroInstruction(new MIInsertInstance2Track(false));
        return result;
    }

    public static IMicroInstruction<Object> createReplyMI(MDReply mdReply, boolean isMessage) {
        MDVariableDeclaration mdVariableDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(mdReply, mdReply);
        MISequenceBlock result = new MISequenceBlock();
        if (isMessage) {
            result.addMicroInstruction(new MIInitializeMessageVariable(mdVariableDeclaration));
        } else {
            result.addMicroInstruction(new MIInitializeElementVariable(mdVariableDeclaration));
        }
        result.addMicroInstruction(ServiceActivitiesMIHelper.createSetDataAssociationInputVariable(mdVariableDeclaration));
        if (isMessage) {
            result.addMicroInstruction(new MIProcessMessageInputDataAssociationsForService(mdReply, mdReply));
        } else {
            result.addMicroInstruction(new MIProcessSingleElementlInputDataAssociations(mdReply, mdReply));
        }
        result.addMicroInstruction(new MIReply(mdReply));
        result.addMicroInstruction(new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                ICubeContext ctx = context.getCubeContext();
                IWorkItem workItem = context.getWorkItem();
                workItem.markAsComplete();
                boolean bIdempotent = true;
                ComponentModel component = CubeContextHelper.getScaComponent((ICubeContext)ctx);
                if (XMLHelper.isFalse((String)CubeFabricUtil.getConfigurationPropertyValue((ComponentModel)component, (String)"idempotentReply"))) {
                    bIdempotent = false;
                }
                workItem.markAsPerformerIdempotent(bIdempotent);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.MARK_AS_PERFORMER_IDEMPOTENT_AND_COMPLETE;
            }
        });
        return result;
    }

    public static MDVariableDeclaration createMDInputVariableDeclaration(MDServiceActivity serviceActivity, MDIncomingMessage incomingMessage) {
        QName type;
        if (serviceActivity.isMessage()) {
            type = serviceActivity.getInputType();
        } else if (serviceActivity.getEventPayloadName() != null) {
            type = serviceActivity.getEventPayloadName();
        } else {
            throw new AssertionError((Object)"input should have operationRef or payloadName");
        }
        return new MDVariableDeclaration(incomingMessage.getInputVariableName(), type);
    }

    public static MDVariableDeclaration createMDOutputVariableDeclaration(MDServiceActivity serviceActivity, MDOutgoingMessage outgingMessage) {
        QName type;
        if (serviceActivity.isMessage()) {
            type = serviceActivity.getFaultCodeError() != null ? serviceActivity.getFaultMessageType() : serviceActivity.getOutputType();
        } else if (serviceActivity.getEventPayloadName() != null) {
            type = serviceActivity.getEventPayloadName();
        } else {
            throw new AssertionError((Object)"output should have operationRef or payloadName");
        }
        if (type == null) {
            return null;
        }
        return new MDVariableDeclaration(outgingMessage.getOutputVariableName(), type);
    }

    private static IMicroInstruction<Object> createInvokeMI(final MDServiceTask mdServiceTask, boolean isMessage) {
        boolean hasOutputType;
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdServiceTask, mdServiceTask);
        MDVariableDeclaration mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(mdServiceTask, mdServiceTask);
        MISequenceBlock result = new MISequenceBlock();
        if (isMessage) {
            result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
        } else {
            result.addMicroInstruction(new MIInitializeElementVariable(mdInputVarDeclaration));
        }
        boolean bl = hasOutputType = mdOutputVarDeclaration != null;
        if (hasOutputType) {
            if (isMessage) {
                result.addMicroInstruction(new MIInitializeMessageVariable(mdOutputVarDeclaration));
            } else {
                result.addMicroInstruction(new MIInitializeElementVariable(mdOutputVarDeclaration));
            }
        }
        result.addMicroInstruction(ServiceActivitiesMIHelper.createSetDataAssociationInputVariable(mdInputVarDeclaration));
        if (isMessage) {
            result.addMicroInstruction(new MIProcessMessageInputDataAssociationsForService(mdServiceTask, mdServiceTask));
        } else {
            result.addMicroInstruction(new MIProcessSingleElementlInputDataAssociations(mdServiceTask, mdServiceTask));
        }
        result.addMicroInstruction(new MIInvoke(mdServiceTask));
        if (isMessage && mdServiceTask.isTwoWay()) {
            assert (mdOutputVarDeclaration != null) : "For output data associations, output variable declaration must not be null";
            MIIfBlock ifBlockWorkItemComplete = new MIIfBlock();
            ifBlockWorkItemComplete.setExpression(ServiceActivitiesMIHelper.createWorkItemComplete());
            MISequenceBlock sequenceBlock = new MISequenceBlock();
            ServiceActivitiesMIHelper.addProcessOutputMI(sequenceBlock, mdServiceTask, mdServiceTask, mdOutputVarDeclaration, true);
            ifBlockWorkItemComplete.setIfBlock(sequenceBlock);
            result.addMicroInstruction(ifBlockWorkItemComplete);
        } else if (mdServiceTask.getOutputDataAssociationSet() != null && !mdServiceTask.getOutputDataAssociationSet().getDataAssociations().isEmpty()) {
            result.addMicroInstruction(new MIBase(){

                protected Object doExecute(MicroInstructionContext context) throws Throwable {
                    IWorkItem wi = context.getWorkItem();
                    ICubeContext ctx = context.getCubeContext();
                    IScope sc = wi.getScope();
                    DataHandlingUtils.processOutputData(context.getNode().getFlowElement(), mdServiceTask.getOutputDataAssociationSet(), sc, ctx, Collections.<String, Object>emptyMap(), wi);
                    return null;
                }

                @Override
                public String getMicroInstructionDescription() {
                    return "MIExecuteCustomOutputs";
                }
            });
        }
        return result;
    }

    private static MIBase<Object> createSetDataAssociationOutputVariable(final MDVariableDeclaration mdOutputVarDeclaration) {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.setProperty("DATA_ASSOCIATION_OUTPUT_VARIABLE", mdOutputVarDeclaration.getName());
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.SET_DATA_ASSOCIATION_OUTPUT_VARIABLE;
            }
        };
    }

    private static MIBase<Object> createSetDataAssociationInputVariable(final MDVariableDeclaration mdInputVarDeclaration) {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.setProperty("DATA_ASSOCIATION_INPUT_VARIABLE", mdInputVarDeclaration.getName());
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.SET_DATA_ASSOCIATION_INPUT_VARIABLE;
            }
        };
    }

    private static IMicroInstruction<Boolean> createWorkItemComplete() {
        return new MIWorkItemIsComplete();
    }

    private static IMicroInstruction<Object> createInvokeCallbackMI(MDServiceTask mdServiceTask, boolean isMessage) {
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(new MIInvokeCallback());
        if (isMessage && mdServiceTask.isTwoWay()) {
            result.addMicroInstruction(new MIProcessMessageOutputDataAssociationsForService.Step1(mdServiceTask, mdServiceTask, true));
            result.addMicroInstruction(new MIProcessMessageOutputDataAssociationsForService.Step2(mdServiceTask, mdServiceTask, true));
        }
        return result;
    }

    private static MIBase<Object> createOnActivityComplete() {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                ICubeContext ctx = context.getCubeContext();
                IScope scope = context.getWorkItem().getScope();
                ICubeNode node = context.getWmp().getCubeNode();
                ICubeInstanceObserver obs = scope.getCubeInstance().getObserver();
                obs.onActivityComplete(node.getName(), node.getId(), node.getType(), node.getLineNumber(), scope, ctx);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.ON_ACTIVITY_COMPLETE;
            }
        };
    }

    private static IMicroInstruction<Object> createOnVariableChange(final MDReceive mdReceive) {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                ICubeContext ctx = context.getCubeContext();
                IScope scope = context.getWorkItem().getScope();
                ICubeNode node = context.getWmp().getCubeNode();
                CXMessageVariable variable = (CXMessageVariable)scope.getObject(mdReceive.getInputVariableName());
                ICubeInstanceObserver obs = scope.getCubeInstance().getObserver();
                obs.onVariableChange((Object)variable, node.getName(), node.getType(), scope, ctx);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return ServiceActivitiesMIHelper.ON_VARIABLE_CHANGE;
            }
        };
    }
}

