/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.microkernel;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityWMP;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;

public class MicroInstructionContext {
    private ICubeContext ctx;
    private int currentMIStep;
    private String currentProcedure;
    private Map<String, HashMap<String, Object>> generatedTokensMetadata;
    private Throwable lastException;
    private Integer newThread = null;
    private BPMNCubeElement node;
    private HashMap nodeActivationContext;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> propertiesToAddInTokenMetadata = new HashMap<String, Object>();
    private IScope scope;
    private IWorkItem wi;
    private MIBPMNActivityWMP wmp;

    public MicroInstructionContext(IWorkItem wi, ICubeContext ctx, BPMNCubeElement node, MIBPMNActivityWMP wmp) throws CubeException {
        this(wi, ctx, node, wmp, wi.getScope(), null);
    }

    public MicroInstructionContext(ICubeContext ctx, IScope scope, BPMNCubeElement node, HashMap nodeActivationContext) throws CubeException {
        this(null, ctx, node, null, scope, nodeActivationContext);
    }

    private MicroInstructionContext(IWorkItem wi, ICubeContext ctx, BPMNCubeElement node, MIBPMNActivityWMP wmp, IScope scope, HashMap nodeActivationContext) throws CubeException {
        this.wi = wi;
        this.ctx = ctx;
        this.node = node;
        this.wmp = wmp;
        this.scope = scope;
        this.nodeActivationContext = nodeActivationContext;
        this.generatedTokensMetadata = new HashMap<String, HashMap<String, Object>>();
        this.initPropertiesToAddInTokenMetadata();
    }

    public IWorkItem getWorkItem() {
        return this.wi;
    }

    public ICubeContext getCubeContext() {
        return this.ctx;
    }

    public void addGeneratedTokenMetadata(String targetFlowElementId, HashMap<String, Object> generatedTokenMetadata) {
        this.generatedTokensMetadata.put(targetFlowElementId, generatedTokenMetadata);
    }

    public Map<String, HashMap<String, Object>> getGeneratedTokensMetadata() {
        return this.generatedTokensMetadata;
    }

    public void incrementMicroInstructionStep() {
        ++this.currentMIStep;
    }

    public String getActivationIds() throws CubeException {
        return BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(this.getNodeActivationContext());
    }

    public void createNewThread() throws CubeException {
        this.newThread = BPMNTokenMetadataUtils.getNewThreadNumber(this.getScope());
    }

    public int getThread() throws CubeException {
        if (this.newThread != null) {
            return this.newThread;
        }
        return BPMNTokenMetadataUtils.getThreadFromTokenMetadata(this.getNodeActivationContext());
    }

    public int getParentThread() throws CubeException {
        if (this.newThread != null) {
            return BPMNTokenMetadataUtils.getThreadFromTokenMetadata(this.getNodeActivationContext());
        }
        return BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(this.getNodeActivationContext());
    }

    public int getStep() throws CubeException {
        if (this.newThread != null) {
            return 0;
        }
        return BPMNTokenMetadataUtils.getStepFromTokenMetadata(this.getNodeActivationContext());
    }

    public String getSourceActivityId() throws CubeException {
        return BPMNTokenMetadataUtils.getSourceFromTokenMetadata(this.getNodeActivationContext());
    }

    public Object getTokenMetadataProperty(String property) throws CubeException {
        return BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(this.getNodeActivationContext(), property);
    }

    public Object removeTokenMetadataProperty(String property) throws CubeException {
        this.propertiesToAddInTokenMetadata.remove(property);
        return BPMNTokenMetadataUtils.removePropertyFromTokenMetadata(this.getNodeActivationContext(), property);
    }

    public String getNodeId() {
        return this.node.getId();
    }

    public String getFlowElementDefaultLabel() {
        return this.node.getFlowElement().getDefaultLabel();
    }

    public BPMNCubeElement getNode() {
        return this.node;
    }

    public MIBPMNActivityWMP getWmp() {
        return this.wmp;
    }

    public Object callMicroInstruction(String miSymbol) throws Throwable {
        IMicroInstruction mi = this.getNode().getMicroInstruction(miSymbol);
        return mi.execute(this);
    }

    public Object callProcedure(String proc) throws Throwable {
        this.currentProcedure = proc;
        return this.callMicroInstruction(proc);
    }

    public void setProperty(String prop, Object value) {
        this.properties.put(prop, value);
    }

    public <T> T getProperty(String prop, Class<T> resultType) {
        return this.getProperty(prop, resultType, null);
    }

    public <T> T getProperty(String prop, Class<T> resultType, T defaultValue) {
        Object value = this.properties.get(prop);
        if (value == null) {
            return defaultValue;
        }
        if (!resultType.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("Can not assign " + value.getClass().getName() + " to " + resultType.getName());
        }
        return resultType.cast(value);
    }

    public void setPropertyToAddInTokenMetadata(String prop, Object value) {
        this.propertiesToAddInTokenMetadata.put(prop, value);
    }

    public void addPropertiesToAddInTokenMetadata(Map<String, Object> map) {
        this.propertiesToAddInTokenMetadata.putAll(map);
    }

    public <T> T getPropertyToAddInTokenMetadata(String prop, Class<T> resultType) {
        return this.getPropertyToAddInTokenMetadata(prop, resultType, null);
    }

    public <T> T getPropertyToAddInTokenMetadata(String prop, Class<T> resultType, T defaultValue) {
        Object value = this.propertiesToAddInTokenMetadata.get(prop);
        if (value == null) {
            return defaultValue;
        }
        if (!resultType.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("Can not assign " + value.getClass().getName() + " to " + resultType.getName());
        }
        return resultType.cast(value);
    }

    public Map<String, Object> getPropertiesToAddInTokenMetadata() {
        return Collections.unmodifiableMap(this.propertiesToAddInTokenMetadata);
    }

    public void logExecution(String label, String microInstructionId) {
        String nodeId;
        String id = nodeId = this.getNodeId();
        if (this.getNode().getFlowElement() != null) {
            id = id + "[" + this.getFlowElementDefaultLabel() + "]";
        }
        int thread = -1;
        int step = -1;
        try {
            thread = this.getThread();
            step = this.getStep();
        }
        catch (CubeException e) {
            // empty catch block
        }
        BPMRuntimeLogger.logNodeExecuteStatement(this.getScope(), this.getCubeContext(), id, microInstructionId.replace(" ", "_"), thread, step, this.currentMIStep, this.currentProcedure, label);
    }

    public HashMap getNodeActivationContext() throws CubeException {
        if (this.nodeActivationContext == null) {
            this.nodeActivationContext = this.getWorkItem().getNodeActivationContext();
        }
        return this.nodeActivationContext;
    }

    public ICubeInstance getCubeInstance() {
        return CubeContextHelper.getCubeInstance((ICubeContext)this.getCubeContext());
    }

    public IScope getScope() {
        return this.scope;
    }

    public Object executeProcedure(String procedure, String procedure_exception) throws Throwable {
        Object result = null;
        try {
            result = this.callProcedure(procedure);
        }
        catch (Exception e) {
            if (procedure_exception != null) {
                this.setLastException(e);
                this.callProcedure(procedure_exception);
            }
            throw e;
        }
        return result;
    }

    public Object executeProcedureControlled(String procedure, String procedure_exception) throws Exception {
        Object result;
        try {
            result = this.executeProcedure(procedure, procedure_exception);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return result;
    }

    public Object executeProcedureControlledWithoutException(String procedure, String procedure_exception) {
        Object result;
        try {
            result = this.executeProcedure(procedure, procedure_exception);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return result;
    }

    public void setLastException(Throwable lastException) {
        this.lastException = lastException;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    private void initPropertiesToAddInTokenMetadata() throws CubeException {
        if (this.wi == null || this.wi.hasNodeActivationContext()) {
            HashMap tokenMetadata = this.getNodeActivationContext();
            for (Map.Entry entry : tokenMetadata.entrySet()) {
                if (((String)entry.getKey()).equals("STEP") || ((String)entry.getKey()).equals("THREAD") || ((String)entry.getKey()).equals("SOURCE_ACTIVITY_ID") || ((String)entry.getKey()).equals("ACTIVATION_IDS")) continue;
                this.setPropertyToAddInTokenMetadata((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

