/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.util.ThreadCountManager;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIBooleanBase;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.FlowNode;

public class TimerEventExpireGenerator {
    public static IMicroInstruction compile(BPMNCubeMapBuilderContext context, CatchEvent element) {
        MISequenceBlock block = new MISequenceBlock();
        if (ModelVisitorUtil.isEventHandler(element)) {
            MIIfBlock ifBlock = new MIIfBlock();
            block.addMicroInstruction(ifBlock);
            if (ModelVisitorUtil.isInlineEventHandler((FlowNode)element)) {
                ifBlock.setExpression(new ConditionInParentScope());
            } else {
                ifBlock.setExpression(new Condition());
            }
            MISequenceBlock ifBlockPart = new MISequenceBlock();
            ifBlock.setIfBlock(ifBlockPart);
            TimerEventExpireGenerator.completeExpire(context, ifBlockPart, element);
        } else {
            TimerEventExpireGenerator.completeExpire(context, block, element);
        }
        return block;
    }

    private static void completeExpire(BPMNCubeMapBuilderContext context, MISequenceBlock block, CatchEvent element) {
        block.addMicroInstruction(new DoExpire());
        block.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
    }

    private static class DoExpire
    extends MIBase<Object> {
        private DoExpire() {
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            context.getWorkItem().markAsComplete();
            return null;
        }
    }

    private static class ConditionInParentScope
    extends MIBooleanBase {
        private ConditionInParentScope() {
        }

        @Override
        protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
            boolean result = ThreadCountManager.getThreadCount((IScope)context.getWorkItem().getScope().getParentScope()) > 0;
            return result;
        }
    }

    private static class Condition
    extends MIBooleanBase {
        private Condition() {
        }

        @Override
        protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
            boolean result = ThreadCountManager.getThreadCount((IScope)context.getWorkItem().getScope()) > 0;
            return result;
        }
    }
}

