/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import com.collaxa.cube.engine.ext.bpel.v1.nodes.BPELContext;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIWorkItemIsComplete;
import oracle.bpm.project.model.processes.FlowNode;

public class HandleCallbackGenerator {
    public static IMicroInstruction generate(FlowNode element) {
        MISequenceBlock block = new MISequenceBlock();
        MIIfBlock ifWorkItemCompleted = new MIIfBlock();
        block.addMicroInstruction(new MIHandleCallback());
        block.addMicroInstruction(ifWorkItemCompleted);
        MISequenceBlock workitemCompleted = new MISequenceBlock();
        ifWorkItemCompleted.setIfBlock(workitemCompleted);
        ifWorkItemCompleted.setExpression(new MIWorkItemIsComplete());
        workitemCompleted.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
        workitemCompleted.addMicroInstruction(new MIInsertInstance2Track(true));
        return block;
    }

    public static IMicroInstruction generateExceptionMethod(FlowNode element, AbstractCompiler.RegisterDelegator delegator, BPMNCubeMapBuilderContext context) {
        return AuditTrailVisitorHelper.createAndAddPostAuditMI(context, element, delegator, null, Tag.POST_AUDIT_EXCEPTION);
    }

    public static class MIHandleCallback
    extends MIBase<Object> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            ICubeContext ctx = context.getCubeContext();
            try {
                BPELContext.pushThreadBPELContext((ICubeContext)ctx);
                this.doHandleCallback(context);
            }
            catch (Throwable e) {
                e.printStackTrace();
                BPELWMPHelper.logException((Throwable)e, (IWorkItem)wi, (ICubeContext)ctx);
                wi.throwException(e, ctx);
            }
            finally {
                BPELContext.popThreadBPELContext();
            }
            return null;
        }

        private void doHandleCallback(MicroInstructionContext context) throws Throwable {
            context.callMicroInstruction("DO_HANDLE_CALLBACK");
        }
    }
}

