/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.logging.Level;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIWorkItemIsComplete;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;

public class ExecuteStatementGenerator {
    public static IMicroInstruction generate(FlowNode element) {
        boolean isUserTask;
        MISequenceBlock block = new MISequenceBlock();
        block.addMicroInstruction(new MILogIn());
        block.addMicroInstruction(new MICall("DO_EXECUTE_STATEMENT"));
        MIIfBlock miIfBlock = new MIIfBlock();
        miIfBlock.setExpression(new MIWorkItemIsComplete());
        miIfBlock.setIfBlock(new MICall("GENERATE_NEXT_TOKENS"));
        block.addMicroInstruction(miIfBlock);
        boolean isEndEvent = element.getBpmnType() == BpmnType.END_EVENT;
        boolean bl = isUserTask = element.getBpmnType() == BpmnType.USER_TASK;
        if (isEndEvent) {
            block.addMicroInstruction(new MIInsertInstance2Track(true));
        } else if (!isUserTask) {
            MIIfBlock miIfBlock2 = new MIIfBlock();
            miIfBlock2.setExpression(new MIInsertInstance2Track.MIInsertInstance2TrackCondition());
            miIfBlock2.setIfBlock(new MIInsertInstance2Track(false));
            miIfBlock2.setElseBlock(new MIInsertInstance2Track(true));
            block.addMicroInstruction(miIfBlock2);
        }
        return block;
    }

    public static IMicroInstruction generateExceptionMethod(FlowNode element, AbstractCompiler.RegisterDelegator delegator, BPMNCubeMapBuilderContext context) {
        return AuditTrailVisitorHelper.createAndAddPostAuditMI(context, element, delegator, null, Tag.POST_AUDIT_EXCEPTION);
    }

    private static class MILogIn
    extends MIBase<Object> {
        private MILogIn() {
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            IScope sc = wi.getScope();
            BPMRuntimeLogger.log(Level.ALL, "bpmn.engine.model.runtime.ParallelGateway", "__executeStatements", "generating token for " + sc.getAbsoluteScopeId());
            return null;
        }
    }
}

