/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.xml.xsd.SchemaToXML;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ComponentPropertiesHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractBPMNActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvoke;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskRequest;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskResponse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNNamespaceContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.SchemaUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.type.Argument;
import oracle.fabric.common.NormalizedMessage;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.collaxa.thirdparty.jaxen.NamespaceContext;
import org.w3c.dom.Element;

public class UserTaskVisitorImpl
extends MIAbstractBPMNActivityVisitor<UserTask> {
    @Override
    protected MIVisitor<CompilationResult> createMIVisitor(final UserTask userTask, BPMNCubeMapBuilderContext context) throws CubeException {
        final String referenceName = userTask.getHumanTask().getText() + ".reference";
        if (userTask.isManualStart()) {
            context.setCreateInstanceEventInitiationInfo();
        }
        context.addServiceLinkDeclaration(referenceName);
        DataHandlingUtils.handleIoSpecificationImports(userTask.getInputDataAssociationSet(), context);
        ComponentPropertiesHelper.nonBlockingInvoke((Activity)userTask, referenceName, context);
        String inputVariable = userTask.getDefaultLabel() + "_" + userTask.getId() + "_in";
        String outputVariable = userTask.getDefaultLabel() + "_" + userTask.getId() + "_out";
        final ComponentModel model = context.getComponentModel();
        final MDServiceTask mdServiceTask = new MDServiceTask(inputVariable, outputVariable, userTask.getOutputDataAssociationSet(), userTask.getInputDataAssociationSet(), userTask.getOutputArgumentsContainer(), userTask.getInputArgumentsContainer(), this.getOperationReference(userTask), referenceName, null, null, (FlowNode)userTask, false);
        return new SimpleVisitorImpl<UserTask, CompilationResult>(userTask, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<UserTask>(userTask, delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MDVariableDeclaration mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MISequenceBlock result = new MISequenceBlock();
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdOutputVarDeclaration));
                        result.addMicroInstruction(new MIInsertInstance2Track(false, true));
                        result.addMicroInstruction(new MIUserTaskRequest(mdServiceTask, UserTaskVisitorImpl.this.getElementMap(userTask, model)));
                        result.addMicroInstruction(new MIInvoke(mdServiceTask));
                        MIIfBlock miIfBlock = new MIIfBlock();
                        miIfBlock.setExpression(this.isBlockingInvoke(referenceName));
                        miIfBlock.setIfBlock(new MIUserTaskResponse(mdServiceTask));
                        result.addMicroInstruction(miIfBlock);
                        return result;
                    }

                    private IMicroInstruction<Boolean> isBlockingInvoke(final String referenceName) {
                        return new IMicroInstruction<Boolean>(){

                            @Override
                            public Boolean execute(MicroInstructionContext context) throws Throwable {
                                ComponentModel component = CubeContextHelper.getScaComponent((ICubeContext)context.getCubeContext());
                                return !ComponentPropertiesHelper.isNonBlockingInvoke(component, referenceName);
                            }

                            @Override
                            public String getMicroInstructionDescription() {
                                return "MIISNonBlockingInvoke";
                            }
                        };
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        MISequenceBlock result = new MISequenceBlock();
                        MIIfBlock miIfBlock = new MIIfBlock();
                        result.addMicroInstruction(miIfBlock);
                        miIfBlock.setExpression(this.isUserTaskResponse());
                        miIfBlock.setIfBlock(new MIUserTaskResponse(mdServiceTask));
                        miIfBlock.setElseBlock(new MIUserTaskCallback(userTask));
                        result.addMicroInstruction(new MIInsertInstance2Track(true));
                        return result;
                    }

                    private IMicroInstruction<Boolean> isUserTaskResponse() {
                        return new IMicroInstruction<Boolean>(){

                            @Override
                            public Boolean execute(MicroInstructionContext context) throws Throwable {
                                ICubeContext ctx = context.getCubeContext();
                                NormalizedMessage nm = (NormalizedMessage)ctx.getFromEnvironment("__call-NM");
                                Map inputs = nm.getPayload();
                                XMLElement payload = (XMLElement)inputs.get("payload");
                                return "initiateTaskResponse".equals(payload.getLocalName());
                            }

                            @Override
                            public String getMicroInstructionDescription() {
                                return "MIIsUserTaskResponse";
                            }
                        };
                    }
                };
            }
        };
    }

    private String getResourceLocation(SchemaObject object, ComponentModel model) {
        String resolvedLocation = null;
        String resourceLocation = object.getLocation();
        if (resourceLocation != null) {
            if (resourceLocation.startsWith("/") && resourceLocation.length() > 1) {
                resourceLocation = resourceLocation.substring(1);
            }
            resolvedLocation = model.getComposite().getMetadataManager().resolve(resourceLocation);
        }
        return resolvedLocation;
    }

    private Map getElementMap(UserTask userTask, ComponentModel model) {
        HashMap<String, Element> elementMap = new HashMap<String, Element>();
        try {
            DataAssociationSet inputAssociation = userTask.getInputDataAssociationSet();
            boolean isInitiateTask = userTask.isManualStart();
            boolean isDataAssociationExit = false;
            SchemaManager manager = model.getComposite().getSchemaManager();
            if (isInitiateTask && inputAssociation != null) {
                Sequence associations = inputAssociation.getDataAssociations();
                boolean bl = isDataAssociationExit = associations != null && !associations.isEmpty();
            }
            if (isInitiateTask && !isDataAssociationExit) {
                HumanTask ht = userTask.getHumanTask();
                Sequence arguments = ht.getArguments();
                for (Argument argument : arguments) {
                    String dataIpOpName = argument.getName();
                    if (dataIpOpName.equals("outcome") || dataIpOpName.equals("execData")) continue;
                    SchemaObject asSchemaObject = argument.getType().asSchemaObject();
                    String namespace = null;
                    String argName = null;
                    XMLDocument document = (XMLDocument)XMLUtil.createDocument();
                    if (asSchemaObject.isType()) {
                        namespace = "http://xmlns.oracle.com/bpel/workflow/task";
                        argName = dataIpOpName;
                        if (asSchemaObject.isBasicType()) {
                            elementMap.put(argName, document.createElementNS(namespace, argName));
                            continue;
                        }
                        String complexTypeName = asSchemaObject.getName();
                        String complexTypeNS = asSchemaObject.getNamespace();
                        URL schemaUrl = new URL(this.getResourceLocation(asSchemaObject, model));
                        if (schemaUrl == null) continue;
                        XMLSchema schema = SchemaUtils.buildSchemaFromUrl(schemaUrl);
                        BPMNNamespaceContext context = new BPMNNamespaceContext(Collections.<String, URI>emptyMap());
                        XMLElement childElem = SchemaToXML.generateXMLElementForType((String)argName, (int)0, (QName)new QName(namespace, argName), (QName)new QName(complexTypeNS, complexTypeName), null, (boolean)false, (NamespaceContext)context, (SchemaManager)manager);
                        elementMap.put(argName, (Element)childElem);
                        continue;
                    }
                    namespace = asSchemaObject.getNamespace();
                    argName = asSchemaObject.getName();
                    URL schemaUrl = new URL(this.getResourceLocation(asSchemaObject, model));
                    if (schemaUrl == null) continue;
                    BPMNNamespaceContext context = new BPMNNamespaceContext(Collections.<String, URI>emptyMap());
                    XMLElement childElem = SchemaToXML.generateXMLElement((String)argName, (QName)new QName(namespace, argName), null, (boolean)false, (boolean)false, (NamespaceContext)context, (SchemaManager)manager);
                    elementMap.put(argName, (Element)childElem);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return elementMap;
    }

    private OperationReference getOperationReference(UserTask userTask) {
        String operationName = null;
        operationName = userTask.isReinitiate() ? "reinitiateTask" : "initiateTask";
        QName portType = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskService");
        QName inputMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "initiateTaskMessage");
        QName responseMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "initiateTaskResponseMessage");
        QName faultMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "workflowErrorMessage");
        MDOperationRef operationRef = new MDOperationRef("payload", operationName, inputMessage, true, portType, responseMessage, null, faultMessage);
        return operationRef;
    }
}

