/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractEventTriggerTypeVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.NoneEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateNextTokensCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.TimerEventExpireGenerator;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MICancelPerform;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MITimerEvent;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MITimerEventDefineExpirationDate;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDTimerEvent;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.features.TimerFeature;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ThrowEvent;

public class TimerEventVisitorImpl
extends MIAbstractEventTriggerTypeVisitor<CatchEvent> {
    @Override
    protected MIVisitor<CompilationResult> doCompileCatch(BPMNCubeMapBuilderContext context, CatchEvent event) throws CubeException {
        SimpleVisitorImpl visitor;
        if (event.isStart() && event.getParentObject() == event.getProcess() || Boolean.TRUE.equals(context.isCompilingInstantiateBlock())) {
            context.addInitiateInfo(event);
            visitor = new NoneEventVisitorImpl.NoneSimpleVisitorImpl<CatchEvent>(event, context);
        } else {
            visitor = new TimerSimpleVisitorImpl(event, context);
        }
        return visitor;
    }

    @Override
    protected MIVisitor<CompilationResult> doCompileThrow(BPMNCubeMapBuilderContext context, ThrowEvent event) throws CubeException {
        throw new UnsupportedOperationException("timer throw event does not exists");
    }

    protected static class TimerSimpleVisitorImpl
    extends SimpleVisitorImpl<CatchEvent, CompilationResult> {
        public TimerSimpleVisitorImpl(CatchEvent event, BPMNCubeMapBuilderContext context) {
            super(event, context);
        }

        @Override
        public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
            return new AbstractCompiler<CatchEvent>((CatchEvent)this.getElement(), delegator){

                @Override
                protected IMicroInstruction<Object> getDoExecuteStatement() {
                    return new MITimerEvent();
                }

                @Override
                protected IMicroInstruction<Object> getDoHandleCallback() {
                    return new MINop();
                }

                @Override
                protected IMicroInstruction generateExpireMethod() {
                    return TimerEventExpireGenerator.compile(TimerSimpleVisitorImpl.this.getContext(), (CatchEvent)this.getElement());
                }

                @Override
                protected IMicroInstruction generateDefineExpirationDateMethod() {
                    Expression timeCycle = ((TimerFeature)((CatchEvent)this.getElement()).getFeature(TimerFeature.class)).getTimeCycleExpression();
                    Expression timeDate = ((TimerFeature)((CatchEvent)this.getElement()).getFeature(TimerFeature.class)).getTimeDateExpression();
                    MDTimerEvent mdTimerEvent = new MDTimerEvent(timeCycle, timeDate, ((CatchEvent)this.getElement()).isBoundaryEvent());
                    return new MITimerEventDefineExpirationDate(mdTimerEvent);
                }

                @Override
                protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
                    MISequenceBlock block = new MISequenceBlock();
                    block.addMicroInstruction(new MICancelPerform());
                    block.addMicroInstruction(super.generateCancelPerformMethod(context));
                    return block;
                }
            };
        }

        @Override
        protected GenerateNextTokensCompiler getGenerateNextTokenCompiler(MIBPMNActivityNode node) {
            return new GenerateNextTokensCompiler.GenerateNextTokensCompilerForTimerEvent(this.getContext(), node, (CatchEvent)this.getElement());
        }

        @Override
        protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
            return EventCompilationResult.create(activityId, node, node, false, false);
        }
    }
}

