/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SubProcessCompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BPMNSubProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class SubProcessVisitorImpl
extends AbstractBPMNActivityVisitor<Subprocess> {
    @Override
    protected CompilationResult visitActivity(Subprocess subprocess, BPMNCubeMapBuilderContext context, ICubeBlock parentBlock) throws CubeException {
        String activityId = subprocess.getId();
        String activityName = subprocess.getName();
        BPMNSubProcessBlock subprocessBlock = BlockFactory.createSubProcessBlock(context, activityName, subprocess);
        ICubeBlock subprocessParentBlock = parentBlock;
        if (SubProcessVisitorImpl.hasInlineFaultHandlers(subprocess) && parentBlock instanceof TryBlock) {
            subprocessParentBlock = parentBlock.getParentBlock();
        }
        context.addElementToBlock(subprocessBlock, subprocessParentBlock);
        BaseBPMNActivityBlock oldCurrentBlock = context.getCurrentBlock();
        context.setCurrentBlock(subprocessBlock);
        TryBlock tryBlock = null;
        List<Subprocess> inlineSubprocesses = this.getInlineSubprocesses(subprocess);
        if (SubProcessVisitorImpl.hasInlineFaultHandlers(inlineSubprocesses)) {
            tryBlock = BlockFactory.createTryBlock(context, "_tryInline", activityName, subprocess);
            context.addElementToBlock(tryBlock, (ICubeBlock)subprocessBlock);
            context.tagElement(TagInfo.createTagInfo(subprocess.getId(), Tag.TRY_BLOCK), tryBlock);
            subprocessBlock.getSequenceFlowMetadata().addEntryElement(tryBlock);
            context.setCurrentBlock(tryBlock);
        }
        ModelVisitor modelVisitor = new ModelVisitor(context, (NodeContainer)subprocess);
        modelVisitor.visit();
        if (subprocess.isTriggeredByEvent()) {
            subprocessBlock.setStartOfMainFlow(false);
            if (!ModelVisitorUtil.isInterrupting(subprocess)) {
                subprocessBlock.setNonMainFlowEndElement(true);
            }
        }
        ModelVisitorUtil.processInlineCompilationResult(context, (BaseBPMNActivityBlock)subprocessBlock, tryBlock, modelVisitor.getInlineErrorSubProcesses());
        context.setCurrentBlock(oldCurrentBlock);
        ArrayList<EventCompilationResult> startEventsCompilationResult = new ArrayList<EventCompilationResult>();
        if (subprocess.isTriggeredByEvent()) {
            for (BPMNCubeElement node : modelVisitor.getInitiateElement()) {
                EventCompilationResult eventCompilationResult = EventCompilationResult.create(node, subprocessBlock.getId());
                if (eventCompilationResult == null) continue;
                startEventsCompilationResult.add(eventCompilationResult);
            }
        }
        return new SubProcessCompilationResult(activityId, subprocessBlock, subprocessBlock, startEventsCompilationResult);
    }

    @Override
    protected boolean createAuditLogNodes(Subprocess element) {
        return false;
    }

    private static boolean hasInlineFaultHandlers(List<Subprocess> inlineSubprocesses) {
        for (Subprocess subprocess : inlineSubprocesses) {
            if (!SubProcessVisitorImpl.hasInlineFaultHandlers(subprocess)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInlineFaultHandlers(Subprocess subprocess) {
        for (StartEvent event : subprocess.getEvents(StartEvent.class)) {
            if (!event.isInterrupting()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<Subprocess> getInlineSubprocesses(Subprocess subprocess) {
        ArrayList<Subprocess> result = new ArrayList<Subprocess>();
        for (Subprocess child : subprocess.getActivities(Subprocess.class)) {
            if (!child.isTriggeredByEvent()) continue;
            result.add(child);
        }
        return result;
    }
}

