/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeProcess;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceiveCancel;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.ThrowEvent;

public class SignalEventVisitorHelper {
    public static MIVisitor<CompilationResult> createMIVisitor(ThrowEvent throwEvent, BPMNCubeMapBuilderContext context) throws CubeException {
        assert (throwEvent.getEventTriggerType() == EventTriggerType.SIGNAL) : throwEvent.getId() + " must be a Signal event but is->" + throwEvent.getEventTriggerType();
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)throwEvent.getEventDefinition().as(SignalEventDefinition.class);
        final MDServiceTask mdService = new MDServiceTask(throwEvent.getDefaultLabel() + "_" + throwEvent.getId() + "_in", null, null, throwEvent.getInputDataAssociationSet(), null, throwEvent.getInputArgumentsContainer(), null, null, SignalEventVisitorHelper.getEventName(signalEventDefinition), SignalEventVisitorHelper.getPayloadName(signalEventDefinition), (FlowNode)throwEvent);
        DataHandlingUtils.handleIoSpecificationImports(throwEvent.getInputDataAssociationSet(), context);
        return new SimpleVisitorImpl<ThrowEvent, CompilationResult>(throwEvent, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<ThrowEvent>((ThrowEvent)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return ServiceActivitiesMIHelper.createSignalEventMI(mdService);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MINop();
                    }
                };
            }
        };
    }

    public static MIVisitor<CompilationResult> createMIVisitor(CatchEvent catchEvent, BPMNCubeMapBuilderContext context) throws CubeException {
        return SignalEventVisitorHelper.createMIVisitor(catchEvent, context, catchEvent.isStart());
    }

    public static MDReceive createMDReceive(CatchEvent catchEvent) {
        return SignalEventVisitorHelper.createMDReceive(catchEvent, SignalEventVisitorHelper.getSignalEventDefinition(catchEvent));
    }

    private static MIVisitor<CompilationResult> createMIVisitor(CatchEvent catchEvent, BPMNCubeMapBuilderContext context, final boolean isCreateInstance) throws CubeException {
        SignalEventDefinition signalEventDefinition = SignalEventVisitorHelper.getSignalEventDefinition(catchEvent);
        final MDReceive mdReceive = SignalEventVisitorHelper.createMDReceive(catchEvent, signalEventDefinition);
        DataHandlingUtils.handleIoSpecificationImports(catchEvent.getOutputDataAssociationSet(), context);
        if (isCreateInstance) {
            SignalEventVisitorHelper.addInitiationInfo(signalEventDefinition, context);
        }
        return new SimpleVisitorImpl<CatchEvent, CompilationResult>(catchEvent, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<CatchEvent>((CatchEvent)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        if (isCreateInstance) {
                            return ServiceActivitiesMIHelper.createEntryReceiveMI(mdReceive, false);
                        }
                        return ServiceActivitiesMIHelper.createReceiveTaskMI(mdReceive, false);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        if (isCreateInstance) {
                            return new MIAssertFalse();
                        }
                        return ServiceActivitiesMIHelper.createReceiveTaskCallbackMI(mdReceive, false);
                    }

                    @Override
                    protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
                        MIReceiveCancel mi = new MIReceiveCancel();
                        mi.addMicroInstruction(super.generateCancelPerformMethod(context));
                        return mi;
                    }

                    @Override
                    protected IMicroInstruction generateThrowExceptionMethod() {
                        return new MIReceiveCancel();
                    }
                };
            }

            @Override
            protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                return EventCompilationResult.create(activityId, node, node, false, false);
            }
        };
    }

    private static SignalEventDefinition getSignalEventDefinition(CatchEvent catchEvent) {
        return (SignalEventDefinition)catchEvent.getEventDefinition().as(SignalEventDefinition.class);
    }

    private static MDReceive createMDReceive(CatchEvent catchEvent, SignalEventDefinition signalEventDefinition) {
        String inputVariable = catchEvent.getDefaultLabel() + "_" + catchEvent.getId() + "_in";
        MDReceive mdReceive = new MDReceive(inputVariable, null, catchEvent.getOutputDataAssociationSet(), catchEvent.getOutputArgumentsContainer(), null, SignalEventVisitorHelper.getEventName(signalEventDefinition), SignalEventVisitorHelper.getPayloadName(signalEventDefinition), (FlowNode)catchEvent);
        return mdReceive;
    }

    private static void addInitiationInfo(SignalEventDefinition signalEventDefinition, BPMNCubeMapBuilderContext context) {
        QName eventName = SignalEventVisitorHelper.getEventName(signalEventDefinition);
        System.out.println("Adding initiate info for " + eventName);
        ICubeProcess.InitiationInfo initiationInfo = new ICubeProcess.InitiationInfo(null, null, eventName, null, null);
        context.addInitiationInfo(initiationInfo);
    }

    private static QName getEventName(SignalEventDefinition signalEventDefinition) {
        return signalEventDefinition.getSignal().getEventQName();
    }

    private static QName getPayloadName(SignalEventDefinition signalEventDefinition) {
        return signalEventDefinition.getSignal().getContentQName();
    }
}

