/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeProcess;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.metadataextension.ReceiveMessageElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceiveCancel;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;

public class ReceiveMessageElementVisitorHelper {
    public static MIVisitor<CompilationResult> createMIVisitor(ReceiveMessageElement element, BPMNCubeMapBuilderContext context) throws CubeException {
        String serviceName = ReceiveMessageElementVisitorHelper.getServiceName(element);
        final boolean isCreateInstance = context.isCompilingInstantiateBlock() == null ? element.isInstantiate() : context.isCompilingInstantiateBlock().booleanValue();
        final MDReceive mdReceive = ReceiveMessageElementVisitorHelper.createMDReceive(element, serviceName);
        context.addServiceLinkDeclaration(serviceName);
        DataHandlingUtils.handleIoSpecificationImports(element.getOutputDataAssociationSet(), context);
        if (isCreateInstance) {
            ReceiveMessageElementVisitorHelper.addActivityAsInitiationInfo(element, context, serviceName);
        }
        return new SimpleVisitorImpl<ReceiveMessageElement, CompilationResult>(element, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<ReceiveMessageElement>((ReceiveMessageElement)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        if (isCreateInstance) {
                            return ServiceActivitiesMIHelper.createEntryReceiveMI(mdReceive, true);
                        }
                        return ServiceActivitiesMIHelper.createReceiveTaskMI(mdReceive, true);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        if (isCreateInstance) {
                            return new MIAssertFalse();
                        }
                        return ServiceActivitiesMIHelper.createReceiveTaskCallbackMI(mdReceive, true);
                    }

                    @Override
                    protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
                        MIReceiveCancel mi = new MIReceiveCancel();
                        mi.addMicroInstruction(super.generateCancelPerformMethod(context));
                        return mi;
                    }

                    @Override
                    protected IMicroInstruction generateThrowExceptionMethod() {
                        return new MIReceiveCancel();
                    }
                };
            }

            @Override
            protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                if (((ReceiveMessageElement)this.getElement()).isEvent()) {
                    return EventCompilationResult.create(activityId, node, node, false, false);
                }
                return super.createCompilationResult(activityId, node);
            }
        };
    }

    public static MDReceive createMDReceive(ReceiveMessageElement element) {
        return ReceiveMessageElementVisitorHelper.createMDReceive(element, ReceiveMessageElementVisitorHelper.getServiceName(element));
    }

    public static MDReceive createMDReceive(ReceiveMessageElement element, String serviceName) {
        String inputVariable = element.getDefaultLabel() + "_" + element.getId() + "_in";
        MDReceive mdReceive = new MDReceive(inputVariable, element.getOperationReference(), element.getOutputDataAssociationSet(), element.getOutputArgumentsContainer(), serviceName, null, null, element);
        return mdReceive;
    }

    private static String getServiceName(ReceiveMessageElement element) {
        return element.getParticipantReference().getId();
    }

    private static void addActivityAsInitiationInfo(ReceiveMessageElement receiveTask, BPMNCubeMapBuilderContext context, String partnerLinkName) {
        String operationName = receiveTask.getOperationReference().getName();
        System.out.println("Adding initiate info for " + operationName + " partnerLinkName " + partnerLinkName);
        ICubeProcess.InitiationInfo initiationInfo = new ICubeProcess.InitiationInfo(operationName, partnerLinkName, null, null);
        context.addInitiationInfo(initiationInfo);
    }
}

