/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ActivityCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BPMNMultiInstanceBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNMultiInstanceCompletionConditionBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNMultiInstanceInnerBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.nodes.MultiInstanceEndNode;
import oracle.bpm.bpmn.engine.model.nodes.MultiInstanceInitNode;
import oracle.bpm.bpmn.engine.model.nodes.MultiInstanceInnerEndNode;
import oracle.bpm.bpmn.engine.model.nodes.MultiInstanceInnerInitNode;
import oracle.bpm.bpmn.engine.model.nodes.MultiInstanceLoopNode;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.ConditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfoFactory;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MultiInstance;

public class MultiInstanceCharacteristicsVisitor
extends ActivityCharacteristicsVisitor<Activity, MultiInstance> {
    private static final String MIBLOCK_PREFIX = "MultiInstanceBlock";
    private static final String MIBLOCK_NODE_SUFFIX_INIT = "Init";
    private static final String MIBLOCK_NODE_SUFFIX_LOOP = "While";
    private static final String MIBLOCK_NODE_SUFFIX_END = "End";
    private static final String MIINNERCOMPLETIONCONDITIONBLOCK_PREFIX = "MultiInstanceCompletionConditionBlock";
    private static final String MIINNERBLOCK_PREFIX = "MultiInstanceInnerBlock";
    private static final String MIINNERBLOCK_NODE_SUFFIX_INIT = "Init";
    private static final String MIINNERBLOCK_NODE_SUFFIX_END = "End";

    @Override
    public LoopCharacteristicsType getLoopCharacteristicsType() {
        return LoopCharacteristicsType.MULTIINSTANCE;
    }

    @Override
    protected MultiInstance getCharacteristics(Activity activity) {
        return (MultiInstance)activity.getLoopCharacteristics().as(MultiInstance.class);
    }

    @Override
    protected CompilationResult visit(Activity activity, MultiInstance multiInstance, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor) throws CubeException {
        return multiInstance.isSequential() ? this.buildSequentialMIBlock(activity, multiInstance, context, bpmnFlowElementVisitor) : this.buildParallelMIBlock(activity, multiInstance, context, bpmnFlowElementVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationResult buildSequentialMIBlock(Activity activity, MultiInstance multiInstance, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor) throws CubeException {
        String activityId = activity.getId();
        String activityName = activity.getName();
        BPMNMultiInstanceBlock multiInstanceBlock = BlockFactory.createMultiInstanceBlock(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityId), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName), activity, multiInstance);
        context.addElementToBlock(multiInstanceBlock, (ICubeBlock)context.getCurrentBlock());
        BaseBPMNActivityBlock currentBlock = context.getCurrentBlock();
        try {
            context.setCurrentBlock(multiInstanceBlock);
            MultiInstanceInitNode multiInstanceInitNode = new MultiInstanceInitNode(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityId, "Init"), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, "Init"), activity, multiInstance);
            context.addElementToBlock(multiInstanceInitNode, (ICubeBlock)multiInstanceBlock);
            MultiInstanceLoopNode multiInstanceLoopNode = new MultiInstanceLoopNode(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, MIBLOCK_NODE_SUFFIX_LOOP), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, MIBLOCK_NODE_SUFFIX_LOOP), activity, multiInstance);
            context.addElementToBlock(multiInstanceLoopNode, (ICubeBlock)multiInstanceBlock);
            BPMNMultiInstanceInnerBlock multiInstanceInnerBlock = this.buildSequentialMIInnerBlock(activity, multiInstance, context, bpmnFlowElementVisitor, activityId, activityName, multiInstanceBlock);
            context.addElementToBlock(multiInstanceInnerBlock, (ICubeBlock)multiInstanceBlock);
            MultiInstanceEndNode multiInstanceEndNode = new MultiInstanceEndNode(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, "End"), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, "End"), activity, multiInstance);
            context.addElementToBlock(multiInstanceEndNode, (ICubeBlock)multiInstanceBlock);
            multiInstanceBlock.getSequenceFlowMetadata().addEntryElement(multiInstanceInitNode);
            context.link(multiInstanceInitNode, multiInstanceLoopNode);
            ConditionalFlow loopExpressionSequenceFlow = activity.getProcess().createSequenceFlow().toConditionalFlow();
            loopExpressionSequenceFlow.setSource((FlowNode)activity);
            loopExpressionSequenceFlow.setTarget((FlowNode)activity);
            loopExpressionSequenceFlow.setCondition(multiInstanceLoopNode.getLoopExpression());
            ConditionalSequenceFlowInfo conditionalSequenceFlowInfo = SequenceFlowInfoFactory.createConditional(loopExpressionSequenceFlow, multiInstanceInnerBlock.getId());
            multiInstanceLoopNode.getGatewaySequenceFlowMetadata().addOutgoingSequenceFlow(conditionalSequenceFlowInfo);
            UnconditionalSequenceFlowInfo unconditional = SequenceFlowInfoFactory.createUnconditional(multiInstanceLoopNode + "To" + multiInstanceLoopNode, activity.getId(), activity.getId(), multiInstanceEndNode.getId());
            multiInstanceLoopNode.getGatewaySequenceFlowMetadata().setDefaultOutgoingSequenceFlow(unconditional);
            context.link(multiInstanceInnerBlock, multiInstanceLoopNode);
            context.link(multiInstanceEndNode, multiInstanceBlock);
        }
        finally {
            context.setCurrentBlock(currentBlock);
        }
        return new CompilationResult(activityId, multiInstanceBlock, multiInstanceBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BPMNMultiInstanceInnerBlock buildSequentialMIInnerBlock(Activity activity, MultiInstance multiInstance, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor, String activityId, String activityName, BPMNMultiInstanceBlock multiInstanceBlock) throws CubeException {
        BPMNMultiInstanceInnerBlock multiInstanceInnerBlock = new BPMNMultiInstanceInnerBlock(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityId), MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityName), activity, multiInstance);
        try {
            context.setCurrentBlock(multiInstanceInnerBlock);
            MultiInstanceInnerInitNode multiInstanceInnerInitNode = new MultiInstanceInnerInitNode(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityId, "Init"), MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityName, "Init"), activity, multiInstance);
            context.addElementToBlock(multiInstanceInnerInitNode, (ICubeBlock)multiInstanceInnerBlock);
            CompilationResult compilationResult = super.visit(activity, multiInstance, context, bpmnFlowElementVisitor);
            MultiInstanceInnerEndNode multiInstanceInnerEndNode = new MultiInstanceInnerEndNode(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityId, "End"), MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityName, "End"), activity, multiInstance);
            context.addElementToBlock(multiInstanceInnerEndNode, (ICubeBlock)multiInstanceInnerBlock);
            multiInstanceInnerBlock.getSequenceFlowMetadata().addEntryElement(multiInstanceInnerInitNode);
            context.link(multiInstanceInnerInitNode, compilationResult.getEntryPoint());
            context.link(compilationResult.getExitPoint(), multiInstanceInnerEndNode);
            context.link(multiInstanceInnerEndNode, multiInstanceInnerBlock);
        }
        finally {
            context.setCurrentBlock(multiInstanceBlock);
        }
        return multiInstanceInnerBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationResult buildParallelMIBlock(Activity activity, MultiInstance multiInstance, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor) throws CubeException {
        String activityId = activity.getId();
        String activityName = activity.getName();
        BPMNMultiInstanceBlock multiInstanceBlock = BlockFactory.createMultiInstanceBlock(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityId), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName), activity, multiInstance);
        context.addElementToBlock(multiInstanceBlock, (ICubeBlock)context.getCurrentBlock());
        BaseBPMNActivityBlock currentBlock = context.getCurrentBlock();
        try {
            context.setCurrentBlock(multiInstanceBlock);
            MultiInstanceInitNode multiInstanceInitNode = new MultiInstanceInitNode(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityId, "Init"), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, "Init"), activity, multiInstance);
            context.addElementToBlock(multiInstanceInitNode, (ICubeBlock)multiInstanceBlock);
            BPMNMultiInstanceCompletionConditionBlock multiInstanceCompletionConditionBlock = this.buildSequentialParallelMIInnerBlock(activity, multiInstance, context, bpmnFlowElementVisitor, activityId, activityName, multiInstanceBlock);
            context.addElementToBlock(multiInstanceCompletionConditionBlock, (ICubeBlock)multiInstanceBlock);
            MultiInstanceEndNode multiInstanceEndNode = new MultiInstanceEndNode(context, MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, "End"), MultiInstanceCharacteristicsVisitor.createId(MIBLOCK_PREFIX, activityName, "End"), activity, multiInstance);
            context.addElementToBlock(multiInstanceEndNode, (ICubeBlock)multiInstanceBlock);
            multiInstanceBlock.getSequenceFlowMetadata().addEntryElement(multiInstanceInitNode);
            context.link(multiInstanceInitNode, multiInstanceCompletionConditionBlock);
            context.link(multiInstanceCompletionConditionBlock, multiInstanceEndNode);
            context.link(multiInstanceEndNode, multiInstanceBlock);
        }
        finally {
            context.setCurrentBlock(currentBlock);
        }
        return new CompilationResult(activityId, multiInstanceBlock, multiInstanceBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BPMNMultiInstanceCompletionConditionBlock buildSequentialParallelMIInnerBlock(Activity activity, MultiInstance multiInstance, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor, String activityId, String activityName, BaseBPMNActivityBlock currentBlock) throws CubeException {
        BPMNMultiInstanceCompletionConditionBlock multiInstanceCompletionConditionBlock = new BPMNMultiInstanceCompletionConditionBlock(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERCOMPLETIONCONDITIONBLOCK_PREFIX, activityId), MultiInstanceCharacteristicsVisitor.createId(MIINNERCOMPLETIONCONDITIONBLOCK_PREFIX, activityName), activity, multiInstance);
        try {
            context.setCurrentBlock(multiInstanceCompletionConditionBlock);
            BPMNMultiInstanceInnerBlock multiInstanceInnerBlock = this.buildParallelMIInnerBlock(activity, multiInstance, context, bpmnFlowElementVisitor, activityId, activityName, multiInstanceCompletionConditionBlock);
            context.addElementToBlock(multiInstanceInnerBlock, (ICubeBlock)multiInstanceCompletionConditionBlock);
            multiInstanceCompletionConditionBlock.getSequenceFlowMetadata().addEntryElement(multiInstanceInnerBlock);
            context.link(multiInstanceInnerBlock, multiInstanceCompletionConditionBlock);
        }
        finally {
            context.setCurrentBlock(currentBlock);
        }
        return multiInstanceCompletionConditionBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BPMNMultiInstanceInnerBlock buildParallelMIInnerBlock(Activity activity, MultiInstance multiInstance, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor, String activityId, String activityName, BPMNMultiInstanceCompletionConditionBlock multiInstanceCompletionConditionBlock) throws CubeException {
        BPMNMultiInstanceInnerBlock multiInstanceInnerBlock = new BPMNMultiInstanceInnerBlock(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityId), MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityName), activity, multiInstance);
        try {
            context.setCurrentBlock(multiInstanceInnerBlock);
            MultiInstanceInnerInitNode multiInstanceInnerInitNode = new MultiInstanceInnerInitNode(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityId, "Init"), MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityName, "Init"), activity, multiInstance);
            context.addElementToBlock(multiInstanceInnerInitNode, (ICubeBlock)multiInstanceInnerBlock);
            CompilationResult compilationResult = super.visit(activity, multiInstance, context, bpmnFlowElementVisitor);
            MultiInstanceInnerEndNode multiInstanceInnerEndNode = new MultiInstanceInnerEndNode(context, MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityId, "End"), MultiInstanceCharacteristicsVisitor.createId(MIINNERBLOCK_PREFIX, activityName, "End"), activity, multiInstance);
            context.addElementToBlock(multiInstanceInnerEndNode, (ICubeBlock)multiInstanceInnerBlock);
            multiInstanceInnerBlock.getSequenceFlowMetadata().addEntryElement(multiInstanceInnerInitNode);
            context.link(multiInstanceInnerInitNode, compilationResult.getEntryPoint());
            context.link(compilationResult.getExitPoint(), multiInstanceInnerEndNode);
            context.link(multiInstanceInnerEndNode, multiInstanceInnerBlock);
        }
        finally {
            context.setCurrentBlock(multiInstanceCompletionConditionBlock);
        }
        return multiInstanceInnerBlock;
    }
}

