/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.engine.deployment.DeploymentLogger;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;

public class MeasurementVisitorImpl
implements BPMNFlowElementVisitor<Measurement> {
    final String logClassName = MeasurementVisitorImpl.class.getName();

    @Override
    public CompilationResult visit(Measurement measurementNode, BPMNCubeMapBuilderContext context) {
        String logMethodName = "visit";
        DeploymentLogger.debug((String)this.logClassName, (String)"visit", (Object)"BEGIN");
        switch (measurementNode.getMeasurementType()) {
            case START: {
                this.addMeasureToAuditNode(measurementNode.getTransition().getTarget(), measurementNode, context, Tag.PRE_AUDIT);
                break;
            }
            case STOP: {
                this.addMeasureToAuditNode(measurementNode.getTransition().getSource(), measurementNode, context, Tag.POST_AUDIT_NORMAL);
                break;
            }
            case START_STOP: {
                this.addMeasureToAuditNode(measurementNode.getTransition().getSource(), measurementNode, context, Tag.POST_AUDIT_NORMAL);
                break;
            }
        }
        DeploymentLogger.debug((String)this.logClassName, (String)"visit", (Object)"END");
        return null;
    }

    private void addMeasureToAuditNode(FlowNode flowNode, Measurement measurementNode, BPMNCubeMapBuilderContext context, Tag tag) {
        String logMethodName = "addMeasureToAuditNode";
        MIAuditLog auditMI = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, tag);
        if (auditMI != null) {
            DeploymentLogger.debug((String)this.logClassName, (String)"addMeasureToAuditNode", (Object)("Adding a measurement {" + measurementNode.getMeasurementType().toString() + "} mark for {" + flowNode.getId() + "}"));
            MDAuditLog mdAuditLog = auditMI.getMetadata();
            mdAuditLog.addMeasurementMark(measurementNode);
        } else {
            DeploymentLogger.debug((String)this.logClassName, (String)"addMeasureToAuditNode", (Object)("A measurement was not found for BPMNCubeElement {" + flowNode.getId() + "}"));
        }
    }
}

