/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ActivityCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BPMNLoopBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.LoopConditionNode;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.ConditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfoFactory;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;

public class LoopCharacteristicsVisitor
extends ActivityCharacteristicsVisitor<Activity, Loop> {
    private static final String LOOPBLOCK_PREFIX = "LoopBlock";
    private static final String LOOPBLOCK_NODE_SUFFIX_INIT = "Condition";

    @Override
    public LoopCharacteristicsType getLoopCharacteristicsType() {
        return LoopCharacteristicsType.LOOP;
    }

    @Override
    protected Loop getCharacteristics(Activity activity) {
        return (Loop)activity.getLoopCharacteristics().as(Loop.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompilationResult visit(Activity activity, Loop loop, BPMNCubeMapBuilderContext context, BPMNFlowElementVisitor<Activity> bpmnFlowElementVisitor) throws CubeException {
        String activityId = activity.getId();
        String activityName = activity.getName();
        BaseBPMNActivityBlock currentBlock = context.getCurrentBlock();
        BPMNLoopBlock loopBlock = BlockFactory.createLoopBlock(context, LoopCharacteristicsVisitor.createId(LOOPBLOCK_PREFIX, activityId), LoopCharacteristicsVisitor.createId(LOOPBLOCK_PREFIX, activityName), activity, loop);
        context.addElementToBlock(loopBlock, (ICubeBlock)currentBlock);
        try {
            context.setCurrentBlock(loopBlock);
            LoopConditionNode loopConditionNode = new LoopConditionNode(context, LoopCharacteristicsVisitor.createId(LOOPBLOCK_PREFIX, activityId, LOOPBLOCK_NODE_SUFFIX_INIT), LoopCharacteristicsVisitor.createId(LOOPBLOCK_PREFIX, activityName, LOOPBLOCK_NODE_SUFFIX_INIT), activity, loop);
            context.addElementToBlock(loopConditionNode, (ICubeBlock)loopBlock);
            CompilationResult compilationResult = super.visit(activity, loop, context, bpmnFlowElementVisitor);
            BPMNCubeElement<Activity> loopBlockEntryPoint = loop.isTestBefore() ? loopConditionNode : compilationResult.getEntryPoint();
            loopBlock.getSequenceFlowMetadata().setEntryElements(Collections.singletonList(loopBlockEntryPoint));
            UnconditionalSequenceFlowInfo unconditional = SequenceFlowInfoFactory.createUnconditional(loopConditionNode + "To" + loopBlock, activity.getId(), activity.getId(), loopBlock.getId());
            loopConditionNode.getGatewaySequenceFlowMetadata().setDefaultOutgoingSequenceFlow(unconditional);
            ConditionalFlow loopConditionSequenceFlow = activity.getProcess().createSequenceFlow().toConditionalFlow();
            loopConditionSequenceFlow.setSource((FlowNode)activity);
            loopConditionSequenceFlow.setTarget((FlowNode)activity);
            Expression loopExpression = loop.getLoopExpression();
            if (loop.hasLoopMaximum()) {
                String expressionValue = loopExpression.getExpressionValue();
                Map<String, URI> namespaces = new HashMap();
                if (!loopExpression.getNamespaces().containsKey("bpmn")) {
                    namespaces.putAll(loopExpression.getNamespaces());
                    try {
                        namespaces.put("bpmn", new URI("http://www.omg.org/bpmn20"));
                    }
                    catch (URISyntaxException e) {}
                } else {
                    namespaces = loopExpression.getNamespaces();
                }
                loopExpression = new XPathExpression("(" + expressionValue + ") and bpmn:" + "getActivityInstanceAttribute" + "(\"" + activityId + "\", \"" + PredefinedVariablesHelper.LOOP_COUNTER.getName() + "\") <= " + ((Loop)loopConditionNode.getRuntimeHelper().getCharacteristics()).getLoopMaximum(), namespaces);
            }
            loopConditionSequenceFlow.setCondition(loopExpression);
            ConditionalSequenceFlowInfo conditionalSequenceFlowInfo = SequenceFlowInfoFactory.createConditional(loopConditionSequenceFlow, compilationResult.getEntryPoint().getId());
            loopConditionNode.getGatewaySequenceFlowMetadata().addOutgoingSequenceFlow(conditionalSequenceFlowInfo);
            context.link(compilationResult.getExitPoint(), loopConditionNode);
        }
        finally {
            context.setCurrentBlock(currentBlock);
        }
        return new CompilationResult(activityId, loopBlock, loopBlock);
    }
}

