/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.Fault;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.project.interfaces.ProcessUtil;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;

public class EventCompilationResult
extends CompilationResult {
    private Set<QName> faultHandlerErrorCodes;
    private String faultHanlderId;
    private boolean isDefaultHandler;
    private boolean isErrorHandler;

    private EventCompilationResult(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint) {
        super(activityId, entryPoint, exitPoint);
    }

    private EventCompilationResult(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, boolean isDefaultHandler) {
        this(activityId, entryPoint, exitPoint, isErrorHandler, isDefaultHandler, null, null);
    }

    private EventCompilationResult(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, boolean isDefaultHandler, String faultHandlerId, Set<QName> faultHandlerErrorCodes) {
        super(activityId, entryPoint, exitPoint);
        this.setErrorHandler(isErrorHandler);
        this.setDefaultHandler(isDefaultHandler);
        this.faultHanlderId = faultHandlerId;
        this.faultHandlerErrorCodes = faultHandlerErrorCodes;
    }

    public static EventCompilationResult create(BPMNCubeElement node) {
        return EventCompilationResult.create(node, null);
    }

    public static EventCompilationResult create(BPMNCubeElement node, String handlerId) {
        Object element = node.getFlowElement();
        Event event = (Event)element.asAnyNode(Event.class);
        if (event != null) {
            if (event.getEventTriggerType() == EventTriggerType.ERROR) {
                boolean isDefaultHandler;
                ErrorObject errorObject = ((ErrorEventDefinition)event.getEventDefinition().as(ErrorEventDefinition.class)).getError();
                Set<QName> errorCodes = null;
                if (errorObject != null) {
                    errorCodes = ProcessUtil.getProjectErrorQNames((Project)element.getProject()).getErrorQNames(errorObject);
                    isDefaultHandler = false;
                } else {
                    isDefaultHandler = true;
                }
                if (errorCodes == null) {
                    errorCodes = Collections.emptySet();
                }
                return EventCompilationResult.create(event.getId(), node, node, true, isDefaultHandler, handlerId, errorCodes);
            }
            return EventCompilationResult.create(event.getId(), node, node, false, false);
        }
        return null;
    }

    public static EventCompilationResult create(CompilationResult compilationResult, boolean isErrorHandler, boolean isDefaultHandler) {
        EventCompilationResult result = new EventCompilationResult(compilationResult.getActivityId(), compilationResult.getEntryPoint(), compilationResult.getExitPoint());
        result.setErrorHandler(isErrorHandler);
        result.setDefaultHandler(isDefaultHandler);
        return result;
    }

    public static EventCompilationResult create(CompilationResult compilationResult) {
        return EventCompilationResult.create(compilationResult, false, false);
    }

    public static EventCompilationResult create(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, boolean isDefaultHandler) {
        return EventCompilationResult.create(activityId, entryPoint, exitPoint, isErrorHandler, isDefaultHandler, null, null);
    }

    public static EventCompilationResult create(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, boolean isDefaultHandler, String faultHandlerId, Set<QName> faultHandlerErrorCodes) {
        return new EventCompilationResult(activityId, entryPoint, exitPoint, isErrorHandler, isDefaultHandler, faultHandlerId, faultHandlerErrorCodes);
    }

    public boolean isErrorHandler() {
        return this.isErrorHandler;
    }

    public void setErrorHandler(boolean errorHandler) {
        this.isErrorHandler = errorHandler;
    }

    public FaultHandler createFaultHandler() {
        return new FaultHandler(){

            @Override
            public boolean handles(Fault fault) {
                return EventCompilationResult.this.isDefaultHandler && !this.isSystemFault(fault.getErrorCode()) || !EventCompilationResult.this.isDefaultHandler && EventCompilationResult.this.faultHandlerErrorCodes.contains(fault.getErrorCode());
            }

            private boolean isSystemFault(QName errorCode) {
                String faultNamespace = errorCode.getNamespaceURI();
                return faultNamespace.equals("http://schemas.xmlsoap.org/ws/2003/03/business-process/") || faultNamespace.equals("http://schemas.oracle.com/bpel/extension");
            }

            @Override
            public String getId() {
                if (EventCompilationResult.this.faultHanlderId != null) {
                    return EventCompilationResult.this.faultHanlderId;
                }
                return EventCompilationResult.this.getEntryPoint().getId();
            }
        };
    }

    public boolean isDefaultHandler() {
        return this.isDefaultHandler;
    }

    public void setDefaultHandler(boolean defaultHandler) {
        this.isDefaultHandler = defaultHandler;
    }
}

