/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNGatewayVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BPMNFlowElementRegistry;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.EventBasedGatewayBlock;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;

public class EventBasedGatewayVisitorImpl
extends AbstractBPMNGatewayVisitor<EventBasedGateway> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationResult visitElement(EventBasedGateway gateway, BPMNCubeMapBuilderContext context) throws CubeException {
        String activityId = gateway.getId();
        String activityName = gateway.getName();
        EventBasedGatewayBlock<EventBasedGateway> eventBasedGatewayBlock = BlockFactory.createEventBasedGatewayBlock(context, activityName, gateway);
        context.addElementToCurrentBlock(eventBasedGatewayBlock);
        BaseBPMNActivityBlock oldCurrentBlock = context.getCurrentBlock();
        context.setCurrentBlock(eventBasedGatewayBlock);
        context.setCompilingInstantiateBlock(gateway.isInstantiate());
        try {
            for (SequenceFlow sequenceFlow : gateway.getOutgoingSequenceFlows()) {
                FlowNode target = sequenceFlow.getTarget();
                BPMNFlowElementVisitor<FlowNode> elementVisitor = BPMNFlowElementRegistry.getVisitor(target.getBpmnType());
                if (elementVisitor != null) {
                    CompilationResult result = elementVisitor.visit(target, context);
                    eventBasedGatewayBlock.getSequenceFlowMetadata().addEntryElement(result.getEntryPoint());
                    for (SequenceFlow targetSequenceFlow : target.getOutgoingSequenceFlows()) {
                        BPMNFlowElementRegistry.getVisitor().visit(targetSequenceFlow, context);
                    }
                    continue;
                }
                System.out.println("Skipping visitor for -> " + target);
            }
        }
        finally {
            context.unsetCompilingInstantiateBlock();
            context.setCurrentBlock(oldCurrentBlock);
        }
        return new CompilationResult(activityId, eventBasedGatewayBlock, eventBasedGatewayBlock);
    }

    @Override
    protected boolean createPostAuditLogNode(EventBasedGateway element) {
        return false;
    }
}

