/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractEventTriggerTypeVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIMetadata;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class ErrorEventVisitorImpl
extends MIAbstractEventTriggerTypeVisitor<Event> {
    @Override
    protected MIVisitor<CompilationResult> doCompileCatch(BPMNCubeMapBuilderContext context, CatchEvent event) throws CubeException {
        DataAssociationSet outputDataAssociationSet = event.getOutputDataAssociationSet();
        final MDExceptionCatch mdExceptionCatch = new MDExceptionCatch(outputDataAssociationSet, ((ErrorEventDefinition)event.getEventDefinition().as(ErrorEventDefinition.class)).isCatchAll());
        return new SimpleVisitorImpl<CatchEvent, CompilationResult>(event, context){

            @Override
            public AbstractCompiler getCompiler(final AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<CatchEvent>((CatchEvent)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        MISequenceBlock block = new MISequenceBlock();
                        AuditTrailVisitorHelper.createAndAddPreAuditMI(this.getContext(), this.getElement(), delegator, block);
                        block.addMicroInstruction(new MIExceptionCatch(mdExceptionCatch));
                        block.addMicroInstruction(new MIMarkAsComplete());
                        AuditTrailVisitorHelper.createAndAddPostAuditMI(this.getContext(), this.getElement(), delegator, block);
                        return block;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MIAssertFalse();
                    }
                };
            }

            @Override
            protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                return EventCompilationResult.create(node);
            }
        };
    }

    @Override
    protected MIVisitor<CompilationResult> doCompileThrow(BPMNCubeMapBuilderContext context, ThrowEvent throwEvent) throws CubeException {
        assert (throwEvent.getEventTriggerType() == EventTriggerType.ERROR) : throwEvent.getId() + " must be a Error event but is->" + throwEvent.getEventTriggerType();
        ErrorEventDefinition eventDefinition = (ErrorEventDefinition)throwEvent.getEventDefinition().as(ErrorEventDefinition.class);
        DataAssociationSet inputDataAssociationSet = throwEvent.getInputDataAssociationSet();
        final MDExceptionThrow mdExceptionThrow = new MDExceptionThrow(eventDefinition, inputDataAssociationSet);
        DataHandlingUtils.handleIoSpecificationImports(throwEvent.getInputDataAssociationSet(), context);
        return new SimpleVisitorImpl<ThrowEvent, CompilationResult>(throwEvent, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<ThrowEvent>((ThrowEvent)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return new MIExceptionThrow(mdExceptionThrow);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MIAssertFalse();
                    }
                };
            }

            @Override
            protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                return EventCompilationResult.create(activityId, node, node, false, false);
            }
        };
    }

    private static class MIExceptionThrow
    extends MIBase<Object> {
        private MDExceptionThrow mdExceptionThrow;

        public MIExceptionThrow(MDExceptionThrow mdExceptionThrow) {
            this.mdExceptionThrow = mdExceptionThrow;
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            BPELFault fault;
            ErrorObject error = this.mdExceptionThrow.getEventDefinition().getError();
            String processNamespace = context.getNode().getFlowElement().getProcess().getNamespace();
            QName errorCode = this.getActualErrorCodeQName(error, processNamespace);
            QName messageQName = error.getMessageQName();
            IWorkItem wi = context.getWorkItem();
            ICubeContext ctx = context.getCubeContext();
            IScope sc = wi.getScope();
            Map<String, DataElementVariable> parts = DataHandlingUtils.processInputData(context.getNode().getFlowElement(), this.mdExceptionThrow.getInputDataAssociationSet(), sc, ctx, wi);
            if (parts.isEmpty()) {
                fault = BPELWMPHelper.createBPELFault((QName)errorCode, (QName)messageQName, (Element)null, (ICubeContext)ctx);
            } else if (parts.size() == 1) {
                Map.Entry<String, DataElementVariable> part = parts.entrySet().iterator().next();
                DataElementVariable dataElementVariable = part.getValue();
                Object value = dataElementVariable.getValue();
                fault = BPELWMPHelper.createBPELFault((QName)errorCode, (QName)messageQName, (Element)((Element)value), (ICubeContext)ctx);
            } else {
                fault = this.createBPELFault(errorCode, messageQName, parts);
            }
            throw fault;
        }

        private BPELFault createBPELFault(QName errorCode, QName messageQName, Map<String, DataElementVariable> parts) {
            BPELFault bf = new BPELFault(errorCode, messageQName);
            for (Map.Entry<String, DataElementVariable> entry : parts.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue().getValue();
                bf.setPart(name, value);
            }
            return bf;
        }

        private QName getActualErrorCodeQName(@NotNull ErrorObject error, @NotNull String processNamespace) {
            QName result = error.getErrorCode();
            if (!error.isErrorDefinedExternally()) {
                result = new QName(processNamespace, error.getErrorCode().getLocalPart());
            }
            return result;
        }
    }

    private static class MIExceptionCatch
    extends MIBase<Object> {
        private MDExceptionCatch mdExceptionCatch;

        public MIExceptionCatch(MDExceptionCatch mdExceptionCatch) {
            this.mdExceptionCatch = mdExceptionCatch;
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            ICubeContext ctx = context.getCubeContext();
            IScope sc = wi.getScope();
            DataAssociationSet dataAssociationSet = this.mdExceptionCatch.getOutputDataAssociationSet();
            BPELFault fault = BPMNTokenMetadataUtils.getFault(wi.getNodeActivationContext());
            if (!this.mdExceptionCatch.isCatchAll() && !this.mdExceptionCatch.getOutputDataAssociationSet().getDataAssociations().isEmpty()) {
                if (fault.getParts().isEmpty()) {
                    throw new RuntimeException("No part found in fault");
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                if (fault.getParts().size() == 1) {
                    Object partValue = fault.getParts().values().iterator().next();
                    data.put(((DataDeclaration)this.mdExceptionCatch.getOutputDataAssociationSet().getArguments().iterator().next()).getNativeName(), partValue);
                } else {
                    for (DataDeclaration dataDeclaration : this.mdExceptionCatch.getOutputDataAssociationSet().getArguments()) {
                        String nativeName = dataDeclaration.getNativeName();
                        Object partValue = fault.getPart(nativeName);
                        data.put(nativeName, partValue);
                    }
                }
                DataHandlingUtils.processOutputData(context.getNode().getFlowElement(), dataAssociationSet, sc, ctx, data, wi);
            }
            return null;
        }
    }

    private static class MDExceptionThrow
    implements MIMetadata {
        private ErrorEventDefinition eventDefinition;
        private DataAssociationSet inputDataAssociationSet;

        public MDExceptionThrow(ErrorEventDefinition eventDefinition, DataAssociationSet inputDataAssociationSet) {
            this.eventDefinition = eventDefinition;
            this.inputDataAssociationSet = inputDataAssociationSet;
        }

        public ErrorEventDefinition getEventDefinition() {
            return this.eventDefinition;
        }

        public DataAssociationSet getInputDataAssociationSet() {
            return this.inputDataAssociationSet;
        }
    }

    private static class MDExceptionCatch
    implements MIMetadata {
        private final boolean catchAll;
        private DataAssociationSet outputDataAssociationSet;

        public MDExceptionCatch(DataAssociationSet outputDataAssociationSet, boolean isCatchAll) {
            this.outputDataAssociationSet = outputDataAssociationSet;
            this.catchAll = isCatchAll;
        }

        public DataAssociationSet getOutputDataAssociationSet() {
            return this.outputDataAssociationSet;
        }

        public boolean isCatchAll() {
            return this.catchAll;
        }
    }
}

