/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.engine.deployment.DeploymentLogger;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Counter;

public class CounterVisitorImpl
implements BPMNFlowElementVisitor<Counter> {
    private static final String logClassName = CounterVisitorImpl.class.getName();

    @Override
    public CompilationResult visit(Counter counterNode, BPMNCubeMapBuilderContext context) {
        String logMethodName = "visit";
        Activity flowNode = counterNode.getActivity();
        MIAuditLog auditMI = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, Tag.POST_AUDIT_NORMAL);
        if (auditMI != null) {
            DeploymentLogger.debug((String)logClassName, (String)"visit", (Object)("Adding a counter for {" + flowNode.getId() + "}"));
            MDAuditLog mdAuditLog = auditMI.getMetadata();
            mdAuditLog.addCounter(counterNode);
        } else {
            DeploymentLogger.debug((String)logClassName, (String)"visit", (Object)("A counter was not found for BPMNCubeElement {" + flowNode.getId() + "}"));
        }
        return null;
    }
}

