/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.PropertyModel;
import org.jetbrains.annotations.Nullable;

public final class ComponentPropertiesHelper {
    private static final String BPEL_PARTNER_LINK = "bpel.partnerLink.";

    public static void nonBlockingInvoke(Activity activity, String referenceName, BPMNCubeMapBuilderContext context) {
        if (ComponentPropertiesHelper.containsAsynchBoundaryEvents(activity)) {
            context.getComponentModel().getProperties().add(new PropertyModel(ComponentPropertiesHelper.getNonBlockingInvokeKey(referenceName), "true"));
        }
    }

    public static boolean isNonBlockingInvoke(ComponentModel componentModel, String referenceName) {
        PropertyModel propertyModel = componentModel.getProperty(ComponentPropertiesHelper.getNonBlockingInvokeKey(referenceName));
        boolean result = false;
        if (propertyModel != null) {
            result = Boolean.valueOf(propertyModel.getValue());
        }
        return result;
    }

    private static boolean containsAsynchBoundaryEvents(Activity activity) {
        Sequence asynchEvents = activity.getActivityBoundaryEvents().select((Predicate)new Predicate<BoundaryEvent>(){

            public boolean check(@Nullable BoundaryEvent value) {
                boolean result = false;
                if (value != null) {
                    EventTriggerType type = value.getEventTriggerType();
                    result = type == EventTriggerType.TIMER || type == EventTriggerType.MESSAGE || type == EventTriggerType.SIGNAL;
                }
                return result;
            }
        });
        return !asynchEvents.isEmpty();
    }

    private static String getNonBlockingInvokeKey(String referenceName) {
        return BPEL_PARTNER_LINK + referenceName + "." + "nonBlockingInvoke";
    }
}

