/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilder;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.ModelCreator;
import oracle.bpm.bpmn.engine.map.builder.ModelCreatorFactoryHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.blocks.BPMNCallableProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public class CallActivityVisitorImpl
extends AbstractBPMNActivityVisitor<CallActivity> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompilationResult visitActivity(CallActivity element, BPMNCubeMapBuilderContext context, ICubeBlock parentBlock) throws CubeException {
        String activityName = element.getName();
        String calleeProcessName = element.getCalledElementName();
        CompilationResult resultPreCall = this.createPreCallNode(element, context);
        BPMNCallableProcessBlock scopeBlock = BlockFactory.createCallableProcessBlock(context, activityName, element);
        context.addElementToBlock(scopeBlock, parentBlock);
        BaseBPMNActivityBlock oldCurrentBlock = context.getCurrentBlock();
        context.setCurrentBlock(scopeBlock);
        context.pushContext(element.getProcess().getId() + "_" + element.getId() + "_");
        try {
            ModelCreator calleeModelCreator = ModelCreatorFactoryHelper.getFactory().getModelCreator(context.getComponentModel(), calleeProcessName);
            Process calleeProcess = calleeModelCreator.createModel();
            BPMNCubeMapBuilder.buildMaps(calleeProcess, context);
        }
        finally {
            context.popContext();
            context.setCurrentBlock(oldCurrentBlock);
        }
        CompilationResult resultPostCall = this.createPostCallNode(element, context);
        context.link(resultPreCall.getExitPoint(), scopeBlock);
        context.link(scopeBlock, resultPostCall.getEntryPoint());
        return new CompilationResult(element.getId(), resultPreCall.getEntryPoint(), resultPostCall.getExitPoint());
    }

    private CompilationResult createPreCallNode(CallActivity element, BPMNCubeMapBuilderContext context) throws CubeException {
        SimpleVisitorImpl<CallActivity, CompilationResult> visitor = new SimpleVisitorImpl<CallActivity, CompilationResult>(element, context){

            @Override
            protected MIBPMNActivityNode createNode(BPMNCubeMapBuilderContext context, String activityName) {
                return new MIBPMNActivityNode(context, "PreCall", activityName, ((CallActivity)this.getElement()).getBpmnType(), this.getElement());
            }

            @Override
            protected AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<CallActivity>((CallActivity)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        MISequenceBlock block = new MISequenceBlock();
                        block.addMicroInstruction(new MIProcessInputDataAssociation(((CallActivity)this.getElement()).getInputDataAssociationSet()));
                        block.addMicroInstruction(new MIMarkAsComplete());
                        return block;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MIAssertFalse();
                    }
                };
            }
        };
        return visitor.visit((ICubeBlock)context.getCurrentBlock());
    }

    private CompilationResult createPostCallNode(CallActivity element, BPMNCubeMapBuilderContext context) throws CubeException {
        SimpleVisitorImpl<CallActivity, CompilationResult> visitor = new SimpleVisitorImpl<CallActivity, CompilationResult>(element, context){

            @Override
            protected MIBPMNActivityNode createNode(BPMNCubeMapBuilderContext context, String activityName) {
                return new MIBPMNActivityNode(context, "PostCall", activityName, ((CallActivity)this.getElement()).getBpmnType(), this.getElement());
            }

            @Override
            protected AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<CallActivity>((CallActivity)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        MISequenceBlock block = new MISequenceBlock();
                        block.addMicroInstruction(new MIProcessOutputDataAssociation(((CallActivity)this.getElement()).getOutputDataAssociationSet()));
                        block.addMicroInstruction(new MIMarkAsComplete());
                        return block;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MIAssertFalse();
                    }
                };
            }
        };
        return visitor.visit((ICubeBlock)context.getCurrentBlock());
    }

    protected static class MIProcessOutputDataAssociation
    extends MIBase<Object> {
        protected DataAssociationSet dataAssociationSet;

        public MIProcessOutputDataAssociation(DataAssociationSet dataAssociationSet) {
            this.dataAssociationSet = dataAssociationSet;
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            ICubeContext ctx = context.getCubeContext();
            IScope sc = wi.getScope();
            Map data = (Map)context.removeTokenMetadataProperty("dataVariables");
            DataHandlingUtils.processOutputData(context.getNode().getFlowElement(), this.dataAssociationSet, sc, ctx, data, wi);
            return null;
        }
    }

    protected static class MIProcessInputDataAssociation
    extends MIBase<Object> {
        protected DataAssociationSet dataAssociationSet;

        public MIProcessInputDataAssociation(DataAssociationSet dataAssociationSet) {
            this.dataAssociationSet = dataAssociationSet;
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            ICubeContext ctx = context.getCubeContext();
            IScope sc = wi.getScope();
            Map<String, DataElementVariable> map = DataHandlingUtils.processInputData(context.getNode().getFlowElement(), this.dataAssociationSet, sc, ctx, wi);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (Map.Entry<String, DataElementVariable> entry : map.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue().getValue());
            }
            context.setPropertyToAddInTokenMetadata("dataVariables", resultMap);
            return null;
        }
    }
}

