/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentException;
import java.util.Locale;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ComponentPropertiesHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractBPMNActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIBusinessRuleTaskRequest;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIBusinessRuleTaskResponse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvoke;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ServiceInteractionUtils;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.WireModel;

public class BusinessRuleTaskVisitorImpl
extends MIAbstractBPMNActivityVisitor<BusinessRuleTask> {
    @Override
    protected MIVisitor<CompilationResult> createMIVisitor(BusinessRuleTask businessRuleTask, BPMNCubeMapBuilderContext context) throws CubeException {
        final String referenceName = ServiceInteractionUtils.obtainReferenceName(businessRuleTask);
        ComponentModel model = context.getComponentModel();
        String sourceWire = model.getName() + "/" + referenceName;
        WireModel wireModel = model.getComposite().getWire(sourceWire);
        if (wireModel == null) {
            Object[] obj = new Object[]{businessRuleTask.getLabel(Locale.getDefault()) + "[" + businessRuleTask.getId() + "]", sourceWire};
            throw new DeploymentException(78000, obj);
        }
        final String serviceName = wireModel.getTargetService();
        final String targetNameSpace = "http://xmlns.oracle.com/" + wireModel.getTarget() + "/" + serviceName;
        context.addServiceLinkDeclaration(referenceName);
        DataHandlingUtils.handleIoSpecificationImports(businessRuleTask.getInputDataAssociationSet(), context);
        ComponentPropertiesHelper.nonBlockingInvoke((Activity)businessRuleTask, referenceName, context);
        String inputVariable = businessRuleTask.getDefaultLabel() + "_" + businessRuleTask.getId() + "_in";
        String outputVariable = businessRuleTask.getDefaultLabel() + "_" + businessRuleTask.getId() + "_out";
        final MDServiceTask mdServiceTask = new MDServiceTask(inputVariable, outputVariable, businessRuleTask.getOutputDataAssociationSet(), businessRuleTask.getInputDataAssociationSet(), businessRuleTask.getOutputArgumentsContainer(), businessRuleTask.getInputArgumentsContainer(), this.getOperationReference(targetNameSpace), referenceName, null, null, (FlowNode)businessRuleTask);
        return new SimpleVisitorImpl<BusinessRuleTask, CompilationResult>(businessRuleTask, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<BusinessRuleTask>((BusinessRuleTask)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MDVariableDeclaration mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MISequenceBlock result = new MISequenceBlock();
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdOutputVarDeclaration));
                        result.addMicroInstruction(new MIBusinessRuleTaskRequest(mdServiceTask, targetNameSpace, referenceName, serviceName));
                        result.addMicroInstruction(new MIInvoke(mdServiceTask));
                        result.addMicroInstruction(new MIBusinessRuleTaskResponse(mdServiceTask, targetNameSpace, referenceName, serviceName));
                        return result;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MINop();
                    }
                };
            }
        };
    }

    private OperationReference getOperationReference(String namespace) {
        Object operationName = null;
        QName portType = new QName(namespace, "IDecisionService");
        QName inputMessage = new QName(namespace, "callFunctionStatelessMessage");
        QName responseMessage = new QName(namespace, "callFunctionStatelessDecisionMessage");
        QName faultMessage = new QName(namespace, "decisionServiceError");
        MDOperationRef operationRef = new MDOperationRef("payload", "callFunctionStateless", inputMessage, true, portType, responseMessage, null, faultMessage);
        return operationRef;
    }
}

