/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateNextTokensCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.InstanceAttributeSupport;
import oracle.bpm.bpmn.engine.model.runtime.LoopRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.MultiInstanceRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import org.jetbrains.annotations.Nullable;

public class AuditTrailVisitorHelper {
    private static final String logClassName = AbstractBPMNElementVisitor.class.getName();

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPreAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPreAuditMI(context, element);
        AuditTrailVisitorHelper.addAuditMicroInstruction(auditMI, block, element, Tag.PRE_AUDIT, node);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, Tag.POST_AUDIT_NORMAL);
        AuditTrailVisitorHelper.addAuditMicroInstruction(auditMI, block, element, Tag.POST_AUDIT_NORMAL, node);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block, Tag tag) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, tag);
        AuditTrailVisitorHelper.addAuditMicroInstruction(auditMI, block, element, tag, node);
        return auditMI;
    }

    public static <T extends FlowNode> BPMNCubeElement<T> createPreAuditLogNode(BPMNCubeMapBuilderContext context, T element, boolean addNode) throws CubeException {
        MDAuditLog mdAuditLog = AuditTrailVisitorHelper.getPreAuditMD(context, element);
        IMicroInstruction<Object> microinstruction = AuditTrailVisitorHelper.createPreAuditMI(mdAuditLog);
        return AuditTrailVisitorHelper.createAuditLogNode(context, "preAuditLog", element, microinstruction, Tag.PRE_AUDIT, addNode);
    }

    public static <T extends FlowNode> BPMNCubeElement<T> createPostAuditLogNode(BPMNCubeMapBuilderContext context, T element, boolean addNode) throws CubeException {
        MDAuditLog mdAuditLog = AuditTrailVisitorHelper.getPostAuditMD(context, element, Tag.POST_AUDIT_NORMAL);
        IMicroInstruction<Object> microinstruction = AuditTrailVisitorHelper.createPostAuditMI(mdAuditLog);
        return AuditTrailVisitorHelper.createAuditLogNode(context, "postAuditLog", element, microinstruction, Tag.POST_AUDIT_NORMAL, addNode);
    }

    public static <T extends FlowNode> MIAuditLog getAuditlogMicroInstruction(BPMNCubeMapBuilderContext context, T flowNode, Tag tag) {
        BPMNCubeElement node = context.getElementByTag(TagInfo.createTagInfo(flowNode.getId(), tag));
        if (node == null) {
            node = tag == Tag.PRE_AUDIT ? context.getElementByTag(TagInfo.createTagInfo(flowNode.getId(), Tag.ENTRY_POINT)) : context.getElementByTag(TagInfo.createTagInfo(flowNode.getId(), Tag.EXIT_POINT));
        }
        MIAuditLog auditMI = (MIAuditLog)node.getMicroInstruction(flowNode.getId() + tag.toString());
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPreAuditMI(BPMNCubeMapBuilderContext context, T element, AbstractCompiler.RegisterDelegator delegator, @Nullable MISequenceBlock block) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPreAuditMI(context, element);
        AuditTrailVisitorHelper.addAuditMicroInstruction(auditMI, block, element, Tag.PRE_AUDIT, delegator);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, AbstractCompiler.RegisterDelegator delegator, @Nullable MISequenceBlock block) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, Tag.POST_AUDIT_NORMAL);
        AuditTrailVisitorHelper.addAuditMicroInstruction(auditMI, block, element, Tag.POST_AUDIT_NORMAL, delegator);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, AbstractCompiler.RegisterDelegator delegator, @Nullable MISequenceBlock block, Tag tag) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, tag);
        AuditTrailVisitorHelper.addAuditMicroInstruction(auditMI, block, element, tag, delegator);
        return auditMI;
    }

    private static <T extends FlowNode> IMicroInstruction<Object> createPreAuditMI(BPMNCubeMapBuilderContext context, T element) {
        return AuditTrailVisitorHelper.createPreAuditMI(AuditTrailVisitorHelper.getPreAuditMD(context, element));
    }

    private static <T extends FlowNode> IMicroInstruction<Object> createPostAuditMI(BPMNCubeMapBuilderContext context, T element, Tag tag) {
        return AuditTrailVisitorHelper.createPostAuditMI(AuditTrailVisitorHelper.getPostAuditMD(context, element, tag));
    }

    private static <T extends FlowNode> void addAuditMicroInstruction(IMicroInstruction<Object> microInstruction, @Nullable MISequenceBlock block, T flowNode, Tag tag, BPMNCubeElement<T> node) {
        if (block != null) {
            block.addMicroInstruction(microInstruction);
        }
        node.addMicroInstruction(flowNode.getId() + tag.toString(), microInstruction);
    }

    private static <T extends FlowNode> void addAuditMicroInstruction(IMicroInstruction<Object> microInstruction, @Nullable MISequenceBlock block, T flowNode, Tag tag, AbstractCompiler.RegisterDelegator delegator) {
        if (block != null) {
            block.addMicroInstruction(microInstruction);
        }
        delegator.register(microInstruction, flowNode.getId() + tag.toString());
    }

    private static IMicroInstruction<Object> createPreAuditMI(MDAuditLog metadata) {
        return new MIAuditLog(metadata);
    }

    private static IMicroInstruction<Object> createPostAuditMI(MDAuditLog metadata) {
        return new MIAuditLog(metadata);
    }

    private static <T extends FlowNode> MDAuditLog getPreAuditMD(BPMNCubeMapBuilderContext context, T element) {
        boolean isInstanceCreated = AuditTrailVisitorHelper.isCreateInstance(element);
        AuditInstanceOperation operation = isInstanceCreated ? AuditInstanceOperation.INSTANCE_CREATED : AuditInstanceOperation.FLOW_NODE_IN;
        boolean isInSubprocess = AuditTrailVisitorHelper.isInSubprocess(element);
        InstanceAttributeSupport loopCountAttr = AuditTrailVisitorHelper.getLoopAttr(element, isInSubprocess);
        InstanceAttributeSupport instanceCountAttr = AuditTrailVisitorHelper.getInstanceAttr(element, isInSubprocess);
        String compositeDN = null;
        if (context.getComponentModel() != null && context.getComponentModel().getComposite() != null) {
            compositeDN = context.getComponentModel().getComposite().getDN();
        }
        MDAuditLog mdAuditLog = new MDAuditLog("BPMN", operation, true, isInstanceCreated, false, loopCountAttr, instanceCountAttr, isInSubprocess, element, compositeDN);
        mdAuditLog.setAuditQueryMetadata(AuditTrailVisitorHelper.getAuditVariableMetadata(context));
        return mdAuditLog;
    }

    private static <T extends FlowNode> MDAuditLog getPostAuditMD(BPMNCubeMapBuilderContext context, T element, Tag tag) {
        AuditInstanceOperation operation = null;
        boolean isInstanceTerminated = AuditTrailVisitorHelper.isInstanceTerminated(element);
        operation = isInstanceTerminated ? AuditInstanceOperation.INSTANCE_TERMINATED : (tag.equals((Object)Tag.POST_AUDIT_EXCEPTION) ? AuditInstanceOperation.INSTANCE_FAULT : (tag.equals((Object)Tag.POST_AUDIT_CANCEL) ? AuditInstanceOperation.FLOW_NODE_CANCELLED : AuditInstanceOperation.FLOW_NODE_OUT));
        boolean isInSubprocess = AuditTrailVisitorHelper.isInSubprocess(element);
        InstanceAttributeSupport loopCountAttr = AuditTrailVisitorHelper.getLoopAttr(element, isInSubprocess);
        InstanceAttributeSupport instanceCountAttr = AuditTrailVisitorHelper.getInstanceAttr(element, isInSubprocess);
        String compositeDN = null;
        if (context.getComponentModel() != null && context.getComponentModel().getComposite() != null) {
            compositeDN = context.getComponentModel().getComposite().getDN();
        }
        MDAuditLog mdAuditLog = new MDAuditLog("BPMN", operation, false, false, isInstanceTerminated, loopCountAttr, instanceCountAttr, isInSubprocess, element, compositeDN);
        mdAuditLog.setAuditQueryMetadata(AuditTrailVisitorHelper.getAuditVariableMetadata(context));
        return mdAuditLog;
    }

    private static <T extends FlowNode> InstanceAttributeSupport getLoopAttr(T element, boolean isInSubprocess) {
        InstanceAttributeSupport<Integer> loopCountAttr = null;
        LoopCharacteristics loopCharacteristics = null;
        FlowNode fn = null;
        Activity activity = null;
        fn = isInSubprocess ? (FlowNode)element.getParentObject() : (FlowNode)element;
        if (fn instanceof Activity && (loopCharacteristics = (activity = (Activity)fn).getLoopCharacteristics()) != null && loopCharacteristics instanceof Loop) {
            Loop loop = null;
            loop = (Loop)loopCharacteristics.as(Loop.class);
            LoopRuntimeHelper h = new LoopRuntimeHelper((FlowNode)activity, loop);
            loopCountAttr = h.getLoopCounterInstanceAttribute();
        }
        return loopCountAttr;
    }

    private static <T extends FlowNode> InstanceAttributeSupport getInstanceAttr(T element, boolean isInSubprocess) {
        InstanceAttributeSupport<Integer> loopCountAttr = null;
        LoopCharacteristics loopCharacteristics = null;
        FlowNode fn = null;
        Activity activity = null;
        fn = isInSubprocess ? (FlowNode)element.getParentObject() : (FlowNode)element;
        if (fn instanceof Activity && (loopCharacteristics = (activity = (Activity)fn).getLoopCharacteristics()) != null && loopCharacteristics instanceof MultiInstance) {
            MultiInstance multiInstance = null;
            multiInstance = (MultiInstance)loopCharacteristics.as(MultiInstance.class);
            MultiInstanceRuntimeHelper h = new MultiInstanceRuntimeHelper((FlowNode)activity, multiInstance);
            loopCountAttr = h.getLoopCounterInstanceAttribute();
        }
        return loopCountAttr;
    }

    private static <T extends FlowNode> BPMNCubeElement<T> createAuditLogNode(BPMNCubeMapBuilderContext context, final String suffix, final T element, final IMicroInstruction<Object> microinstruction, final Tag tag, boolean addNode) throws CubeException {
        SimpleVisitorImpl visitor = new SimpleVisitorImpl<T, CompilationResult>(element, context){

            @Override
            protected MIBPMNActivityNode<T> createNode(BPMNCubeMapBuilderContext context, String activityName) {
                return new MIBPMNActivityNode(context, suffix, activityName, this.getElement().getBpmnType(), this.getElement());
            }

            @Override
            protected GenerateNextTokensCompiler<T> getGenerateNextTokenCompiler(MIBPMNActivityNode node) {
                return new GenerateNextTokensCompiler<FlowNode>(this.getContext(), node, element);
            }

            @Override
            protected AbstractCompiler getCompiler(final AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<T>((FlowNode)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction generateExecuteStatementMethod() {
                        MISequenceBlock block = new MISequenceBlock();
                        AuditTrailVisitorHelper.addAuditMicroInstruction((IMicroInstruction<Object>)microinstruction, block, this.getElement(), tag, delegator);
                        block.addMicroInstruction(new MIMarkAsComplete());
                        block.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
                        return block;
                    }

                    @Override
                    protected IMicroInstruction generateHandleCallbackMethod() {
                        return new MINop();
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return null;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return null;
                    }
                };
            }
        };
        visitor.setAddElementToCubeMap(addNode);
        Object result = visitor.visit((ICubeBlock)context.getCurrentBlock());
        return ((CompilationResult)result).getEntryPoint();
    }

    private static <T extends FlowNode> boolean isCreateInstance(T node) {
        return node.getParentObject() == node.getProcess() && !node.getProcess().isCallableSubprocess() && (node.getBpmnType() == BpmnType.START_EVENT || node.getBpmnType() == BpmnType.RECEIVE_TASK && ((ReceiveTask)node.asAnyNode(ReceiveTask.class)).isInstantiate() || node.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY && ((EventBasedGateway)node).isInstantiate());
    }

    private static <T extends FlowNode> boolean isInstanceTerminated(T node) {
        return node.getParentObject() == node.getProcess() && !node.getProcess().isCallableSubprocess() && node.getBpmnType() == BpmnType.END_EVENT;
    }

    private static <T extends FlowNode> boolean isInSubprocess(T element) {
        return element.getParentObject() != element.getProcess();
    }

    private static AuditQueryMetadata getAuditVariableMetadata(BPMNCubeMapBuilderContext context) {
        AuditQueryMetadata auditMetadata = null;
        String logMethodName = "insertAuditLogNodes";
        if (context.getComponentModel() != null && context.getComponentModel().getComposite() != null) {
            String compositeDN = context.getComponentModel().getComposite().getDN();
            if (compositeDN != null) {
                try {
                    auditMetadata = AuditServiceFactory.getInstance().getAuditService().getAuditQueryMetadata(compositeDN);
                }
                catch (Exception e) {
                    DeploymentLogger.warn((String)logClassName, (String)"insertAuditLogNodes", (Object)("Unable to obtain the audit metadta " + e));
                }
            } else {
                DeploymentLogger.warn((String)logClassName, (String)"insertAuditLogNodes", (Object)"The compositeDN is null. No variable information can be set.");
            }
        }
        return auditMetadata;
    }
}

