/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AuditLogMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAuditLog;
import oracle.bpm.project.model.processes.Gateway;

public abstract class AbstractBPMNGatewayVisitor<T extends Gateway>
extends AbstractBPMNElementVisitor<T> {
    static final String logClassName = AbstractBPMNGatewayVisitor.class.getName();

    @Override
    protected CompilationResult insertAuditLogNodes(T element, BPMNCubeMapBuilderContext context, CompilationResult result) throws CubeException {
        BPMNCubeElement cubeElement = context.getElementByTag(TagInfo.createTagInfo(result.getActivityId(), Tag.GATEWAY_NODE));
        if (cubeElement instanceof AbstractGatewayNode) {
            AbstractGatewayNode gatewayNode = (AbstractGatewayNode)cubeElement;
            AuditLogMicroInstruction preAuditMI = this.createAuditLog(element, context, true);
            gatewayNode.addMicroInstruction(preAuditMI, 0);
            AuditLogMicroInstruction postAuditMI = this.createAuditLog(element, context, false);
            gatewayNode.addMicroInstruction(postAuditMI, gatewayNode.getMicroInstructions().size());
        } else {
            super.insertAuditLogNodes(element, context, result);
        }
        return result;
    }

    private AuditLogMicroInstruction createAuditLog(T element, BPMNCubeMapBuilderContext context, boolean entryPoint) throws CubeException {
        MIBPMNActivityNode aln = entryPoint ? (MIBPMNActivityNode)AuditTrailVisitorHelper.createPreAuditLogNode(context, element, false) : (MIBPMNActivityNode)AuditTrailVisitorHelper.createPostAuditLogNode(context, element, false);
        context.tagElement(TagInfo.createTagInfo(element.getId(), entryPoint ? Tag.PRE_AUDIT : Tag.POST_AUDIT_NORMAL), aln);
        MIAuditLog auditMI = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, element, entryPoint ? Tag.PRE_AUDIT : Tag.POST_AUDIT_NORMAL);
        return new AuditLogMicroInstruction(auditMI);
    }
}

