/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilerHelper;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.project.model.processes.FlowNode;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBPMNElementVisitor<T extends FlowNode>
implements BPMNFlowElementVisitor<T> {
    private static final String logClassName = AbstractBPMNElementVisitor.class.getName();

    @Override
    @Nullable
    public final CompilationResult visit(T element, BPMNCubeMapBuilderContext context) throws CubeException {
        CompilationResult result = this.visitElement(element, context);
        if (System.getProperty("audit", "true").equals("true")) {
            result = this.insertAuditLogNodes(element, context, result);
        }
        CompilerHelper.tagEntryExitPoints(context, result);
        return result;
    }

    @Nullable
    protected abstract CompilationResult visitElement(T var1, BPMNCubeMapBuilderContext var2) throws CubeException;

    protected CompilationResult insertAuditLogNodes(T element, BPMNCubeMapBuilderContext context, CompilationResult result) throws CubeException {
        String logMethodName = "insertAuditLogNodes";
        DeploymentLogger.debug((String)logClassName, (String)"insertAuditLogNodes", (Object)("BEGIN {" + element.getName() + "} {" + element.getBpmnType().toString() + "}"));
        BPMNCubeElement<T> preAuditLogNode = null;
        if (this.createPreAuditLogNode(element)) {
            DeploymentLogger.debug((String)logClassName, (String)"insertAuditLogNodes", (Object)"Creating preAuditLog");
            preAuditLogNode = AuditTrailVisitorHelper.createPreAuditLogNode(context, element, true);
            context.tagElement(TagInfo.createTagInfo(element.getId(), Tag.PRE_AUDIT), preAuditLogNode);
            context.addElementToBlock(preAuditLogNode, result.getEntryPoint().getParentBlock());
        }
        BPMNCubeElement<T> postAuditLogNode = null;
        if (this.createPostAuditLogNode(element)) {
            DeploymentLogger.debug((String)logClassName, (String)"insertAuditLogNodes", (Object)"Creating postAuditLog");
            postAuditLogNode = AuditTrailVisitorHelper.createPostAuditLogNode(context, element, true);
            context.tagElement(TagInfo.createTagInfo(element.getId(), Tag.POST_AUDIT_NORMAL), postAuditLogNode);
            context.addElementToBlock(postAuditLogNode, result.getExitPoint().getParentBlock());
        }
        CompilationResult compilationResult = this.linkAuditLogNodes(element, context, result, preAuditLogNode, postAuditLogNode);
        DeploymentLogger.debug((String)logClassName, (String)"insertAuditLogNodes", (Object)"END");
        return compilationResult;
    }

    protected boolean createPreAuditLogNode(T element) {
        return this.createAuditLogNodes(element);
    }

    protected boolean createPostAuditLogNode(T element) {
        return this.createAuditLogNodes(element);
    }

    protected boolean createAuditLogNodes(T element) {
        return true;
    }

    protected CompilationResult linkAuditLogNodes(T element, BPMNCubeMapBuilderContext context, CompilationResult result, BPMNCubeElement preAuditLogNode, BPMNCubeElement postAuditLogNode) {
        if (preAuditLogNode != null) {
            context.link(preAuditLogNode, result.getEntryPoint());
            result.setEntryPoint(preAuditLogNode);
        }
        if (postAuditLogNode != null) {
            context.link(result.getExitPoint(), postAuditLogNode);
            result.setExitPoint(postAuditLogNode);
        }
        return result;
    }
}

