/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SubProcessCompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.bpmn.engine.model.common.FaultHandlers;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.type.TypeRef;

public class ModelVisitorUtil {
    public static TypeRef createFakeServiceRef(String serviceName) {
        return new ObjectTypeDescription(serviceName);
    }

    public static boolean isInitiateNode(FlowNode node) {
        return node.getBpmnType() == BpmnType.START_EVENT || node.getBpmnType() == BpmnType.RECEIVE_TASK && ((ReceiveTask)node.asAnyNode(ReceiveTask.class)).isInstantiate() && node.getIncomingSequenceFlows().isEmpty() || node.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY && ((EventBasedGateway)node).isInstantiate() && node.getIncomingSequenceFlows().isEmpty();
    }

    public static boolean isTerminateNode(FlowNode node) {
        return node.getBpmnType() == BpmnType.END_EVENT;
    }

    public static boolean isInlineEventHandler(FlowNode node) {
        return node.getParentObject() instanceof Subprocess && ((Subprocess)node.getParentObject()).isTriggeredByEvent();
    }

    public static boolean isStartOfInlineEventHandler(CatchEvent node) {
        return node.isStart() && ModelVisitorUtil.isInlineEventHandler((FlowNode)node);
    }

    public static boolean isStartOfInlineEventHandlerExceptError(CatchEvent node) {
        return node.isStart() && ModelVisitorUtil.isInlineEventHandler((FlowNode)node) && node.getEventTriggerType() != EventTriggerType.ERROR;
    }

    public static boolean isEndOfInlineEventHandler(ThrowEvent node) {
        return node.isEnd() && ModelVisitorUtil.isInlineEventHandler((FlowNode)node);
    }

    public static boolean isEventHandler(CatchEvent node) {
        return node.isBoundaryEvent() || ModelVisitorUtil.isStartOfInlineEventHandler(node);
    }

    public static boolean isInterrupting(CatchEvent node) {
        return node.isStart() && (((StartEvent)node.asAnyNode(StartEvent.class)).isInterrupting() || node.getEventTriggerType() == EventTriggerType.ERROR) || node.isBoundaryEvent() && ((BoundaryEvent)node.asAnyNode(BoundaryEvent.class)).cancelActivity();
    }

    public static boolean isInterrupting(Subprocess subprocess) {
        for (StartEvent startEvent : subprocess.getEvents(StartEvent.class)) {
            if (!ModelVisitorUtil.isInterrupting((CatchEvent)startEvent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStartOfInlineEventHandlerInterruptingExceptError(FlowNode node) {
        CatchEvent event = (CatchEvent)node.asAnyNode(CatchEvent.class);
        return event != null && ModelVisitorUtil.isStartOfInlineEventHandler(event) && ModelVisitorUtil.isInterrupting(event) && event.getEventTriggerType() != EventTriggerType.ERROR;
    }

    public static boolean isTopLevelStart(FlowNode node) {
        return node.asAnyNode(StartEvent.class) != null && node.getParentObject() == node.getProcess() && !node.getProcess().isCallableSubprocess();
    }

    public static boolean comesFromEventBasedGateway(FlowNode node) {
        SequenceFlow sequenceFlow;
        Sequence incomingFlowsSequence = node.getIncomingSequenceFlows();
        return !incomingFlowsSequence.isEmpty() && (sequenceFlow = (SequenceFlow)incomingFlowsSequence.iterator().next()).getSource().getBpmnType() == BpmnType.EVENT_BASED_GATEWAY;
    }

    public static void processInlineCompilationResult(BPMNCubeMapBuilderContext context, BaseBPMNActivityBlock subProcessBlock, TryBlock tryBlock, List<SubProcessCompilationResult> eventCompilationResult) {
        for (SubProcessCompilationResult result : eventCompilationResult) {
            ModelVisitorUtil.processInlineCompilationResult(context, subProcessBlock, tryBlock, result);
        }
    }

    private static void processInlineCompilationResult(BPMNCubeMapBuilderContext context, BaseBPMNActivityBlock subProcessBlock, TryBlock tryBlock, SubProcessCompilationResult eventCompilationResult) {
        ArrayList<FaultHandler> faultHandlers = new ArrayList<FaultHandler>();
        FaultHandler defaultHandler = null;
        for (EventCompilationResult eventResult : eventCompilationResult.getStartEventCompilationResult()) {
            if (eventResult.isErrorHandler()) {
                if (eventResult.isDefaultHandler()) {
                    defaultHandler = eventResult.createFaultHandler();
                    continue;
                }
                faultHandlers.add(eventResult.createFaultHandler());
                continue;
            }
            subProcessBlock.getSequenceFlowMetadata().addEntryElement(eventCompilationResult.getEntryPoint());
        }
        if (tryBlock != null) {
            FaultHandlers faultHanldersImpl = tryBlock.getFaultHandlers();
            if (faultHanldersImpl == null) {
                faultHanldersImpl = new FaultHandlersImpl(faultHandlers, defaultHandler);
            } else {
                ((FaultHandlersImpl)faultHanldersImpl).addFaultHandlers(faultHandlers);
                ((FaultHandlersImpl)faultHanldersImpl).setDefaultHandler(defaultHandler);
            }
            tryBlock.setFaultHandlers(faultHanldersImpl);
        }
    }

    public static class FaultHandlersImpl
    implements FaultHandlers {
        private FaultHandler defaultHandler;
        private List<FaultHandler> faultHandlers;

        public FaultHandlersImpl(List<FaultHandler> faultHandlers, FaultHandler defaultHandler) {
            this.faultHandlers = faultHandlers;
            this.defaultHandler = defaultHandler;
        }

        @Override
        public List<FaultHandler> getFaultHandlers() {
            return this.faultHandlers;
        }

        @Override
        public FaultHandler getDefaultHandler() {
            return this.defaultHandler;
        }

        public void addFaultHandlers(List<FaultHandler> handlers) {
            if (this.faultHandlers == null) {
                this.faultHandlers = new ArrayList<FaultHandler>();
            }
            this.faultHandlers.addAll(handlers);
        }

        public void setDefaultHandler(FaultHandler handler) {
            this.defaultHandler = handler;
        }
    }
}

