/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;

public class ModelVisitorHelper {
    private NodeContainer nodeContainer;
    private Set<FlowNode> nodesInBoundaryFlow;

    public ModelVisitorHelper(NodeContainer nodeContainer) {
        this.nodeContainer = nodeContainer;
    }

    public Iterable<Activity> getActivities() {
        Sequence sequence = this.nodeContainer.getActivities();
        HashSet<Activity> activities = new HashSet<Activity>();
        for (Activity act : sequence) {
            if (this.getNodesInBoundaryFlow().contains(act) || act.isSubprocess() && ((Subprocess)act.asAnyNode(Subprocess.class)).isTriggeredByEvent()) continue;
            activities.add(act);
        }
        return activities;
    }

    public Iterable<Subprocess> getInlineSubprocess() {
        Sequence sequence = this.nodeContainer.getActivities();
        HashSet<Subprocess> inlineSubprocesses = new HashSet<Subprocess>();
        for (Activity act : sequence) {
            Subprocess subprocess;
            if (!act.isSubprocess() || !(subprocess = (Subprocess)act.asAnyNode(Subprocess.class)).isTriggeredByEvent()) continue;
            inlineSubprocesses.add(subprocess);
        }
        return inlineSubprocesses;
    }

    public Iterable<Event> getEvents() {
        Sequence eventSequence = this.nodeContainer.getEvents();
        HashSet<Event> events = new HashSet<Event>();
        for (Event event : eventSequence) {
            if (this.getNodesInBoundaryFlow().contains(event)) continue;
            events.add(event);
        }
        return events;
    }

    public Iterable<SequenceFlow> getSequenceFlows() {
        Sequence flowSequence = this.nodeContainer.getSequenceFlows();
        HashSet<SequenceFlow> flows = new HashSet<SequenceFlow>();
        for (SequenceFlow flow : flowSequence) {
            if (this.getNodesInBoundaryFlow().contains(flow.getSource()) || this.getNodesInBoundaryFlow().contains(flow.getTarget())) continue;
            flows.add(flow);
        }
        return flows;
    }

    public Iterable<Gateway> getGateways() {
        return this.nodeContainer.getGateways();
    }

    private Set<FlowNode> getNodesInBoundaryFlow() {
        if (this.nodesInBoundaryFlow == null) {
            Sequence boundaryEventSequence = this.nodeContainer.getBoundaryEvents();
            this.nodesInBoundaryFlow = new HashSet<FlowNode>();
            for (BoundaryEvent boundaryEvent : boundaryEventSequence) {
                if (boundaryEvent.cancelActivity()) continue;
                this.addNodesInBoundaryFlow((FlowNode)boundaryEvent, this.nodesInBoundaryFlow);
            }
            HashSet<FlowNode> nodesInEventBasedGateway = new HashSet<FlowNode>();
            for (Gateway gateway : this.nodeContainer.getGateways()) {
                if (gateway.getBpmnType() != BpmnType.EVENT_BASED_GATEWAY) continue;
                for (SequenceFlow sequenceFlow : gateway.getOutgoingSequenceFlows()) {
                    FlowNode target = sequenceFlow.getTarget();
                    nodesInEventBasedGateway.add(target);
                }
            }
            this.nodesInBoundaryFlow.addAll(nodesInEventBasedGateway);
        }
        return this.nodesInBoundaryFlow;
    }

    public Sequence<Measurement> getMeasurements() {
        Sequence measurements = this.nodeContainer.getMeasurements();
        return measurements;
    }

    private void addNodesInBoundaryFlow(FlowNode node, Set<FlowNode> nodesInBoundaryFlow) {
        Sequence flowSequence = node.getOutgoingSequenceFlows();
        for (SequenceFlow sequenceFlow : flowSequence) {
            FlowNode target = sequenceFlow.getTarget();
            nodesInBoundaryFlow.add(target);
            this.addNodesInBoundaryFlow(target, nodesInBoundaryFlow);
        }
    }
}

