/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ActivityCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BPMNFlowElementRegistry;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SubProcessCompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;

public class ModelVisitor {
    private Map<BPMNCubeElement, Set<FlowNode>> conditionalInitiateElementMap;
    private BPMNCubeMapBuilderContext context;
    private Set<BPMNCubeElement> initiateElement;
    private Set<BPMNCubeElement> terminateElement;
    private List<SubProcessCompilationResult> inlineErrorSubProcesses;
    private ModelVisitorHelper modelVisitoryHelper;
    private NodeContainer nodeContainer;
    private static final String logClassName = ModelVisitor.class.getName();

    public ModelVisitor(BPMNCubeMapBuilderContext context, NodeContainer nodeContainer) {
        this.context = context;
        this.nodeContainer = nodeContainer;
        this.initiateElement = new HashSet<BPMNCubeElement>();
        this.terminateElement = new HashSet<BPMNCubeElement>();
        this.conditionalInitiateElementMap = new HashMap<BPMNCubeElement, Set<FlowNode>>();
        this.inlineErrorSubProcesses = new ArrayList<SubProcessCompilationResult>();
    }

    public Iterable<BPMNCubeElement> getInitiateElement() {
        return this.initiateElement;
    }

    public Iterable<BPMNCubeElement> getTerminateElement() {
        return this.terminateElement;
    }

    public Map<BPMNCubeElement, Set<FlowNode>> getConditionalInitiateElement() {
        return this.conditionalInitiateElementMap;
    }

    public List<SubProcessCompilationResult> getInlineErrorSubProcesses() {
        return this.inlineErrorSubProcesses;
    }

    public void visit() throws CubeException {
        this.modelVisitoryHelper = new ModelVisitorHelper(this.nodeContainer);
        for (DataObject dataObject : this.nodeContainer.getDataObjects()) {
            try {
                DataHandlingUtils.handleImport((DataDeclaration)dataObject, this.context);
            }
            catch (Exception e) {
                throw new CubeException((Throwable)e);
            }
        }
        this.compileActivities();
        this.compileInlineSubprocesses();
        this.compileEvents();
        this.compileGateways();
        this.compileSequenceFlows();
        this.compileMeasurementMarks();
        this.compileCounters();
        for (BPMNCubeElement initiateElement : this.getInitiateElement()) {
            BaseBPMNBlock initiateElementParentBlock = (BaseBPMNBlock)initiateElement.getParentBlock();
            initiateElementParentBlock.getSequenceFlowMetadata().addEntryElement(initiateElement);
        }
    }

    private void compileSequenceFlows() throws CubeException {
        String logMethodName = "compileSequenceFlows";
        DeploymentLogger.debug((String)logClassName, (String)"compileSequenceFlows", (Object)"BEGIN");
        for (SequenceFlow sequenceFlow : this.modelVisitoryHelper.getSequenceFlows()) {
            BPMNFlowElementRegistry.getVisitor().visit(sequenceFlow, this.context);
            System.out.println("elementVisitor for activity[" + sequenceFlow.getClass() + "]= " + sequenceFlow);
        }
        DeploymentLogger.debug((String)logClassName, (String)"compileSequenceFlows", (Object)"END");
    }

    private void compileMeasurementMarks() throws CubeException {
        String logMethodName = "compileMeasurementMarks";
        DeploymentLogger.debug((String)logClassName, (String)"compileMeasurementMarks", (Object)"BEGIN");
        for (Measurement measure : this.modelVisitoryHelper.getMeasurements()) {
            BPMNFlowElementVisitor<Measurement> mesurementVisitor = BPMNFlowElementRegistry.getVisitor(BpmnType.MEASUREMENT);
            if (mesurementVisitor != null) {
                DeploymentLogger.debug((String)logClassName, (String)"compileMeasurementMarks", (Object)(" elementVisitor for measurement {" + measure.getClass().getName() + "} {" + measure.getName() + "}"));
                mesurementVisitor.visit(measure, this.context);
                System.out.println(" elementVisitor for measurement [" + measure.getClass().getName() + "]= " + measure);
                continue;
            }
            DeploymentLogger.debug((String)logClassName, (String)"compileMeasurementMarks", (Object)("Unable to locate the elementVisitor for measurement {" + measure.getClass().getName() + "} {" + measure.getName() + "}"));
        }
        DeploymentLogger.debug((String)logClassName, (String)"compileMeasurementMarks", (Object)"END");
    }

    private void compileEvents() throws CubeException {
        for (Event event : this.modelVisitoryHelper.getEvents()) {
            BPMNFlowElementVisitor<Event> elementVisitor = BPMNFlowElementRegistry.getVisitor(event.getBpmnType());
            if (elementVisitor != null) {
                CompilationResult result = elementVisitor.visit(event, this.context);
                this.addToInitiateElements((FlowNode)event, result);
                this.addToTerminateElements((FlowNode)event, result);
                continue;
            }
            System.out.println("Skipping visitor for -> " + event);
        }
    }

    private void compileGateways() throws CubeException {
        for (Gateway gateway : this.modelVisitoryHelper.getGateways()) {
            BPMNFlowElementVisitor<Gateway> elementVisitor = BPMNFlowElementRegistry.getVisitor(gateway.getBpmnType());
            if (elementVisitor != null) {
                CompilationResult result = elementVisitor.visit(gateway, this.context);
                this.addToInitiateElements((FlowNode)gateway, result);
                continue;
            }
            System.out.println("Skipping visitor for -> " + gateway);
        }
    }

    private void compileActivities() throws CubeException {
        this.compileActivitiesAux(this.modelVisitoryHelper.getActivities());
    }

    private void compileInlineSubprocesses() throws CubeException {
        this.compileActivitiesAux(this.modelVisitoryHelper.getInlineSubprocess());
    }

    private void compileActivitiesAux(Iterable<? extends Activity> activities) throws CubeException {
        for (Activity activity : activities) {
            BPMNFlowElementVisitor<Activity> elementVisitor = BPMNFlowElementRegistry.getVisitor(activity.getBpmnType());
            if (elementVisitor != null) {
                ActivityCharacteristicsVisitor<Activity, LoopCharacteristics> characteristicsVisitor = null;
                LoopCharacteristicsType loopCharacteristicsType = activity.getLoopCharacteristicsType();
                if (loopCharacteristicsType != null && (characteristicsVisitor = BPMNFlowElementRegistry.getCharacteristicsVisitor(loopCharacteristicsType)) == null) {
                    System.out.println("Skipping characteristics visitor for -> " + loopCharacteristicsType + " activity " + activity);
                }
                CompilationResult result = characteristicsVisitor != null ? characteristicsVisitor.visit(activity, this.context, elementVisitor) : elementVisitor.visit(activity, this.context);
                this.addToInitiateElements((FlowNode)activity, result);
                continue;
            }
            System.out.println("Skipping visitor for -> " + activity);
        }
    }

    private void compileCounters() throws CubeException {
        for (Counter counter : this.nodeContainer.getCounters()) {
            BPMNFlowElementVisitor<Counter> counterVisitor = BPMNFlowElementRegistry.getVisitor(BpmnType.COUNTER);
            if (counterVisitor == null) continue;
            counterVisitor.visit(counter, this.context);
            System.out.println("elementVisitor for counter [" + counter.getClass().getName() + "]= " + counter);
        }
    }

    private void addToInitiateElements(FlowNode node, CompilationResult result) {
        if (result != null) {
            if (ModelVisitorUtil.isInitiateNode(node)) {
                this.initiateElement.add(result.getEntryPoint());
                CatchEvent event = (CatchEvent)node.asAnyNode(CatchEvent.class);
                if (event != null && ModelVisitorUtil.isStartOfInlineEventHandler(event) && event.getEventTriggerType() != EventTriggerType.ERROR) {
                    this.initiateElement.add(result.getExitPoint());
                }
            } else {
                Subprocess subprocess;
                Activity activity;
                for (SequenceFlow incomingSequenceFlow : node.getIncomingSequenceFlows()) {
                    if (!ModelVisitorUtil.isTopLevelStart(incomingSequenceFlow.getSource())) continue;
                    this.initiateElement.add(result.getEntryPoint());
                    Set<FlowNode> flowNodeSet = this.conditionalInitiateElementMap.get(result.getEntryPoint());
                    if (flowNodeSet == null) {
                        flowNodeSet = new HashSet<FlowNode>();
                        this.conditionalInitiateElementMap.put(result.getEntryPoint(), flowNodeSet);
                    }
                    flowNodeSet.add(incomingSequenceFlow.getSource());
                }
                if (node.isActivity() && (activity = (Activity)node.asAnyNode(Activity.class)).isSubprocess() && (subprocess = (Subprocess)activity.asAnyNode(Subprocess.class)).isTriggeredByEvent() && !subprocess.getEvents(StartEvent.class, EventTriggerType.ERROR).isEmpty()) {
                    this.inlineErrorSubProcesses.add((SubProcessCompilationResult)result);
                }
            }
        }
    }

    private void addToTerminateElements(FlowNode node, CompilationResult result) {
        if (result != null && ModelVisitorUtil.isTerminateNode(node)) {
            this.terminateElement.add(result.getExitPoint());
        }
    }
}

