/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeNode;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.util.BPMNCubeMapExporter;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.BaseBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstruction;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;

public class BPMNCubeMapPlainExporter
extends BPMNCubeMapExporter {
    private static final String CONNECTOR = " -> ";

    @Override
    protected void printBlock(PrintWriter writer, ICubeBlock block, int indent) throws CubeException {
        if (block instanceof BaseBPMNBlock) {
            BaseBPMNBlock bpmnBlock = (BaseBPMNBlock)block;
            System.out.println("bpmnBlock.getId() = " + bpmnBlock.getId());
            List<BPMNCubeElement> entries = bpmnBlock.getSequenceFlowMetadata().getEntryElements();
            for (BPMNCubeElement element : entries) {
                System.out.println("\tentry = " + element.getId());
            }
        }
        String label = null;
        if (block instanceof BaseBPMNActivityBlock) {
            Object flowElement = ((BaseBPMNActivityBlock)block).getFlowElement();
            if (flowElement != null) {
                label = flowElement.getDefaultLabel();
            }
        } else if (block instanceof BPMNProcessBlock) {
            label = block.getId();
        }
        if (label == null) {
            label = block.getId();
        }
        this.printIndent(writer, indent);
        writer.println("block " + label);
        super.printBlock(writer, block, indent);
        this.printIndent(writer, indent);
        writer.println("end block");
    }

    @Override
    protected void printNodeDefinition(PrintWriter writer, ICubeNode node, int indent, FlowElement flowElement, String id) {
        this.printIndent(writer, indent);
        writer.println("Node " + id + this.getBpmnType(flowElement));
        this.printMicroInstructions(writer, node, indent + 1);
    }

    @Override
    protected void addConnector(String id, String targetNodeId, String targetActivityId, String connectorMetadata) {
        this.addConnector(id + CONNECTOR + targetNodeId + "[" + targetActivityId + "]" + connectorMetadata + ";");
    }

    protected String getBpmnType(FlowElement flowElement) {
        String result = flowElement instanceof FlowNode ? " (" + ((FlowNode)flowElement).getBpmnType().name().toLowerCase() + ")" : "";
        return result;
    }

    protected void printMicroInstructions(PrintWriter writer, ICubeNode node, int indent) {
        block4: {
            block3: {
                if (!(node instanceof BaseBPMNActivityNode)) break block3;
                BaseBPMNActivityNode bpmnNode = (BaseBPMNActivityNode)node;
                List<IMicroInstruction> instructions = bpmnNode.getMicroInstructions();
                if (instructions == null || instructions.isEmpty()) break block4;
                for (IMicroInstruction instruction : instructions) {
                    this.printIndent(writer, indent);
                    writer.println(instruction.getMicroInstructionId());
                }
                break block4;
            }
            if (node instanceof MIBPMNActivityNode) {
                MIBPMNActivityNode bpmnNode = (MIBPMNActivityNode)node;
                Map<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> map = bpmnNode.getMicroInstructionMap();
                for (Map.Entry<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> entry : map.entrySet()) {
                    this.printIndent(writer, indent);
                    writer.println(entry.getKey() + " " + entry.getValue().getMicroInstructionDescription());
                }
            }
        }
    }
}

