/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.BlockNotFoundException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeElement;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.core.map.ICubeNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

public class BPMNCubeMapExporter {
    protected Map<String, List<BPMRuntimeLogger.PathRecord>> pathRecordMap;
    private String componentName;
    private StringList connectors = StringList.create();
    private ICubeMap cubeMap;
    private List<String> definedNodes = new ArrayList<String>();
    private static final String INDENT = "  ";

    public static Map<String, List<BPMRuntimeLogger.PathRecord>> parsePath(@NotNull Reader pathReader, String componentName) throws IOException, ParseException {
        String line;
        BufferedReader reader = new BufferedReader(pathReader);
        HashMap<String, List<BPMRuntimeLogger.PathRecord>> pathRecordMap = new HashMap<String, List<BPMRuntimeLogger.PathRecord>>();
        while ((line = reader.readLine()) != null) {
            boolean add;
            BPMRuntimeLogger.PathRecord record = BPMRuntimeLogger.PathRecord.fromString(false, line);
            if (record == null) continue;
            String id = record.getRecordId();
            ArrayList<BPMRuntimeLogger.PathRecord> pathRecordList = (ArrayList<BPMRuntimeLogger.PathRecord>)pathRecordMap.get(id);
            if (pathRecordList == null) {
                pathRecordList = new ArrayList<BPMRuntimeLogger.PathRecord>();
            }
            if (!(add = componentName == null || componentName.equals(record.getProcessId()))) continue;
            pathRecordList.add(record);
            pathRecordMap.put(id, pathRecordList);
        }
        return pathRecordMap;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setPathRecordMap(Map<String, List<BPMRuntimeLogger.PathRecord>> pathRecordMap) {
        this.pathRecordMap = pathRecordMap;
    }

    public void export(Writer writer, ICubeMap cubeMap, Reader pathReader) throws CubeException {
        try {
            if (pathReader != null) {
                this.setPathRecordMap(BPMNCubeMapExporter.parsePath(pathReader, this.componentName));
            }
            this.cubeMap = cubeMap;
        }
        catch (IOException e) {
            this.pathRecordMap = null;
            e.printStackTrace();
        }
        catch (ParseException e) {
            this.pathRecordMap = null;
            e.printStackTrace();
        }
        PrintWriter out = new PrintWriter(writer);
        this.print(out, this.cubeMap);
        out.flush();
    }

    public void export(Writer writer, ICubeMap cubeMap) throws CubeException {
        this.export(writer, cubeMap, null);
    }

    protected BaseBPMNActivityBlock getBlock(String id) {
        try {
            return (BaseBPMNActivityBlock)this.cubeMap.getBlock(id);
        }
        catch (BlockNotFoundException e) {
            return null;
        }
        catch (CubeException e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    protected BPMNCubeElement getNode(String id) {
        try {
            return (BPMNCubeElement)this.cubeMap.getNode(id);
        }
        catch (BlockNotFoundException e) {
            return null;
        }
        catch (CubeException e) {
            throw new RuntimeException(e);
        }
    }

    protected void printIndent(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print(INDENT);
        }
    }

    protected void print(PrintWriter out, ICubeMap cubeMap) throws CubeException {
        this.printBlock(out, cubeMap.getMethodBlock(), 1);
        this.printConnectors(out);
    }

    protected void printBlock(PrintWriter writer, ICubeBlock block, int indent) throws CubeException {
        List childNodes;
        List childBlocks = block.getChildBlocks();
        if (childBlocks != null) {
            for (ICubeBlock childBlock : BPMNCubeMapExporter.sort(childBlocks)) {
                this.printBlock(writer, childBlock, indent + 1);
            }
        }
        if ((childNodes = block.getChildNodes()) != null) {
            for (ICubeNode childNode : BPMNCubeMapExporter.sort(childNodes)) {
                this.printNode(writer, childNode, indent + 1);
            }
        }
    }

    protected void printNode(PrintWriter writer, ICubeNode node, int indent) throws CubeException {
        BPMNCubeElement element = (BPMNCubeElement)node;
        Object flowElement = element.getFlowElement();
        String id = element.getId() + "[" + flowElement.getDefaultLabel() + "]";
        if (!this.definedNodes.contains(id)) {
            this.printNodeDefinition(writer, node, indent, (FlowElement)flowElement, id);
            this.definedNodes.add(id);
        }
        if (node instanceof AbstractGatewayNode) {
            AbstractGatewayNode gateway = (AbstractGatewayNode)node;
            SortedSet<SequenceFlowInfo> outgoingSequenceFlows = gateway.getGatewaySequenceFlowMetadata().getOutgoingSequenceFlows();
            for (SequenceFlowInfo outgoingSequenceFlow : outgoingSequenceFlows) {
                this.addConnection(element, id, outgoingSequenceFlow);
            }
            SequenceFlowInfo defaultOutgoingSequenceFlow = gateway.getGatewaySequenceFlowMetadata().getDefaultOutgoingSequenceFlow();
            if (defaultOutgoingSequenceFlow != null) {
                this.addConnection(element, id, defaultOutgoingSequenceFlow);
            }
        } else {
            SequenceFlowInfo flowInfo;
            UnconditionalSequenceFlowInfo outoingInfo = element.getSequenceFlowMetadata().getOutgoingSequenceFlow();
            if (outoingInfo != null) {
                this.addConnection(element, id, outoingInfo);
            } else if (!element.isNonMainFlowEndElement() && (flowInfo = this.getParentOutgoingSequenceFlowInfo(element)) != null) {
                this.addConnection(element, id, flowInfo);
            }
        }
    }

    protected void addConnector(String id, String targetNodeId, String targetActivityId, String connectorMetadata) {
    }

    protected void printNodeDefinition(PrintWriter writer, ICubeNode node, int indent, FlowElement flowElement, String id) {
    }

    protected void printConnectors(PrintWriter writer) {
        for (String connector : this.connectors) {
            writer.println(connector);
        }
    }

    protected void addConnector(String connector) {
        this.connectors.add((Object)connector);
    }

    protected String getEdgeMetadata(SequenceFlowInfo outgoingSequenceFlow) {
        return "";
    }

    private static <T extends ICubeElement> Set<T> sort(Collection<T> array) {
        TreeSet<T> sortedNodes = new TreeSet<T>(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        sortedNodes.addAll(array);
        return sortedNodes;
    }

    private SequenceFlowInfo getParentOutgoingSequenceFlowInfo(BPMNCubeElement element) {
        ICubeBlock parentBlock = element.getParentBlock();
        if (parentBlock instanceof BaseBPMNActivityBlock) {
            BaseBPMNActivityBlock bpmnParentBlock = (BaseBPMNActivityBlock)parentBlock;
            if (bpmnParentBlock.isNonMainFlowEndElement()) {
                return null;
            }
            UnconditionalSequenceFlowInfo outgoingInfoOfParent = bpmnParentBlock.getSequenceFlowMetadata().getOutgoingSequenceFlow();
            if (outgoingInfoOfParent != null) {
                return outgoingInfoOfParent;
            }
            return this.getParentOutgoingSequenceFlowInfo(bpmnParentBlock);
        }
        return null;
    }

    private void addConnection(BPMNCubeElement element, String sourceId, SequenceFlowInfo outoingInfo) throws CubeException {
        BaseBPMNActivityBlock destination = this.getBlock(outoingInfo.getTargetNodeId());
        if (destination == null) {
            String targetNodeId = outoingInfo.getTargetNodeId();
            String targetActivityDefaultLabel = ((BPMNCubeElement)this.cubeMap.getNode(targetNodeId)).getFlowElement().getDefaultLabel();
            this.addConnector(sourceId, targetNodeId, targetActivityDefaultLabel, this.getEdgeMetadata(outoingInfo));
        } else {
            List<BPMNCubeElement> targetNodes;
            boolean inwards = element.getParentBlock().getChildBlocks().contains(destination);
            try {
                targetNodes = this.findTargetNode(destination, inwards);
            }
            catch (Exception e) {
                targetNodes = null;
            }
            if (targetNodes != null) {
                Set<BPMNCubeElement> sortedTargetNodes = BPMNCubeMapExporter.sort(targetNodes);
                for (BPMNCubeElement targetNode : sortedTargetNodes) {
                    String targetNodeId = targetNode.getId();
                    String targetActivityId = targetNode.getFlowElement().getDefaultLabel();
                    this.addConnector(sourceId, targetNodeId, targetActivityId, this.getEdgeMetadata(outoingInfo));
                }
            }
        }
    }

    private List<BPMNCubeElement> findTargetNode(BaseBPMNActivityBlock destination, boolean inwards) {
        String[] tokens = inwards ? destination.getEntryTokens() : destination.getExitTokens();
        ArrayList<BPMNCubeElement> result = new ArrayList<BPMNCubeElement>();
        for (String token : tokens) {
            BaseBPMNActivityBlock firstBlock = this.getBlock(token);
            if (firstBlock != null) {
                if (firstBlock.isNonMainFlowEndElement()) continue;
                result.addAll(this.findTargetNode(firstBlock, inwards));
                continue;
            }
            result.add(this.getNode(token));
        }
        return result;
    }
}

