/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.core.map.ICubeNode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.util.BPMNCubeMapExporter;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.nodes.BaseBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;

public class BPMNCubeMapDotExporter
extends BPMNCubeMapExporter {
    private boolean addMicroInstructionsDetails;
    private Map<String, String> colorsByFlowElement = new HashMap<String, String>();
    private String[] excludedMicroInstructions;
    private boolean isDiffPath = false;
    private int nextCluster = 0;
    private int nextColor = 0;
    private static final String HIGHLIGHT_COLOR = "green";
    private static final String INACTIVE_COLOR = "gray";
    private static final int FONT_SIZE = 12;
    private static final String DIFF_COLOR = "red";
    private static final String CONDITIONAL_EDGE_COLOR = "red";
    private static String[] allColors = new String[]{"blueviolet", "deeppink4", "brown", "darkorchid1", "darkslategray1", "azure3", "chocolate1", "cyan4", "cornsilk3", "darkorange2", "azure4", "brown1", "blanchedalmond", "antiquewhite", "firebrick", "darkslategray", "firebrick1", "chartreuse", "cornsilk4", "dimgray", "darkolivegreen", "darkorange4", "antiquewhite4", "cornsilk", "brown3", "darkorchid4", "aquamarine4", "firebrick3", "dimgrey", "darkorchid3", "goldenrod", "darkgoldenrod3", "darkturquoise", "cyan3", "darkviolet", "chartreuse4", "bisque4black", "blue", "bisque", "gold3", "goldenrod4", "azure", "darkseagreen1", "deeppink1", "chartreuse1", "forestgreen", "chartreuse3", "aliceblue", "cadetblue", "darkorange3", "dodgerblue", "chocolate", "dodgerblue3", "dodgerblue4", "darkolivegreen1", "chocolate3", "goldenrod1", "darkseagreen", "aquamarine", "deeppink3", "cyan", "gold", "aquamarine3", "goldenrod3", "burlywood1", "firebrick4", "darkslategrey", "blue4", "darkolivegreen4", "blue3", "chocolate4", "darkslategray4", "darksalmon", "crimson", "deepskyblue", "deepskyblue3", "bisque2", "darkslategray3", "cornflowerblue", "bisque3", "floralwhite", "brown4", "coral3", "beige", "darkgreen", "cadetblue4", "gainsboro", "darkkhaki", "darkolivegreen3", "darkgoldenrod", "burlywood", "coral4", "burlywood3", "darkgoldenrod1", "darkslateblue", "darkorange", "deepskyblue1", "darkseagreen3", "coral", "burlywood4", "darkorchid", "cadetblue3", "deepskyblue4", "gold4", "deeppink", "darkgoldenrod4", "cadetblue1", "darkseagreen4"};
    private static final String CONNECTOR = " -> ";
    private static final String NODE_COLOR = "darkolivegreen3";

    public BPMNCubeMapDotExporter(boolean addMicroInstructionsDetails) {
        this(addMicroInstructionsDetails, null);
    }

    public BPMNCubeMapDotExporter(boolean addMicroInstructionsDetails, String[] excludedMicroInstructions) {
        this.addMicroInstructionsDetails = addMicroInstructionsDetails;
        this.excludedMicroInstructions = excludedMicroInstructions == null ? new String[]{} : excludedMicroInstructions;
    }

    public void setDiffPath(boolean enabled) {
        this.isDiffPath = enabled;
    }

    public boolean isDiffPath() {
        return this.isDiffPath;
    }

    public boolean isExecutionDot() {
        return this.pathRecordMap != null;
    }

    public String getHighlightColor() {
        return this.isDiffPath() ? "red" : HIGHLIGHT_COLOR;
    }

    @Override
    protected void print(PrintWriter out, ICubeMap cubeMap) throws CubeException {
        out.println("digraph G {");
        super.print(out, cubeMap);
        out.println("}");
    }

    @Override
    protected void printBlock(PrintWriter writer, ICubeBlock block, int indent) throws CubeException {
        this.printIndent(writer, indent);
        writer.println("subgraph cluster" + this.getNextCluster() + " {");
        this.printIndent(writer, indent + 1);
        writer.println("node [style=filled,color=" + this.getDefaultNodeColor() + "];");
        this.printIndent(writer, indent + 1);
        String label = null;
        if (block instanceof BaseBPMNActivityBlock) {
            label = block.getId();
        } else if (block instanceof BPMNProcessBlock) {
            label = block.getId();
        }
        if (label == null) {
            label = block.getId();
        }
        writer.println("label=\"" + label + "\";");
        super.printBlock(writer, block, indent);
        this.printIndent(writer, indent);
        writer.println("}");
    }

    @Override
    protected void addConnector(String id, String targetNodeId, String targetActivityId, String connectorMetadata) {
        this.addConnector(this.escapeNodeId(id) + CONNECTOR + this.escapeNodeId(targetNodeId + "[" + targetActivityId + "]") + connectorMetadata + ";");
    }

    @Override
    protected void printNodeDefinition(PrintWriter writer, ICubeNode node, int indent, FlowElement flowElement, String id) {
        this.printIndent(writer, indent);
        String color = this.isExecutionDot() ? (this.isNodeInPath(id) ? this.getHighlightColor() : INACTIVE_COLOR) : this.getColor(flowElement);
        writer.println(this.escapeNodeId(id) + " [color=" + color + ",fontsize=" + 12 + ",label=\"" + id + this.getBpmnType(flowElement) + this.getData(id, node) + "\"]");
    }

    protected String getBpmnType(FlowElement flowElement) {
        String result = flowElement instanceof FlowNode ? "\\n(" + ((FlowNode)flowElement).getBpmnType().name().toLowerCase() + ")" : "";
        return result;
    }

    protected String getMicroInstructions(ICubeNode node) {
        if (this.addMicroInstructionsDetails) {
            StringBuilder result = new StringBuilder();
            if (node instanceof BaseBPMNActivityNode) {
                BaseBPMNActivityNode bpmnNode = (BaseBPMNActivityNode)node;
                List<IMicroInstruction> instructions = bpmnNode.getMicroInstructions();
                if (instructions != null) {
                    for (IMicroInstruction instruction : instructions) {
                        result.append("\\n");
                        result.append(instruction.getMicroInstructionId());
                    }
                }
            } else if (node instanceof MIBPMNActivityNode) {
                MIBPMNActivityNode bpmnNode = (MIBPMNActivityNode)node;
                Map<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> map = bpmnNode.getMicroInstructionMap();
                for (Map.Entry<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> entry : map.entrySet()) {
                    result.append("\\n");
                    result.append(entry.getKey() + " " + entry.getValue().getMicroInstructionDescription());
                }
            }
            return result.toString();
        }
        return "";
    }

    @Override
    protected String getEdgeMetadata(SequenceFlowInfo outgoingSequenceFlow) {
        String result = "";
        if (outgoingSequenceFlow.getBpmnSequenceFlowType() == BpmnSequenceFlowType.CONDITIONAL) {
            result = "[color=red]";
        }
        return result;
    }

    protected String escapeNodeId(String id) {
        return this._escapeNodeId("\"" + id + "\"");
    }

    private boolean isNodeInPath(String id) {
        return this.pathRecordMap.get(id) != null && !((List)this.pathRecordMap.get(id)).isEmpty();
    }

    private String getDefaultNodeColor() {
        return NODE_COLOR;
    }

    private String getData(String id, ICubeNode node) {
        StringBuilder result = new StringBuilder();
        if (this.pathRecordMap != null) {
            List pathRecordList = (List)this.pathRecordMap.get(id);
            if (pathRecordList != null && !pathRecordList.isEmpty()) {
                NodeLabel label = new NodeLabel(id);
                for (BPMRuntimeLogger.PathRecord record : pathRecordList) {
                    if (this.containsExcludedMicroInstructions(record)) continue;
                    label.addData(record.getThread(), record.getStep(), record.getMicroInstructionProcedure(), record.getMicroInstructionStep(), record.getMicroInstruction() + " " + record.getLabel());
                }
                label.appendTo(result);
            }
        } else {
            result.append(this.getMicroInstructions(node));
        }
        return result.toString();
    }

    private boolean containsExcludedMicroInstructions(BPMRuntimeLogger.PathRecord record) {
        for (String str : this.excludedMicroInstructions) {
            if (!record.getMicroInstruction().contains(str)) continue;
            return true;
        }
        return false;
    }

    private String getColor(FlowElement element) {
        String color = this.colorsByFlowElement.get(element.getId());
        if (color == null) {
            color = this.getUnassignedColor();
            this.colorsByFlowElement.put(element.getId(), color);
        }
        return color;
    }

    private int getNextCluster() {
        return this.nextCluster++;
    }

    private String getUnassignedColor() {
        if (this.nextColor >= allColors.length) {
            this.nextColor = 0;
        }
        return allColors[this.nextColor++];
    }

    private String _escapeNodeId(String id) {
        boolean isAlphaDig = id.matches("[a-zA-Z]+([\\w_]*)?");
        boolean isDoubleQuoted = id.matches("\".*\"");
        boolean isDotNumber = id.matches("[-]?([.][0-9]+|[0-9]+([.][0-9]*)?)");
        boolean isHTML = id.matches("<.*>");
        if (isAlphaDig || isDotNumber || isDoubleQuoted || isHTML) {
            return id;
        }
        throw new RuntimeException("Generated id '" + id + "'for vertex '" + id + "' is not valid with respect to the .dot language");
    }

    public static class NodeLabel {
        private List<ThreadStepData> data;
        private String id;

        public NodeLabel(String id) {
            this(id, new ArrayList<ThreadStepData>());
        }

        public NodeLabel(String id, List<ThreadStepData> data) {
            this.id = id.replace("\"", "");
            this.data = data;
        }

        public void addData(ThreadStepData data) {
            this.data.add(data);
        }

        public void addData(int thread, int step, String miprocedure, int mistep, String msg) {
            this.data.add(new ThreadStepData(thread, step, miprocedure, mistep, msg));
        }

        public String getId() {
            return this.id;
        }

        public List<ThreadStepData> getData() {
            return this.data;
        }

        public void appendTo(StringBuilder builder) {
            for (ThreadStepData data : this.getData()) {
                builder.append("\\n");
                data.appendTo(builder);
            }
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            this.appendTo(str);
            return str.toString();
        }

        public NodeLabel fromString(String str) {
            String[] parts = str.split("\\n");
            String id = parts[0];
            NodeLabel nodeLabel = new NodeLabel(id);
            for (int i = 1; i < parts.length; ++i) {
                ThreadStepData threadStepData = ThreadStepData.fromString(parts[i]);
                nodeLabel.addData(threadStepData);
            }
            return nodeLabel;
        }

        public static class ThreadStepData {
            private String msg;
            private String miprocedure;
            private int thread;
            private int step;
            private int mistep;

            public ThreadStepData(int thread, int step, String miprocedure, int mistep, String msg) {
                this.thread = thread;
                this.step = step;
                this.mistep = mistep;
                this.miprocedure = miprocedure;
                this.msg = msg;
            }

            public static ThreadStepData fromString(String str) {
                String[] parts = str.split(",");
                int thread = Integer.valueOf(parts[0].substring(1));
                int step = Integer.valueOf(parts[1].substring(0, parts[1].length() - 1));
                String miprocedure = parts[2].substring(0, parts[2].length() - 1);
                int mistep = Integer.valueOf(parts[3].substring(0, parts[3].length() - 1));
                String msg = parts[4];
                return new ThreadStepData(thread, step, miprocedure, mistep, msg);
            }

            public int getThread() {
                return this.thread;
            }

            public int getStep() {
                return this.step;
            }

            public String getMiProcedure() {
                return this.miprocedure;
            }

            public int getMiStep() {
                return this.mistep;
            }

            public String getMsg() {
                return this.msg;
            }

            public String toString() {
                StringBuilder str = new StringBuilder();
                this.appendTo(str);
                return str.toString();
            }

            protected void appendTo(StringBuilder builder) {
                builder.append("[");
                builder.append(this.getThread());
                builder.append(",");
                builder.append(this.getStep());
                builder.append(",");
                builder.append(this.getMiProcedure());
                builder.append(",");
                builder.append(this.getMiStep());
                builder.append("] ");
                builder.append(this.msg.replace(" ", "_"));
            }
        }
    }
}

