/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeElement;
import com.collaxa.cube.engine.core.map.ICubeNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.ServiceLink;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ICompiler;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.nodes.ExclusiveGatewayNode;
import oracle.bpm.bpmn.engine.model.nodes.InclusiveGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.common.BPMNRuntimeConstants;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.ConditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfoFactory;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.services.common.exception.BPMException;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.ReferenceModel;
import oracle.fabric.composite.model.ServiceModel;
import oracle.fabric.composite.model.WsdlInterfaceModel;
import org.jetbrains.annotations.NotNull;

public class BPMNCubeMapBuilderContext {
    private Boolean compilingInstantiateBlock;
    private ComponentModel componentModel;
    private boolean createInstanceEventPresent = false;
    private final BPMNCubeMap cubeMap;
    private BaseBPMNActivityBlock currentBlock;
    private Deque<Map<TagInfo, BPMNCubeElement>> elementsByTag = new ArrayDeque<Map<TagInfo, BPMNCubeElement>>();
    private Collection<ICompiler> postCompilers = new ArrayList<ICompiler>();
    private String prefixCache = "";
    private Deque<String> prefixes = new ArrayDeque<String>();
    private Set<ServiceLink> serviceLinks = new TreeSet<ServiceLink>();

    public BPMNCubeMapBuilderContext(BPMNCubeMap cubeMap) {
        this.cubeMap = cubeMap;
        this.componentModel = cubeMap.getComponentModel();
        this.elementsByTag.add(new HashMap());
    }

    public BaseBPMNActivityBlock getCurrentBlock() {
        return this.currentBlock;
    }

    public void setCurrentBlock(BaseBPMNActivityBlock currentBlock) {
        this.currentBlock = currentBlock;
    }

    public void addElementToCurrentBlock(ICubeElement element) {
        this.addElementToBlock(element, (ICubeBlock)this.currentBlock);
    }

    public void addElementToBlock(ICubeElement element, ICubeBlock parent) {
        if (parent != null) {
            element.setParentBlock(parent);
            parent.addChildElement(element);
        }
        if (element instanceof ICubeNode) {
            this.cubeMap.addNode(element.getId(), (ICubeNode)element);
        } else if (element instanceof ICubeBlock) {
            this.cubeMap.addBlock(element.getId(), (ICubeBlock)element);
        }
    }

    public void tagElement(TagInfo tagInfo, BPMNCubeElement element) {
        assert (this.elementsByTag.getLast() != null);
        this.elementsByTag.getLast().put(tagInfo, element);
    }

    public BPMNCubeElement getElementByTag(TagInfo tagInfo) {
        assert (this.elementsByTag.getLast() != null);
        return this.elementsByTag.getLast().get(tagInfo);
    }

    public void link(BPMNCubeElement source, BPMNCubeElement target) {
        this.link(null, source, target);
    }

    public void link(SequenceFlow sequenceFlow) {
        String sourceActivityId = sequenceFlow.getSource().getId();
        String targetActivityId = sequenceFlow.getTarget().getId();
        BPMNCubeElement entryPoint = this.getElementByTag(TagInfo.createTagInfo(targetActivityId, Tag.ENTRY_POINT));
        BPMNCubeElement exitPoint = this.getElementByTag(TagInfo.createTagInfo(sourceActivityId, Tag.EXIT_POINT));
        this.link(sequenceFlow, exitPoint, entryPoint);
    }

    public void linkConditional(SequenceFlow sequenceFlow) throws CubeException {
        if (sequenceFlow.getSource() == null || sequenceFlow.getTarget() == null) {
            throw new CubeException((Throwable)new BPMException(71500));
        }
        String sourceActivityId = sequenceFlow.getSource().getId();
        String targetActivityId = sequenceFlow.getTarget().getId();
        AbstractGatewayNode sourceNode = (AbstractGatewayNode)this.getElementByTag(TagInfo.createTagInfo(sourceActivityId, Tag.GATEWAY_NODE));
        AbstractGatewayNode targetNode = (AbstractGatewayNode)this.getElementByTag(TagInfo.createTagInfo(targetActivityId, Tag.GATEWAY_NODE));
        BPMNCubeElement targetEntryPoint = this.getElementByTag(TagInfo.createTagInfo(targetActivityId, Tag.ENTRY_POINT));
        ConditionalSequenceFlowInfo conditionalSequenceFlowInfo = SequenceFlowInfoFactory.createConditional((ConditionalFlow)sequenceFlow, targetEntryPoint.getId());
        assert (sourceNode != null) : "A conditional link must have a source node tagged as a gateway node, but is null";
        sourceNode.getGatewaySequenceFlowMetadata().addOutgoingSequenceFlow(conditionalSequenceFlowInfo);
        if (targetNode != null) {
            targetNode.getGatewaySequenceFlowMetadata().addIncomingSequenceFlow(conditionalSequenceFlowInfo);
        }
    }

    public void addInitiationInfo(ICubeProcess.InitiationInfo initiationInfo) {
        this.cubeMap.addInitiationInfo(initiationInfo);
    }

    public Collection<ICubeProcess.InitiationInfo> getInitiationInfo() {
        return this.cubeMap.getInitiationsInfo();
    }

    public void addInitiateInfo(CatchEvent event) {
        this.setCreateInstanceEventInitiationInfo();
        this.cubeMap.addTimerEvent(event);
    }

    public Collection<CatchEvent> getTimerEvents() {
        return this.cubeMap.getTimerEvents();
    }

    public void setCompilingInstantiateBlock(boolean instantiate) {
        this.compilingInstantiateBlock = instantiate;
    }

    public void unsetCompilingInstantiateBlock() {
        this.compilingInstantiateBlock = null;
    }

    public Boolean isCompilingInstantiateBlock() {
        return this.compilingInstantiateBlock;
    }

    public void setCreateInstanceEventInitiationInfo() {
        if (!this.createInstanceEventPresent) {
            ICubeProcess.InitiationInfo initiationInfo = new ICubeProcess.InitiationInfo(null, null, BPMNRuntimeConstants.CREATE_COMPONENT_INSTANCE_EVENT_QNAME, null, null);
            this.addInitiationInfo(initiationInfo);
            this.createInstanceEventPresent = true;
        }
    }

    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public void registerPostCompiler(ICompiler compiler) {
        this.postCompilers.add(compiler);
    }

    public void executePostCompilers() {
        for (ICompiler compiler : this.postCompilers) {
            compiler.compile();
        }
    }

    public BPMNCubeMap getCubeMap() {
        return this.cubeMap;
    }

    public void pushContext(String prefix) {
        this.addCubeElementPrefix(prefix);
        this.elementsByTag.addLast(new HashMap());
    }

    public void popContext() {
        this.removeLastCubeElementPrefix();
        this.elementsByTag.removeLast();
    }

    public String getCubeElementId(FlowNode element, String idSuffix) {
        return this.prefixCache + element.getId() + idSuffix;
    }

    public Set<ServiceLink> getServiceLinks() {
        return this.serviceLinks;
    }

    public void addServiceLinkDeclaration(@NotNull String serviceLinkName) {
        ServiceLink serviceLink = null;
        if (this.getComponentModel() != null && this.getComponentModel().getComponentType() != null) {
            ServiceModel service = this.getComponentModel().getComponentType().getService(serviceLinkName);
            if (service != null) {
                WsdlInterfaceModel interfaceModel = (WsdlInterfaceModel)service.getInterfaceType();
                serviceLink = ServiceLink.createService(serviceLinkName, interfaceModel.getInterfaceQName(), interfaceModel.getCallbackInterfaceQName());
            } else {
                ReferenceModel reference = this.getComponentModel().getComponentType().getReference(serviceLinkName);
                if (reference != null) {
                    WsdlInterfaceModel interfaceModel = (WsdlInterfaceModel)reference.getInterfaceType();
                    serviceLink = ServiceLink.createReference(serviceLinkName, interfaceModel.getInterfaceQName(), interfaceModel.getCallbackInterfaceQName());
                }
            }
        }
        if (serviceLink != null) {
            this.serviceLinks.add(serviceLink);
        }
    }

    private void link(SequenceFlow sequenceFlow, BPMNCubeElement source, BPMNCubeElement target) {
        AbstractGatewayNode abstractGatewayNode;
        Object sourceFlowElement = source.getFlowElement();
        if (sourceFlowElement != null && source.getParentBlock() != target.getParentBlock() && ModelVisitorUtil.isTopLevelStart(sourceFlowElement)) {
            target = (BPMNCubeElement)target.getParentBlock();
        }
        UnconditionalSequenceFlowInfo sequenceFlowInfo = sequenceFlow != null ? SequenceFlowInfoFactory.createUnconditional(sequenceFlow, target.getId()) : SequenceFlowInfoFactory.createUnconditional(this.buildSequenceFlowId(source, target), sourceFlowElement == null ? source.getId() : sourceFlowElement.getId(), target.getFlowElement() == null ? target.getId() : target.getFlowElement().getId(), target.getId());
        if (source instanceof AbstractGatewayNode) {
            abstractGatewayNode = (AbstractGatewayNode)source;
            if (abstractGatewayNode instanceof ExclusiveGatewayNode || abstractGatewayNode instanceof InclusiveGatewayNode) {
                abstractGatewayNode.getGatewaySequenceFlowMetadata().setDefaultOutgoingSequenceFlow(sequenceFlowInfo);
            } else {
                abstractGatewayNode.getGatewaySequenceFlowMetadata().addOutgoingSequenceFlow(sequenceFlowInfo);
            }
        } else {
            source.getSequenceFlowMetadata().setOutgoingSequenceFlow(sequenceFlowInfo);
        }
        if (target instanceof AbstractGatewayNode) {
            abstractGatewayNode = (AbstractGatewayNode)target;
            abstractGatewayNode.getGatewaySequenceFlowMetadata().addIncomingSequenceFlow(sequenceFlowInfo);
        } else {
            target.getSequenceFlowMetadata().setIncomingSequenceFlow(sequenceFlowInfo);
        }
    }

    private String buildSequenceFlowId(BPMNCubeElement source, BPMNCubeElement target) {
        return source.getId() + "To" + target.getId();
    }

    private void addCubeElementPrefix(String prefix) {
        this.prefixes.addLast(prefix);
        this.createPrefixString();
    }

    private void removeLastCubeElementPrefix() {
        this.prefixes.removeLast();
        this.createPrefixString();
    }

    private void createPrefixString() {
        StringBuilder str = new StringBuilder();
        for (String p : this.prefixes) {
            str.append(p);
        }
        this.prefixCache = str.toString();
    }
}

