/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeElement;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.MultiStartBlock;
import oracle.bpm.bpmn.engine.model.blocks.ProcessTryBlock;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;

public class BPMNCubeMapBuilder {
    private BPMNCubeMap cubeMap;
    private BPMNCubeMapBuilderContext cubeMapBuilderContext;
    private Process processModel;
    private ModelVisitor visitor = null;

    public BPMNCubeMapBuilder(Process processModel, BPMNCubeMap cubeMap) {
        this.processModel = processModel;
        this.cubeMap = cubeMap;
        this.cubeMapBuilderContext = new BPMNCubeMapBuilderContext(cubeMap);
    }

    public BPMNCubeMapBuilder(Process processModel, BPMNCubeMapBuilderContext context) {
        this.processModel = processModel;
        this.cubeMapBuilderContext = context;
        this.cubeMap = this.cubeMapBuilderContext.getCubeMap();
    }

    public static void buildMaps(Process process, BPMNCubeMap cubeMap) throws CubeException {
        BPMNCubeMapBuilder builder = new BPMNCubeMapBuilder(process, cubeMap);
        builder.build(true, true);
    }

    public static void buildMaps(Process process, BPMNCubeMapBuilderContext context) throws CubeException {
        BPMNCubeMapBuilder builder = new BPMNCubeMapBuilder(process, context);
        builder.build(false, false);
    }

    private void build(boolean executePostCompilers, boolean addProcessBlock) throws CubeException {
        this.visitor = new ModelVisitor(this.cubeMapBuilderContext, (NodeContainer)this.processModel);
        this.buildProcessBlock(addProcessBlock);
        if (executePostCompilers) {
            this.cubeMapBuilderContext.executePostCompilers();
        }
    }

    private void buildProcessBlock(boolean addProcessBlock) throws CubeException {
        BaseBPMNActivityBlock newBlock;
        String id = this.processModel.getId();
        String name = this.processModel.getName();
        int index = id.lastIndexOf("/");
        if (index >= 0) {
            id = id.substring(index + 1);
        }
        BPMNProcessBlock processBlock = null;
        ProcessTryBlock tryBlock = null;
        BaseBPMNActivityBlock oldCurrentBlock = this.cubeMapBuilderContext.getCurrentBlock();
        if (addProcessBlock) {
            processBlock = new BPMNProcessBlock(id, this.processModel, this.cubeMapBuilderContext.getServiceLinks());
            this.cubeMapBuilderContext.addElementToBlock((ICubeElement)processBlock, null);
            this.cubeMap.setMethodBlock((ICubeBlock)processBlock);
            tryBlock = BlockFactory.createProcessTryBlock(this.cubeMapBuilderContext, id, null);
            tryBlock.setFaultHandlers(null);
            this.cubeMapBuilderContext.addElementToBlock(tryBlock, (ICubeBlock)processBlock);
            this.cubeMapBuilderContext.tagElement(TagInfo.createTagInfo(id, Tag.TRY_BLOCK), tryBlock);
            Object[] startEventsArray = this.processModel.getEvents(StartEvent.class).toArray();
            if (startEventsArray.length > 1) {
                MultiStartBlock multiStartBlock = BlockFactory.createMultiStartBlock(this.cubeMapBuilderContext, id, null);
                this.cubeMapBuilderContext.addElementToBlock(multiStartBlock, (ICubeBlock)processBlock);
                this.cubeMapBuilderContext.tagElement(TagInfo.createTagInfo(id, Tag.MULTISTART_BLOCK), multiStartBlock);
                processBlock.getSequenceFlowMetadata().addEntryElement(multiStartBlock);
                this.cubeMapBuilderContext.link(multiStartBlock, tryBlock);
            } else if (startEventsArray.length == 0) {
                processBlock.getSequenceFlowMetadata().addEntryElement(tryBlock);
            }
            newBlock = tryBlock;
        } else {
            newBlock = oldCurrentBlock;
        }
        this.cubeMapBuilderContext.setCurrentBlock(newBlock);
        this.visitor.visit();
        if (tryBlock != null) {
            ModelVisitorUtil.processInlineCompilationResult(this.cubeMapBuilderContext, newBlock, tryBlock, this.visitor.getInlineErrorSubProcesses());
            tryBlock.setConditionalInitiateElements(this.visitor.getConditionalInitiateElement());
        }
        this.cubeMapBuilderContext.setCurrentBlock(oldCurrentBlock);
    }
}

