/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.map.BlockNotFoundException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.core.map.NodeNotFoundException;
import com.collaxa.cube.engine.util.collections.CubeBlockHashMap;
import com.collaxa.cube.engine.util.collections.CubeNodeHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilder;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.model.ComponentModel;
import org.jetbrains.annotations.Nullable;

public final class BPMNCubeMap
implements ICubeMap {
    private ComponentModel componentModel;
    private Collection<ICubeProcess.InitiationInfo> initiationsInfo;
    private ICubeBlock[] mBlockList;
    private CubeBlockHashMap mBlocks = new CubeBlockHashMap();
    private ICubeBlock mMethodBlock;
    private ICubeNode[] mNodeList;
    private CubeNodeHashMap mNodes = new CubeNodeHashMap();
    private Process mProcessModel;
    private Collection<CatchEvent> timerEvents;

    public BPMNCubeMap(Process process, @Nullable ComponentModel componentModel) {
        this.mProcessModel = process;
        this.componentModel = componentModel;
        this.initiationsInfo = new ArrayList<ICubeProcess.InitiationInfo>();
        this.timerEvents = new ArrayList<CatchEvent>();
    }

    @Nullable
    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public void load(ICubeContext ctx) throws CubeException {
        BPMNCubeMapBuilder.buildMaps(this.mProcessModel, this);
    }

    public void setMethodBlock(ICubeBlock block) {
        this.mMethodBlock = block;
    }

    public void init(ICubeContext ctx) throws CubeException {
        this.mMethodBlock.init(ctx);
        int i = 0;
        int size = this.mNodes.size();
        this.mNodeList = new ICubeNode[size];
        CubeNodeHashMap.Iterator ni = this.mNodes.iterator();
        while (ni.next()) {
            this.mNodeList[i++] = ni.value();
        }
        i = 0;
        size = this.mBlocks.size();
        this.mBlockList = new ICubeBlock[size];
        CubeBlockHashMap.Iterator bi = this.mBlocks.iterator();
        while (bi.next()) {
            this.mBlockList[i++] = bi.value();
        }
    }

    public void unload(ICubeContext ctx) throws CubeException {
    }

    public void addInitiationInfo(ICubeProcess.InitiationInfo initiationInfo) {
        this.initiationsInfo.add(initiationInfo);
    }

    public void addTimerEvent(CatchEvent event) {
        this.timerEvents.add(event);
    }

    public ICubeBlock getMethodBlock() {
        return this.mMethodBlock;
    }

    public Collection<ICubeProcess.InitiationInfo> getInitiationsInfo() {
        return Collections.unmodifiableCollection(this.initiationsInfo);
    }

    public Collection<CatchEvent> getTimerEvents() {
        return Collections.unmodifiableCollection(this.timerEvents);
    }

    public ICubeNode[] getAllNodes() {
        return this.mNodeList;
    }

    public ICubeBlock[] getAllBlocks() {
        return this.mBlockList;
    }

    public ICubeNode getNode(String id) throws CubeException {
        ICubeNode n = this.mNodes.get(id);
        if (n == null) {
            throw new NodeNotFoundException(id);
        }
        return n;
    }

    public ICubeBlock getBlock(String id) throws CubeException {
        ICubeBlock b = this.mBlocks.get(id);
        if (b == null) {
            throw new BlockNotFoundException(id);
        }
        return b;
    }

    public void uninit(ICubeContext ctx) throws CubeException {
    }

    public void addNode(String id, ICubeNode node) {
        this.mNodes.put(id, node);
    }

    public void addBlock(String id, ICubeBlock block) {
        this.mBlocks.put(id, block);
    }
}

