/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.instancemanagement.impl;

import com.collaxa.cube.engine.audit.IAuditTrail;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.Transaction;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.bpmn.engine.instancemanagement.IInternalInstanceManagementService;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNPayloadMappingCache;
import oracle.bpm.bpmn.engine.service.BPMNAuditTrail;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.persistence.AuditPersistenceException;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQuery;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryVariableRange;
import oracle.bpm.services.common.AbstractBPMService;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessSystemAttributes;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;

public class InternalInstanceManagementService
extends AbstractBPMService
implements IInternalInstanceManagementService {
    @Override
    public IProcessInstance insertUpdateInstance(IBPMContext context, IProcessInstance instance) throws BPMException {
        this.logDebug("insertUpdateInstance()", "Start of inserting process instance");
        boolean inTransaction = false;
        String taskId = null;
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            IPersistencyService service = Transaction.getPersistencyService();
            Task taskObject = ((ProcessInstance)instance).getTask();
            SystemAttributesType attributes = taskObject.getSystemAttributes();
            if (context != null) {
                String userName = context.getUser();
                attributes.getUpdatedBy().setId(userName);
            }
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(System.currentTimeMillis());
            attributes.setUpdatedDate(updatedDate);
            taskId = taskObject.getSystemAttributes().getTaskId();
            List removeAssignees = instance.getRemoveAssignees();
            if (removeAssignees != null) {
                IProcessSystemAttributes sysAttribute = instance.getSystemAttributes();
                ArrayList currentAssignees = new ArrayList(sysAttribute.getAssignees());
                sysAttribute.clearAssignees();
                for (IIdentityType type : removeAssignees) {
                    sysAttribute.addAssignee(type);
                }
                service.removeAssigneeFromProcessInstance((IWorkflowContext)context, taskObject);
                sysAttribute.clearAssignees();
                for (IIdentityType type : currentAssignees) {
                    sysAttribute.addAssignee(type);
                }
            }
            taskObject = service.insertUpdateProcessInstance((IWorkflowContext)context, taskObject);
            ((ProcessInstance)instance).setTask(taskObject);
        }
        catch (Exception exc) {
            Object[] obj = new String[]{taskId};
            throw new BPMException(70202, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception exc) {}
            }
        }
        this.logDebug("insertUpdateInstance()", "End of inserting process instance");
        return instance;
    }

    @Override
    public void persistAuditData(IAuditTrail auditTrail) throws BPMException {
        if (auditTrail instanceof BPMNAuditTrail && ((BPMNAuditTrail)auditTrail).getEventCount() > 0) {
            try {
                IAuditService audit = AuditServiceFactory.getInstance().getAuditService();
                audit.persistAuditData(auditTrail);
            }
            catch (AuditPersistenceException ape) {
                Object[] objs = new String[]{auditTrail + " "};
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (String)ape.getMessage());
                throw new BPMException(71300, objs, (Throwable)ape);
            }
            catch (Exception e) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
                Object[] objs = new String[]{auditTrail + " "};
                throw new BPMException(71300, objs, (Throwable)e);
            }
        }
    }

    @Override
    public void insertAuditVariableMetadata(IAuditVariableMetadata metadata, List<AuditQueryVariableRange> ranges) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.persistAuditMetadata(metadata, ranges);
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_AUDIT_CORE, (Severity)Severity.ERRORS, (Throwable)e);
            Object[] objs = new String[]{metadata + " "};
            throw new BPMException(71300, objs, (Throwable)e);
        }
    }

    @Override
    public void markInstanceAsStaleAndRemoveFlexFieldMapping(String processDN) throws BPMException {
        boolean inTransaction = false;
        this.logDebug("markInstanceAsStale()", "Start of marking instance as stale for process DN " + processDN);
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start((boolean)false);
            }
            IPersistencyService service = Transaction.getPersistencyService();
            service.markTasksAsStale(processDN);
            service.deleteAttributeLabelUsageByTaskMetadataId(processDN);
            BPMNPayloadMappingCache.clearEntry(processDN);
        }
        catch (Exception exc) {
            Object[] obj = new String[]{processDN};
            throw new BPMException(70202, obj, (Throwable)exc);
        }
        finally {
            if (!inTransaction) {
                try {
                    Transaction.close();
                }
                catch (Exception exc) {}
            }
        }
        this.logDebug("markInstanceAsStale()", "End of marking instance as stale");
    }

    @Override
    public int abortInstancesByCompositeInstanceId(IBPMContext context, long compositeInstanceId) throws Exception {
        this.logDebug("abortInstancesByCompositeInstanceId()", "Start of aborting instances based on composite instance id " + compositeInstanceId);
        Predicate pred = new Predicate(IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN, 0, (Object)String.valueOf(compositeInstanceId));
        InstanceQueryInput input = new InstanceQueryInput();
        input.addState("OPEN");
        input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
        IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
        ArrayList displayColumns = new ArrayList();
        List instances = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
        for (IProcessInstance instance : instances) {
            instance.getSystemAttributes().setState("ABORTED");
            this.insertUpdateInstance(context, instance);
        }
        this.logDebug("abortInstancesByCompositeInstanceId()", "End of aborting instances based on composite instance id " + compositeInstanceId + compositeInstanceId);
        return instances.size();
    }

    @Override
    public List<AuditQuery> queryLastEventforCompositeDN(String compositeDN, int firstResult, int maxResult) throws BPMException {
        List<AuditQuery> events = null;
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            events = service.queryLastEventforCompositeDN(compositeDN, firstResult, maxResult);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
        return events;
    }

    @Override
    public void markAuditAsStale(List<AuditQuery> events) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.markAuditAsStale(events);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public void markAuditAsAborted(IBPMContext context, String compositeInstanceId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.markAuditAsAborted(compositeInstanceId);
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public void markAuditCancelled(IBPMContext context, String instanceId) throws BPMException {
        try {
            IAuditService service = AuditServiceFactory.getInstance().getAuditService();
            service.markAuditCancelled(String.valueOf(instanceId));
        }
        catch (Exception e) {
            throw new BPMException(e);
        }
    }

    @Override
    public void markInstanceCancelled(IBPMContext context, String instanceId) throws BPMException {
        this.logDebug("markInstanceCancelled()", "Start of marking instance as cancelled. Id: " + instanceId);
        try {
            IInstanceQueryService service = BPMServiceLocator.getInstanceQueryService();
            Predicate pred = new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)String.valueOf(instanceId));
            InstanceQueryInput input = new InstanceQueryInput();
            ArrayList displayColumns = new ArrayList();
            input.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            List instances = service.queryInstances(context, displayColumns, pred, null, (IInstanceQueryInput)input);
            for (IProcessInstance instance : instances) {
                this.logDebug("markInstanceCancelled()", "Marking instance '" + instance.getSystemAttributes().getProcessInstanceId() + "' corresponding to cube instance '" + instanceId + "' as cancelled.");
                instance.getSystemAttributes().setState("CANCELED");
                this.insertUpdateInstance(context, instance);
            }
        }
        catch (WorkflowException e) {
            Object[] obj = new String[]{instanceId};
            throw new BPMException(70202, obj, (Throwable)e);
        }
        this.logDebug("markInstanceCancelled()", "End of marking instance as cancelled. Id: " + instanceId);
    }

    private void logDebug(String methodName, String message) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"oracle.bpm.engine.instancemanagement.impl.InternalInstanceManagementService", (String)methodName, (String)message);
    }
}

