/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import java.util.Set;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.TypeNormalizer;
import oracle.bpm.compiler.xpath.XPTypeNormalizer;
import oracle.bpm.compiler.xpath.XPathGenerator;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class XPathGeneratorUtils {
    private XPathGeneratorUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FuegoCompiler buildCompiler() {
        FuegoCompiler compiler = new FuegoCompiler();
        compiler.setTypeResolver((TypeNormalizer)new XPTypeNormalizer());
        compiler.setDirective(3);
        FuegoCompiler fuegoCompiler = compiler;
        if (fuegoCompiler == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildCompiler must not return null");
        }
        return fuegoCompiler;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FuegoCompiler buildCompiler(@NotNull MethodTypeDescription mtd) {
        if (mtd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildCompiler must not be null");
        }
        FuegoCompiler compiler = XPathGeneratorUtils.buildCompiler();
        compiler.addObjectClass(mtd.getParentRef());
        FuegoCompiler fuegoCompiler = compiler;
        if (fuegoCompiler == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildCompiler must not return null");
        }
        return fuegoCompiler;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        MethodTypeDescription methodTypeDescription = XPathGeneratorUtils.buildMethod(scope, catalog, TypeFactory.getAny());
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not return null");
        }
        return methodTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog, @NotNull TypeRef resultType) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        if (resultType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        ObjectTypeDescription obj = new ObjectTypeDescription(XPathGenerator.class.getSimpleName());
        obj.setComponentType(ComponentType.XOBJECT.getText());
        obj.setCatalog(catalog);
        obj.addModifier(0x10000000L);
        MethodTypeDescription mtd = new MethodTypeDescription("CIL$_expression", 68753031232L);
        for (XPathVariable variable : scope) {
            String name = variable.getName();
            TypeRef type = variable.getType();
            if (type.get().isUnknown()) continue;
            long modifiers = 32840L;
            if (!variable.isReadOnly()) {
                modifiers |= 4L;
            }
            obj.addMember(new AttributeTypeDescription(name, type, modifiers));
        }
        mtd.setResultType(resultType);
        obj.addMember(mtd);
        MethodTypeDescription methodTypeDescription = mtd;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not return null");
        }
        return methodTypeDescription;
    }
}

