/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.cil.CilException;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.XPathSourceGenerator;
import oracle.bpm.compiler.xpath.XPTypeNormalizer;
import oracle.bpm.compiler.xpath.XPathGeneratorResult;
import oracle.bpm.compiler.xpath.XPathGeneratorUtils;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathGenerator {
    @NotNull
    private final FuegoCompiler compiler;
    @Nullable
    private Map<String, URI> currentNameSpaces;
    @NotNull
    private final XPathSourceGenerator generator;
    @NotNull
    private final MethodTypeDescription method;

    public XPathGenerator(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog) {
        MethodTypeDescription mtd;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.<init> must not be null");
        }
        this.method = mtd = XPathGeneratorUtils.buildMethod(scope, catalog);
        this.compiler = XPathGeneratorUtils.buildCompiler(mtd);
        this.generator = new XPathSourceGenerator(XPathGenerator.buildScopeMap(scope));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String makeLiteral(String literal) {
        String string = XPathSourceGenerator.makeString(literal);
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.makeLiteral must not return null");
        }
        return string;
    }

    public void setCurrentNameSpaces(@Nullable Map<String, URI> nameSpaces) {
        this.currentNameSpaces = nameSpaces != null && nameSpaces.isEmpty() ? null : CollectionUtils.immutableMap(nameSpaces);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XPathGeneratorResult generate(@NotNull String expression, @Nullable TypeRef targetType) throws CilException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.generate must not be null");
        }
        MethodTypeDescription mtd = this.method;
        mtd.setCode(expression, "Fuego");
        TypeRef typeRef = targetType == null ? TypeFactory.getAny() : targetType;
        mtd.setResultType(typeRef);
        this.compiler.compile((TypeDescription)mtd);
        boolean lvalue = targetType == null;
        XPathGeneratorResult result = this.generate(lvalue);
        if (lvalue) {
            if (result.isComplex()) {
                throw this.invalidLValue(expression);
            }
            List<AttributeTypeDescription> path = result.simpleReferences;
            AttributeTypeDescription lastElement = CollectionUtils.last(path);
            if (lastElement != null && !lastElement.hasSetter()) {
                throw this.invalidLValue(expression);
            }
        }
        XPathGeneratorResult xPathGeneratorResult = result;
        if (xPathGeneratorResult == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.generate must not return null");
        }
        return xPathGeneratorResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Map<String, XPathVariable> buildScopeMap(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGenerator.buildScopeMap must not be null");
        }
        Map<String, XPathVariable> result = CollectionUtils.hashMap(scope.size());
        for (XPathVariable variable : scope) {
            result.put(variable.getName(), variable);
        }
        Map<String, XPathVariable> map = result;
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.buildScopeMap must not return null");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private InvalidAssignmentException invalidLValue(String expression) {
        Method method = (Method)this.compiler.findMember((TypeDescription)this.method);
        InvalidAssignmentException invalidAssignmentException = new InvalidAssignmentException(method.getFirstStatement(), expression);
        if (invalidAssignmentException == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.invalidLValue must not return null");
        }
        return invalidAssignmentException;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private XPathGeneratorResult generate(boolean lvalue) throws CompilerException {
        MethodTypeDescription mtd = this.method;
        FuegoCompiler compiler = this.compiler;
        XPathSourceGenerator sg = this.generator;
        StringWriter sw = new StringWriter();
        sg.init(sw, lvalue, this.currentNameSpaces);
        compiler.generateSource((SourceGenerator)sg, (TypeDescription)mtd);
        XPathExpression xpe = new XPathExpression(sw.toString(), sg.getNsMap());
        Method method = (Method)compiler.findMember((TypeDescription)mtd);
        Node firstStatement = method.getFirstStatement();
        TypeDescription firstStatementType = firstStatement.getTypeDescription();
        TypeRef returnType = XPTypeNormalizer.generify(firstStatementType).getRef();
        XPathGeneratorResult xPathGeneratorResult = new XPathGeneratorResult(xpe, returnType, sg.getSimpleReferences());
        if (xPathGeneratorResult == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGenerator.generate must not return null");
        }
        return xPathGeneratorResult;
    }
}

