/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import oracle.bpm.compiler.TypeNormalizer;
import oracle.bpm.compiler.XPathSourceGenerator;
import oracle.bpm.lang.CollectionTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XPTypeNormalizer
implements TypeNormalizer {
    @NotNull
    private final ObjectTypeDescription boolTD = new XPathTypeDescription(1);
    @NotNull
    private final ObjectTypeDescription dateTD = new XPathTypeDescription(6, 0);
    @NotNull
    private final ObjectTypeDescription dateTimeTD = new XPathTypeDescription(6, 2);
    @NotNull
    private final ObjectTypeDescription decimalTD = new XPathTypeDescription(3);
    @NotNull
    private final ObjectTypeDescription intervalTD = new XPathTypeDescription(7);
    @NotNull
    private final ObjectTypeDescription intTD = new XPathTypeDescription(2);
    @NotNull
    private final ObjectTypeDescription monthDayTD = new XPathTypeDescription(6, 3);
    @NotNull
    private final ObjectTypeDescription realTD = new XPathTypeDescription(4);
    @NotNull
    private final ObjectTypeDescription stringTD = new XPathTypeDescription(5);
    @NotNull
    private final ObjectTypeDescription timeTD = new XPathTypeDescription(6, 1);
    @NotNull
    private final ObjectTypeDescription yearMonthTD = new XPathTypeDescription(6, 4);
    private static final String XP20_NAMESPACE = "http://www.oracle.com/XSL/Transform/java/oracle.tip.pc.services.functions.Xpath20";

    XPTypeNormalizer() {
        this.buildDecimal(this.decimalTD);
        this.buildNumberTD(this.realTD);
        this.buildNumberTD(this.intTD);
        this.buildTimeTD(this.dateTimeTD);
        this.buildTimeTD(this.timeTD);
        this.buildTimeTD(this.dateTD);
        this.buildTimeTD(this.yearMonthTD);
        this.buildTimeTD(this.monthDayTD);
        this.buildStringTD();
    }

    public TypeRef canonical(@Nullable TypeRef type) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case 3: {
                return this.decimalTD;
            }
            case 2: {
                return this.intTD;
            }
            case 4: {
                return this.realTD;
            }
            case 6: {
                return this.canonicalTime(type);
            }
            case 7: {
                return this.intervalTD;
            }
            case 5: {
                return this.stringTD;
            }
            case 1: {
                return this.boolTD;
            }
            case 12: {
                return this.forArray(type.get());
            }
        }
        return type;
    }

    static TypeDescription generify(TypeDescription type) {
        if (type instanceof XPathTypeDescription) {
            return ((XPathTypeDescription)type).genericOTD;
        }
        if (type.getKind() == 12) {
            return XPTypeNormalizer.generifyArray(type);
        }
        return type;
    }

    private static MethodTypeDescription buildFunctionXP20(String name, String signature, TypeRef result, Argument ... args) {
        return XPTypeNormalizer.buildFunctionNS(XP20_NAMESPACE, name, signature, result, args);
    }

    private static Argument argument(String name, TypeRef type) {
        return new Argument(name, type, 1L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static MethodTypeDescription buildFunctionNS(String ns, String name, String signature, TypeRef resultType, Argument ... args) {
        MethodTypeDescription mtd = new MethodTypeDescription(name);
        mtd.setSignature(XPathSourceGenerator.buildSignature(ns, signature));
        mtd.setResultType(resultType);
        for (Argument arg : args) {
            mtd.addArgument(arg);
        }
        MethodTypeDescription methodTypeDescription = mtd;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPTypeNormalizer.buildFunctionNS must not return null");
        }
        return methodTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static MethodTypeDescription buildFunction(String name, String signature, TypeRef resultType, Argument ... args) {
        MethodTypeDescription methodTypeDescription = XPTypeNormalizer.buildFunctionNS("", name, signature, resultType, args);
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPTypeNormalizer.buildFunction must not return null");
        }
        return methodTypeDescription;
    }

    private static TypeDescription generifyArray(TypeDescription type) {
        return type instanceof XPArrayTypeDescription ? ((XPArrayTypeDescription)type).delegate : type;
    }

    private TypeRef canonicalTime(TypeRef type) {
        TypeDescription td = type.get();
        assert (td.getKind() == 6);
        switch (td.getScale()) {
            case 0: {
                return this.dateTD;
            }
            case 1: {
                return this.timeTD;
            }
            case 4: {
                return this.yearMonthTD;
            }
            case 3: {
                return this.monthDayTD;
            }
        }
        return this.dateTimeTD;
    }

    private void buildNumberTD(ObjectTypeDescription number) {
        this.buildNumberNS("", number);
    }

    private void buildDecimal(ObjectTypeDescription number) {
        this.buildNumberNS("http://xmlns.oracle.com/bpm/decimal", number);
    }

    private void buildNumberNS(String ns, ObjectTypeDescription number) {
        number.addModifier(128L);
        if (number.getKind() != 2) {
            number.addMember(XPTypeNormalizer.buildFunctionNS(ns, "floor", "floor", this.intTD, new Argument[0]));
            number.addMember(XPTypeNormalizer.buildFunctionNS(ns, "ceil", "ceiling", this.intTD, new Argument[0]));
            number.addMember(XPTypeNormalizer.buildFunctionNS(ns, "round", "round", this.intTD, new Argument[0]));
        }
        String ns2 = "".equals(ns) ? XP20_NAMESPACE : ns;
        number.addMember(XPTypeNormalizer.buildFunctionNS(ns2, "abs", "abs", number, new Argument[0]));
    }

    private void buildTimeTD(ObjectTypeDescription otd) {
        assert (otd.getKind() == 6);
        int scale = otd.getScale();
        if (scale < 0) {
            scale = 2;
        }
        if (scale == 2 || scale == 0 || scale == 4) {
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("year", "year-from-dateTime", this.intTD, new Argument[0]));
        }
        if (scale == 2 || scale == 0 || scale == 4 || scale == 3) {
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("month", "month-from-dateTime", this.intTD, new Argument[0]));
        }
        if (scale == 2 || scale == 0 || scale == 3) {
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("day", "day-from-dateTime", this.intTD, new Argument[0]));
        }
        if (scale == 2 || scale == 1) {
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("hours", "hours-from-dateTime", this.intTD, new Argument[0]));
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("minutes", "minutes-from-dateTime", this.intTD, new Argument[0]));
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("seconds", "seconds-from-dateTime", this.intTD, new Argument[0]));
            otd.addMember(XPTypeNormalizer.buildFunctionXP20("timezone", "timezone-from-dateTime", this.intervalTD, new Argument[0]));
        }
        otd.addMember(XPTypeNormalizer.buildFunctionXP20("format", "format-dateTime", this.stringTD, XPTypeNormalizer.argument("picture", this.stringTD)));
    }

    private void buildStringTD() {
        ObjectTypeDescription otd = this.stringTD;
        otd.addModifier(128L);
        otd.addMember(XPTypeNormalizer.buildFunction("length", "string-length", this.intTD, new Argument[0]));
        otd.addMember(XPTypeNormalizer.buildFunction("contains", "contains", this.boolTD, XPTypeNormalizer.argument("s", this.stringTD)));
        otd.addMember(XPTypeNormalizer.buildFunction("startsWith", "starts-with", this.boolTD, XPTypeNormalizer.argument("prefix", this.stringTD)));
        otd.addMember(XPTypeNormalizer.buildFunctionXP20("endsWith", "ends-with", this.boolTD, XPTypeNormalizer.argument("suffix", this.stringTD)));
        otd.addMember(XPTypeNormalizer.buildFunction("substring", "substring", this.stringTD, XPTypeNormalizer.argument("from", this.intTD)));
        otd.addMember(XPTypeNormalizer.buildFunction("substring", "substring", this.stringTD, XPTypeNormalizer.argument("from", this.intTD), XPTypeNormalizer.argument("length", this.intTD)));
        otd.addMember(XPTypeNormalizer.buildFunctionXP20("lowerCase", "lower-case", this.stringTD, new Argument[0]));
        otd.addMember(XPTypeNormalizer.buildFunctionXP20("upperCase", "upper-case", this.stringTD, new Argument[0]));
    }

    private XPArrayTypeDescription forArray(TypeDescription delegate) {
        return delegate instanceof XPArrayTypeDescription ? (XPArrayTypeDescription)delegate : new XPArrayTypeDescription(delegate);
    }

    private class XPArrayTypeDescription
    extends CollectionTypeDescription {
        @NotNull
        final TypeDescription delegate;
        @Nullable
        private ObjectTypeDescription objectTD;

        XPArrayTypeDescription(TypeDescription delegate) {
            super(12);
            this.setElementType(delegate.getElementType());
            this.delegate = delegate;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public ObjectTypeDescription asObject() {
            ObjectTypeDescription result = this.objectTD;
            if (result == null) {
                this.objectTD = result = this.buildObject();
            }
            ObjectTypeDescription objectTypeDescription = result;
            if (objectTypeDescription == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPTypeNormalizer$XPArrayTypeDescription.asObject must not return null");
            }
            return objectTypeDescription;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        private ObjectTypeDescription buildObject() {
            ObjectTypeDescription result = new ObjectTypeDescription(this.getText());
            result.addMember(XPTypeNormalizer.buildFunction("length", "count", XPTypeNormalizer.this.intTD, new Argument[0]));
            ObjectTypeDescription objectTypeDescription = result;
            if (objectTypeDescription == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPTypeNormalizer$XPArrayTypeDescription.buildObject must not return null");
            }
            return objectTypeDescription;
        }
    }

    private static class XPathTypeDescription
    extends ObjectTypeDescription {
        private final TypeDescription genericOTD;

        XPathTypeDescription(int kind) {
            this(kind, -1);
        }

        XPathTypeDescription(TypeDescription genericOTD) {
            super(genericOTD.getName(), genericOTD.getKind(), genericOTD.getScale(), false);
            this.genericOTD = genericOTD;
        }

        XPathTypeDescription(int kind, int scale) {
            this(TypeFactory.forKind(kind, -1, scale));
        }

        @Override
        public boolean isComparable(TypeDescription type) {
            return this.isPredefined() ? this.genericOTD.isComparable(type) : super.isComparable(type);
        }

        @Override
        protected boolean isAssignableFromImpl(TypeDescription source) {
            return this.isPredefined() ? this.genericOTD.isAssignableFrom(source) : super.isAssignableFromImpl(source);
        }
    }
}

