/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import fuego.parser.RecognitionException;
import fuego.parser.TokenStreamException;
import java.util.Set;
import oracle.bpm.compiler.xpath.AbstractXPathParser;
import oracle.bpm.compiler.xpath.SimpleGeneratorException;
import oracle.bpm.compiler.xpath.XPathLexer;
import oracle.bpm.compiler.xpath.XPathParser;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGenerator {
    private final XPathLexer lexer;
    private final XPathParser parser;

    public SimpleGenerator(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/SimpleGenerator.<init> must not be null");
        }
        this.lexer = new XPathLexer();
        XPathParser parser = new XPathParser(this.lexer);
        parser.setScope((Set)scope);
        this.parser = parser;
    }

    @Nullable
    public static String makeLiteral(String xpath) {
        AbstractXPathParser.PInfo pInfo;
        XPathLexer lexer = new XPathLexer();
        XPathParser parser = new XPathParser(lexer);
        lexer.setInputString(xpath);
        try {
            pInfo = parser.pathExpr();
            parser.match(1);
            parser.checkErrors();
        }
        catch (RecognitionException ignore) {
            return null;
        }
        catch (TokenStreamException ignore) {
            return null;
        }
        return pInfo.getStringValue();
    }

    public String generate(@NotNull XPathExpression expression, @Nullable TypeRef targetType) throws SimpleGeneratorException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/SimpleGenerator.generate must not be null");
        }
        this.lexer.setInputString(expression.getExpressionValue());
        this.parser.setNamespaces(XPathLexer.asResolver(expression.getNamespaces()));
        this.parser.setTargetType(targetType);
        return this.parse();
    }

    private String parse() throws SimpleGeneratorException {
        String result;
        XPathParser parser = this.parser;
        parser.reset();
        try {
            result = parser.program();
            parser.checkErrors();
        }
        catch (RecognitionException e) {
            throw new SimpleGeneratorException((Exception)((Object)e));
        }
        catch (TokenStreamException e) {
            throw new SimpleGeneratorException((Exception)((Object)e));
        }
        return result;
    }
}

