/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import fuego.parser.LLkParser;
import fuego.parser.RecognitionException;
import fuego.parser.SemanticException;
import fuego.parser.Token;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.xpath.DataReferenceResult;
import oracle.bpm.compiler.xpath.NamespaceResolver;
import oracle.bpm.compiler.xpath.XPathLexer;
import oracle.bpm.compiler.xpath.XPathUsageType;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lib.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataReferenceParser {
    private final XPathLexer lexer;
    private final Set<XPathVariable> scope;

    public DataReferenceParser(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/DataReferenceParser.<init> must not be null");
        }
        this.lexer = new XPathLexer();
        this.scope = Collections.unmodifiableSet(scope);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DataReferenceResult generate(@NotNull String expression, @NotNull NamespaceResolver resolver) throws CilException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/DataReferenceParser.generate must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/DataReferenceParser.generate must not be null");
        }
        this.lexer.setInputString(expression);
        DataReferenceResult dataReferenceResult = this.parse(resolver);
        if (dataReferenceResult == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/DataReferenceParser.generate must not return null");
        }
        return dataReferenceResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DataReferenceResult generate(@NotNull XPathExpression expression) throws CilException {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/DataReferenceParser.generate must not be null");
        }
        DataReferenceResult dataReferenceResult = this.generate(expression.getExpressionValue(), XPathLexer.asResolver(expression.getNamespaces()));
        if (dataReferenceResult == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/DataReferenceParser.generate must not return null");
        }
        return dataReferenceResult;
    }

    private DataReferenceResult parse(@NotNull NamespaceResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/DataReferenceParser.parse must not be null");
        }
        RefParser refParser = new RefParser(resolver);
        refParser.parse();
        return new DataReferenceResult(refParser.references, refParser.prefixes);
    }

    private final class RefParser
    extends LLkParser {
        final Set<String> prefixes;
        final Set<XPathVariable> references;
        @NotNull
        private final NamespaceResolver namespaces;

        private RefParser(NamespaceResolver resolver) {
            if (resolver == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/DataReferenceParser$RefParser.<init> must not be null");
            }
            super((TokenStream)DataReferenceParser.this.lexer, 1);
            this.prefixes = new HashSet<String>();
            this.references = new LinkedHashSet<XPathVariable>();
            this.namespaces = resolver;
        }

        void parse() {
            this.references.clear();
            this.prefixes.clear();
            while (true) {
                try {
                    while (true) {
                        Token token = this.nextToken();
                        String tokenText = token.getText();
                        switch (token.getType()) {
                            case 1: {
                                return;
                            }
                            case 9: {
                                this.checkPrefixes(tokenText);
                                this.functionCall(tokenText);
                                break;
                            }
                            case 36: {
                                this.checkPrefixes(tokenText);
                                this.variableReference(tokenText);
                                break;
                            }
                            case 13: {
                                this.checkPrefixes(tokenText);
                            }
                        }
                    }
                }
                catch (TokenStreamException e) {
                    this.reportError((Exception)((Object)e));
                    continue;
                }
                catch (SemanticException e) {
                    this.reportError((RecognitionException)e);
                    continue;
                }
                break;
            }
        }

        private void checkPrefixes(String qname) {
            int p = qname.indexOf(58);
            if (p != -1) {
                String prefix = qname.substring(0, p);
                this.prefixes.add(prefix);
            }
        }

        private void reportError(Exception exception) {
            System.out.println(exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Token nextToken() throws TokenStreamException {
            Token token;
            try {
                token = this.LT(1);
            }
            finally {
                this.consume();
            }
            return token;
        }

        private QName buildQName(String fname) throws SemanticException {
            String localPart;
            String prefix;
            int p = fname.indexOf(58);
            if (p != -1) {
                prefix = fname.substring(0, p);
                localPart = fname.substring(p + 1);
            } else {
                prefix = "";
                localPart = fname;
            }
            return new QName(this.getNamespace(prefix), localPart, prefix);
        }

        private String getNamespace(String prefix) throws SemanticException {
            if (prefix == null) {
                prefix = "";
            }
            if ("".equals(prefix)) {
                return "";
            }
            String uri = this.namespaces.findNamespaceURI(prefix);
            if (uri == null) {
                throw new SemanticException("Unknown prefix = " + prefix);
            }
            return uri;
        }

        @Nullable
        private XPathUsageType findUsageType(QName fname) {
            if (!"http://www.omg.org/bpmn20".equals(fname.getNamespaceURI())) {
                return null;
            }
            String localPart = fname.getLocalPart();
            for (XPathUsageType usageType : XPathUsageType.values()) {
                if (!usageType.functionName.equals(localPart)) continue;
                return usageType;
            }
            return null;
        }

        private void functionCall(String fname) throws TokenStreamException, SemanticException {
            int nameIndex;
            QName qname = this.buildQName(fname);
            XPathUsageType usageType = this.findUsageType(qname);
            if (usageType == null) {
                return;
            }
            if (this.LA(1) != 24) {
                return;
            }
            if (usageType == XPathUsageType.ACTIVITY_INSTANCE_ATTRIBUTE) {
                if (this.LA(3) != 31) {
                    return;
                }
                nameIndex = 4;
            } else {
                nameIndex = 2;
            }
            if (this.LA(nameIndex) != 29) {
                return;
            }
            String param = this.LT(nameIndex).getText();
            this.addReference(param, usageType);
        }

        private void addReference(String varName, @Nullable XPathUsageType usageType) {
            for (XPathVariable variable : DataReferenceParser.this.scope) {
                if (usageType != null && variable.getUsageType() != usageType || !variable.getName().equals(varName)) continue;
                this.references.add(variable);
                break;
            }
        }

        private void variableReference(String varname) {
            this.addReference(varname, null);
        }
    }
}

