/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import fuego.parser.LLkParser;
import fuego.parser.ParserSharedInputState;
import fuego.parser.RecognitionException;
import fuego.parser.SemanticException;
import fuego.parser.Token;
import fuego.parser.TokenBuffer;
import fuego.parser.TokenStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.compiler.Cast;
import oracle.bpm.compiler.TypeNormalizer;
import oracle.bpm.compiler.xpath.NamespaceResolver;
import oracle.bpm.compiler.xpath.XPTypeNormalizer;
import oracle.bpm.compiler.xpath.XPathUsageType;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TZTime;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractXPathParser
extends LLkParser {
    @Nullable
    TypeRef targetType;
    @Nullable
    private NamespaceResolver namespaces;
    private Set<XPathVariable> scope;
    private final Map<QName, CallGenerator> callGenerators = this.buildGenerators();
    private final List<RecognitionException> errors = new ArrayList<RecognitionException>();
    private final TypeNormalizer normalizer = new XPTypeNormalizer();
    private static final String BPM_UTILS_NAMESPACE = "http://xmlns.oracle.com/bpm/utils";
    private static final String XP20_NAMESPACE = "http://www.oracle.com/XSL/Transform/java/oracle.tip.pc.services.functions.Xpath20";

    protected AbstractXPathParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
    }

    protected AbstractXPathParser(TokenStream lexer, int k) {
        super(lexer, k);
    }

    protected AbstractXPathParser(ParserSharedInputState state, int k) {
        super(state, k);
    }

    public void reportError(RecognitionException ex) {
        this.errors.add(ex);
    }

    public void reset() {
        this.errors.clear();
    }

    public void checkErrors() throws RecognitionException {
        if (!this.errors.isEmpty()) {
            throw this.errors.get(0);
        }
    }

    public void setNamespaces(@NotNull NamespaceResolver namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/AbstractXPathParser.setNamespaces must not be null");
        }
        this.namespaces = namespaces;
    }

    public void setTargetType(@Nullable TypeRef typeRef) {
        this.targetType = this.normalizeType(typeRef);
    }

    public void setScope(@NotNull Set<XPathVariable> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/AbstractXPathParser.setScope must not be null");
        }
        this.scope = CollectionUtils.immutableSet(scope);
    }

    static int precedence(int operation) {
        switch (operation) {
            case 7: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 14: 
            case 15: {
                return 3;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 4;
            }
            case 20: {
                return 5;
            }
            case 4: 
            case 5: 
            case 22: {
                return 6;
            }
            case 21: {
                return 7;
            }
        }
        return 100;
    }

    PInfo nullPInfo() {
        PInfo result = new PInfo();
        result.append("null");
        return result;
    }

    PInfo newFunction(String fname, List<PInfo> args) throws SemanticException {
        QName qname = this.buildQName(fname);
        CallGenerator generator = this.callGenerators.get(qname);
        if (generator == null) {
            generator = this.defaultGenerator();
        }
        return generator.generate(qname, args);
    }

    private static SemanticException unknownFunction(QName fname) {
        return new SemanticException("Unknown function '" + fname + '\'');
    }

    private static void checkNumArguments(QName fname, List<PInfo> args, int nargs) throws SemanticException {
        if (args.size() != nargs) {
            throw new SemanticException("Wrong number of arguments to '" + fname + '\'');
        }
    }

    private static String toTimeConst(String value) {
        return '\'' + TZTime.valueOf(value).toString() + '\'';
    }

    private static String toIntervalConst(String value) {
        return '\'' + Interval.valueOf(value).toString() + '\'';
    }

    private CallGenerator concatGenerator() {
        return new CallGenerator(){

            private void mergeStrings(List<PInfo> args) {
                PInfo last = null;
                Iterator<PInfo> it = args.iterator();
                while (it.hasNext()) {
                    PInfo arg = it.next();
                    if (last == null) {
                        if (!arg.isStringConst()) continue;
                        last = arg;
                        continue;
                    }
                    if (arg.isStringConst()) {
                        String s1 = last.getStringValue();
                        String s2 = arg.getStringValue();
                        last.clear();
                        last.addString(s1 + s2);
                        it.remove();
                        continue;
                    }
                    last = null;
                }
            }

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) {
                this.mergeStrings(args);
                PInfo pi = new PInfo();
                for (int i = 0; i < args.size(); ++i) {
                    PInfo arg = args.get(i);
                    if (i == 0) {
                        pi.addPInfo(arg);
                        continue;
                    }
                    pi.additive(20, arg);
                }
                pi.setType(AbstractXPathParser.this.getTypeString());
                return pi;
            }
        };
    }

    private TypeRef normalizeType(@Nullable TypeRef type) {
        return this.normalizer.canonical(type);
    }

    private TypeDescription normalizeType(@Nullable TypeDescription type) {
        TypeRef result = this.normalizeType((TypeRef)type);
        return result == null ? null : result.get();
    }

    private TypeDescription getType(int kind) {
        return this.normalizeType(TypeFactory.forKind(kind, -1, -1));
    }

    private TypeDescription getTypeString() {
        return this.getType(5);
    }

    private TypeDescription getTypeTime() {
        return this.getType(6);
    }

    private TypeDescription getTypeBool() {
        return this.getType(1);
    }

    private CallGenerator getObjectGenerator() {
        return new CallGenerator(){

            @NotNull
            private XPathUsageType findUsageType(String functionName) throws SemanticException {
                for (XPathUsageType usageType : XPathUsageType.values()) {
                    if (!usageType.functionName.equals(functionName)) continue;
                    return usageType;
                }
                throw new SemanticException("Invalid BPMN function: " + functionName);
            }

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                int numArgs;
                assert ("http://www.omg.org/bpmn20".equals(fname.getNamespaceURI()));
                XPathUsageType usageType = this.findUsageType(fname.getLocalPart());
                int n = numArgs = usageType == XPathUsageType.ACTIVITY_INSTANCE_ATTRIBUTE ? 2 : 1;
                if (args.size() != numArgs) {
                    throw new SemanticException("Wrong number of parameters");
                }
                PInfo arg = args.get(numArgs - 1);
                if (!arg.isStringConst()) {
                    throw new SemanticException("Constant string expected as parameter");
                }
                String varName = arg.getStringValue();
                TypeRef type = null;
                for (XPathVariable variable : AbstractXPathParser.this.scope) {
                    String nativeName;
                    if (usageType != variable.getUsageType() || (nativeName = variable.getName()) == null || !nativeName.equals(varName)) continue;
                    varName = variable.getName();
                    type = variable.getType();
                    break;
                }
                PInfo pi = new PInfo();
                pi.append(varName);
                pi.setType(type);
                return pi;
            }
        };
    }

    private Map<QName, CallGenerator> buildGenerators() {
        HashMap<QName, CallGenerator> map = new HashMap<QName, CallGenerator>();
        map.put(new QName("concat"), this.concatGenerator());
        CallGenerator cast = this.castGenerator();
        map.put(new QName("string"), cast);
        map.put(new QName("number"), cast);
        CallGenerator boolConst = this.boolConstGenerator();
        map.put(new QName("true"), boolConst);
        map.put(new QName("false"), boolConst);
        map.put(new QName("not"), this.notGenerator());
        map.put(new QName("boolean"), this.booleanGenerator());
        String xp20ns = XP20_NAMESPACE;
        map.put(new QName(XP20_NAMESPACE, "matches"), this.buildMatchesGenerator());
        map.put(new QName(XP20_NAMESPACE, "current-dateTime"), this.nowGenerator());
        CallGenerator addSub = this.addSubIntervalGenerator();
        map.put(new QName(XP20_NAMESPACE, "add-dayTimeDuration-to-dateTime"), addSub);
        map.put(new QName(XP20_NAMESPACE, "subtract-dayTimeDuration-from-dateTime"), addSub);
        map.put(new QName(XP20_NAMESPACE, "compare"), this.compareGenerator());
        String decNS = "http://xmlns.oracle.com/bpm/decimal";
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "compare"), this.compareGenerator());
        CallGenerator decAdd = this.decAdditiveGenerator();
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "add"), decAdd);
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "subtract"), decAdd);
        CallGenerator decMult = this.decMultiplicativeGenerator();
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "divide"), decMult);
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "multiply"), decMult);
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "remainder"), decMult);
        map.put(new QName("http://xmlns.oracle.com/bpm/decimal", "negative"), this.decNegativeGenerator());
        map.put(new QName(BPM_UTILS_NAMESPACE, "convert"), this.convertGenerator());
        CallGenerator doGenerator = this.getObjectGenerator();
        for (XPathUsageType usageType : XPathUsageType.values()) {
            map.put(usageType.buildQName(), doGenerator);
        }
        return map;
    }

    private CallGenerator convertGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 4);
                return args.get(0);
            }
        };
    }

    private CallGenerator decNegativeGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 1);
                PInfo pi = new PInfo();
                PInfo arg = args.get(0);
                arg.renderAsDecimal();
                return pi.unary(1, arg);
            }
        };
    }

    private CallGenerator decAdditiveGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 2);
                String function = fname.getLocalPart();
                assert ("add".equals(function) || "subtract".equals(function));
                int token = "add".equals(function) ? 20 : 21;
                PInfo arg0 = args.get(0);
                PInfo arg1 = args.get(1);
                arg0.renderAsDecimal();
                arg1.renderAsDecimal();
                return arg0.additive(token, arg1);
            }
        };
    }

    private CallGenerator decMultiplicativeGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 2);
                String function = fname.getLocalPart();
                assert ("divide".equals(function) || "multiply".equals(function) || "remainder".equals(function));
                int token = "divide".equals(function) ? 4 : ("multiply".equals(function) ? 22 : 5);
                PInfo arg0 = args.get(0);
                PInfo arg1 = args.get(1);
                arg0.renderAsDecimal();
                arg1.renderAsDecimal();
                return arg0.multiplicative(token, arg1);
            }
        };
    }

    private CallGenerator compareGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 2);
                PInfo arg0 = args.get(0);
                PInfo arg1 = args.get(1);
                if ("http://xmlns.oracle.com/bpm/decimal".equals(fname.getNamespaceURI())) {
                    arg0.renderAsDecimal();
                    arg1.renderAsDecimal();
                }
                return new ComparePInfo(arg0, arg1);
            }
        };
    }

    private CallGenerator booleanGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 1);
                PInfo pi = new PInfo();
                PInfo arg = args.get(0);
                pi.addPInfo(arg);
                pi.equality(15, AbstractXPathParser.this.nullPInfo());
                pi.isNullTest = true;
                pi.child = arg;
                return pi;
            }
        };
    }

    private CallGenerator buildMatchesGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 2);
                PInfo boolPar = this.searchBoolParam(args);
                if (boolPar == null) {
                    throw AbstractXPathParser.unknownFunction(fname);
                }
                PInfo pi = new PInfo();
                pi.addPInfo(boolPar);
                return pi;
            }

            private boolean checkPattern(@Nullable String regex) {
                Pattern pattern;
                if (regex == null) {
                    return false;
                }
                try {
                    pattern = Pattern.compile(regex);
                }
                catch (PatternSyntaxException ignore) {
                    return false;
                }
                return pattern.matcher("true").matches() && !pattern.matcher("false").matches();
            }

            @Nullable
            private PInfo searchBoolParam(List<PInfo> args) {
                PInfo pi1;
                PInfo pi0 = args.get(0);
                if (pi0.type.getKind() != 5) {
                    return null;
                }
                PInfo child = pi0.child;
                if (child == null) {
                    return null;
                }
                if (child.type == null) {
                    child.setType(AbstractXPathParser.this.getType(1));
                }
                if (!(pi1 = args.get(1)).isStringConst()) {
                    return null;
                }
                if (!this.checkPattern(pi1.getStringValue())) {
                    return null;
                }
                if (child.type.getKind() == 1) {
                    return child;
                }
                PInfo boolCast = new PInfo();
                boolCast.append("Bool(");
                boolCast.addPInfo(child);
                boolCast.append(")");
                boolCast.type = AbstractXPathParser.this.getType(1);
                return boolCast;
            }
        };
    }

    private CallGenerator notGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 1);
                PInfo pi = new PInfo();
                PInfo arg = args.get(0);
                if (arg.isNullTest) {
                    pi.addPInfo(arg.child);
                    pi.equality(14, AbstractXPathParser.this.nullPInfo());
                } else {
                    pi.append("not ");
                    pi.addPInfo(arg);
                }
                return pi;
            }
        };
    }

    private CallGenerator boolConstGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 0);
                PInfo pi = new PInfo();
                String function = fname.toString();
                assert ("true".equals(function) || "false".equals(function));
                pi.append(function);
                return pi;
            }
        };
    }

    private CallGenerator castGenerator() {
        return new CallGenerator(){

            private TypeDescription getTargetType(QName fname) throws SemanticException {
                assert (Str.isEmpty(fname.getNamespaceURI()));
                String name = fname.getLocalPart();
                if ("string".equals(name)) {
                    return AbstractXPathParser.this.getTypeString();
                }
                if ("number".equals(name)) {
                    return AbstractXPathParser.this.getType(4);
                }
                throw new SemanticException("Unknown cast " + name);
            }

            private int getXPKind(TypeRef type) {
                int kind = type.getKind();
                if (kind == 2 || kind == 3) {
                    kind = 4;
                }
                return kind;
            }

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 1);
                PInfo arg = args.get(0);
                TypeRef context = arg.type;
                TypeDescription targetType = this.getTargetType(fname);
                boolean synthetic = context == null || this.getXPKind(targetType) == this.getXPKind(context);
                PInfo pi = new PInfo();
                if (!synthetic) {
                    pi.append(targetType.getName());
                    pi.append("(");
                }
                pi.addPInfo(arg);
                if (!synthetic) {
                    pi.append(")");
                }
                pi.setType(synthetic && context != null ? context : targetType);
                if (targetType.getKind() == 5) {
                    pi.child = arg;
                }
                return pi;
            }
        };
    }

    private CallGenerator addSubIntervalGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 2);
                PInfo dateTime = args.get(0);
                PInfo interval = args.get(1);
                PInfo pi = new PInfo();
                if (dateTime.isStringConst()) {
                    pi.append(AbstractXPathParser.toTimeConst(dateTime.getStringValue()));
                } else {
                    pi.addPInfo(this.getTimeInterval(dateTime));
                }
                pi.append(fname.getLocalPart().startsWith("add") ? " + " : " - ");
                if (interval.isStringConst()) {
                    pi.append(AbstractXPathParser.toIntervalConst(interval.getStringValue()));
                } else {
                    pi.addPInfo(this.getTimeInterval(interval));
                }
                pi.setType(AbstractXPathParser.this.getTypeTime());
                pi.precedence = AbstractXPathParser.precedence(20);
                return pi;
            }

            private PInfo getTimeInterval(PInfo pi) {
                PInfo child;
                if (pi.type.getKind() == 5 && (child = pi.child) != null) {
                    pi = child;
                }
                return pi;
            }
        };
    }

    private CallGenerator nowGenerator() {
        return new CallGenerator(){

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                AbstractXPathParser.checkNumArguments(fname, args, 0);
                PInfo pi = new PInfo();
                pi.addNOW();
                return pi;
            }
        };
    }

    private String getNamespace(String prefix) throws SemanticException {
        if (prefix == null) {
            prefix = "";
        }
        if ("".equals(prefix)) {
            return "";
        }
        String uri = this.findNamespaceURI(prefix);
        if (uri == null) {
            throw new SemanticException("Unknown prefix = " + prefix);
        }
        return uri;
    }

    @Nullable
    private String findNamespaceURI(String prefix) {
        NamespaceResolver resolver = this.namespaces;
        return resolver == null ? null : resolver.findNamespaceURI(prefix);
    }

    private QName buildQName(String fname) throws SemanticException {
        String localPart;
        String prefix;
        int p = fname.indexOf(58);
        if (p != -1) {
            prefix = fname.substring(0, p);
            localPart = fname.substring(p + 1);
        } else {
            prefix = "";
            localPart = fname;
        }
        return new QName(this.getNamespace(prefix), localPart, prefix);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private CallGenerator defaultGenerator() {
        CallGenerator callGenerator = new CallGenerator(){

            @Nullable
            private QName asQName(@NotNull MethodTypeDescription td) {
                String signature = td.getSignature();
                if (Str.isEmpty(signature)) {
                    return null;
                }
                String[] parts = signature.split(";");
                if (!"xpath".equals(parts[0])) {
                    return null;
                }
                return new QName(parts[1], parts[2]);
            }

            private boolean isSameMethod(MethodTypeDescription td, QName function) {
                QName fname = this.asQName(td);
                return fname != null && fname.equals(function);
            }

            @Nullable
            private MethodTypeDescription findFunction(TypeDescription contextTD, QName fname) {
                int count = contextTD.getMemberCount();
                for (int j = 0; j < count; ++j) {
                    MethodTypeDescription td = contextTD.getMemberType(j);
                    if (td.isAttribute() || !this.isSameMethod(td, fname)) continue;
                    return td;
                }
                return null;
            }

            @Override
            @NotNull
            public PInfo generate(QName fname, List<PInfo> args) throws SemanticException {
                if (args.isEmpty()) {
                    throw AbstractXPathParser.unknownFunction(fname);
                }
                MethodTypeDescription member = null;
                PInfo pi = new PInfo();
                for (int i = 0; i < args.size(); ++i) {
                    PInfo arg = args.get(i);
                    if (i == 0) {
                        member = this.findMethod(fname, arg);
                        if (member == null && (arg = arg.child) != null) {
                            member = this.findMethod(fname, arg);
                        }
                        if (member == null) {
                            throw AbstractXPathParser.unknownFunction(fname);
                        }
                    }
                    if (i == 0 && arg.precedence < 100) {
                        pi.append(member.getName());
                        pi.append("(");
                    }
                    if (i > 1) {
                        pi.append(", ");
                    }
                    pi.addPInfo(arg);
                    if (i != 0 || arg.precedence < 100) continue;
                    pi.append(".");
                    pi.append(member.getName());
                    pi.append("(");
                }
                pi.append(")");
                assert (member != null);
                pi.setType(member.getResultType());
                return pi;
            }

            private MethodTypeDescription findMethod(QName fname, PInfo arg) throws SemanticException {
                MethodTypeDescription member = this.findFunction(arg, fname);
                if (member == null && arg.isStringConst() && (member = this.findTimeFunction(fname, arg)) == null) {
                    member = this.findDecimalFunction(fname, arg);
                }
                return member;
            }

            @Nullable
            private MethodTypeDescription findDecimalFunction(QName fname, PInfo arg) {
                if (!arg.isStringConst()) {
                    return null;
                }
                MethodTypeDescription result = this.findFunction(fname, AbstractXPathParser.this.getType(3));
                if (result != null) {
                    arg.renderAsDecimal();
                }
                return result;
            }

            private MethodTypeDescription findTimeFunction(QName fname, PInfo arg) {
                MethodTypeDescription member = this.findTimeFunction(fname, arg, false);
                if (member == null) {
                    member = this.findTimeFunction(fname, arg, true);
                }
                return member;
            }

            @Nullable
            private MethodTypeDescription findTimeFunction(QName fname, PInfo arg, boolean interval) {
                if (!arg.isStringConst()) {
                    return null;
                }
                TypeDescription type = AbstractXPathParser.this.getType(interval ? 7 : 6);
                MethodTypeDescription result = this.findFunction(fname, type);
                if (result != null) {
                    String str = arg.getStringValue();
                    arg.clear();
                    String time = interval ? AbstractXPathParser.toIntervalConst(str) : AbstractXPathParser.toTimeConst(str);
                    arg.append(time);
                    arg.precedence = 99;
                    arg.setType(type);
                }
                return result;
            }

            private MethodTypeDescription findFunction(PInfo arg, QName fname) throws SemanticException {
                TypeRef context = arg.type;
                if (context == null) {
                    throw new SemanticException("No active scope");
                }
                return this.findFunction(fname, context);
            }

            private MethodTypeDescription findFunction(QName fname, @NotNull TypeRef context) {
                TypeDescription contextTD = context.get();
                MethodTypeDescription result = this.findFunction(contextTD, fname);
                if (result == null && !contextTD.isObject()) {
                    ObjectTypeDescription objectTD = contextTD.asObject();
                    result = this.findFunction(objectTD, fname);
                }
                return result;
            }
        };
        if (callGenerator == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser.defaultGenerator must not return null");
        }
        return callGenerator;
    }

    class PInfo {
        @Nullable
        PInfo child;
        private boolean isNullTest;
        private int precedence = 100;
        private final StringBuilder sb = new StringBuilder();
        @Nullable
        private String stringValue;
        @Nullable
        private TypeRef type;
        private static final String IS_XSD_ATTRIBUTE = "isXsdAttribute";
        private static final String ELEMENT_NAMESPACE = "elementNamespace";

        PInfo() {
        }

        public String toString() {
            return this.sb.toString();
        }

        @Nullable
        public String getStringValue() {
            return this.stringValue;
        }

        public void setType(@Nullable TypeRef context) {
            this.type = AbstractXPathParser.this.normalizeType(context);
        }

        PInfo orExpr(PInfo right) {
            PInfo result = this.addOperation(" or ", AbstractXPathParser.precedence(7), right);
            result.setType(AbstractXPathParser.this.getTypeBool());
            return result;
        }

        PInfo andExpr(PInfo right) {
            PInfo result = this.addOperation(" and ", AbstractXPathParser.precedence(6), right);
            result.setType(AbstractXPathParser.this.getTypeBool());
            return result;
        }

        PInfo equality(int token, PInfo right) throws SemanticException {
            this.checkEnumEquality(right);
            String operation = token == 14 ? " == " : " != ";
            PInfo result = this.addOperation(operation, AbstractXPathParser.precedence(token), right);
            result.setType(AbstractXPathParser.this.getTypeBool());
            return result;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        PInfo relational(int token, PInfo right) throws SemanticException {
            String operation;
            switch (token) {
                case 16: {
                    operation = " < ";
                    break;
                }
                case 18: {
                    operation = " <= ";
                    break;
                }
                case 17: {
                    operation = " > ";
                    break;
                }
                case 19: {
                    operation = " >= ";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid token : " + token);
                }
            }
            PInfo result = this.addOperation(operation, AbstractXPathParser.precedence(token), right);
            result.setType(AbstractXPathParser.this.getTypeBool());
            PInfo pInfo = result;
            if (pInfo == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.relational must not return null");
            }
            return pInfo;
        }

        void addNOW() {
            this.append("'now'");
            this.setType(AbstractXPathParser.this.getType(6));
            this.precedence = 99;
        }

        PInfo additive(int token, PInfo right) {
            TypeRef context = this.type;
            String operation = token == 20 ? " + " : " - ";
            PInfo result = this.addOperation(operation, AbstractXPathParser.precedence(20), right);
            result.setType(context);
            return result;
        }

        TypeRef promote(TypeRef type1, TypeRef type2) {
            int kind2;
            int kind1 = type1.getKind();
            return kind1 < (kind2 = type2.getKind()) ? type2 : type1;
        }

        PInfo multiplicative(int token, PInfo right) {
            String operation;
            TypeRef newType = this.promote(this.type, right.type);
            switch (token) {
                case 22: {
                    operation = " * ";
                    break;
                }
                case 4: {
                    operation = " / ";
                    break;
                }
                case 5: {
                    operation = " % ";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid token : " + token);
                }
            }
            PInfo result = this.addOperation(operation, AbstractXPathParser.precedence(22), right);
            result.setType(newType);
            return result;
        }

        String build() {
            String result = this.toString();
            TypeRef target = AbstractXPathParser.this.targetType;
            if (target != null) {
                if (this.isStringConst()) {
                    TypeDescription targetType = target.get();
                    String stringValue = this.getStringValue();
                    assert (stringValue != null);
                    if (targetType.isInterval()) {
                        return AbstractXPathParser.toIntervalConst(stringValue);
                    }
                    if (targetType.isTime()) {
                        return AbstractXPathParser.toTimeConst(stringValue);
                    }
                    if (targetType.isDecimal()) {
                        this.renderAsDecimal();
                        return this.toString();
                    }
                    if (targetType.isEnum()) {
                        return this.getEnumName(targetType.asObject(), stringValue);
                    }
                }
                if (this.needsCast(target)) {
                    return target.getName() + '(' + result + ')';
                }
            }
            return result;
        }

        void addArrayRef(PInfo right) {
            TypeRef ref = this.type;
            this.append("[");
            int kind = right.type.getKind();
            if (kind != 2) {
                this.append("Int(");
            }
            this.addPInfo(right);
            if (kind != 2) {
                this.append(")");
            }
            this.append("]");
            if (ref != null) {
                this.setType(ref.get().getElementTypeRef());
            }
        }

        void addAttrStep(String stepName) throws SemanticException {
            this.addStep(stepName, true);
        }

        void addStep(String stepName) throws SemanticException {
            this.addStep(stepName, false);
        }

        void addString(Token t) {
            this.addString(t.getText());
            this.setType(AbstractXPathParser.this.getTypeString());
        }

        void addNumber(Token t) {
            long l;
            String text = t.getText();
            double value = Double.parseDouble(text);
            if (value <= 9.223372036854776E18 && value >= -9.223372036854776E18 && (double)(l = (long)value) == value) {
                this.append(Long.toString(l));
                this.setType(AbstractXPathParser.this.getType(2));
            } else {
                this.append(Double.toString(value));
                this.setType(AbstractXPathParser.this.getType(3));
            }
            this.precedence = 99;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        PInfo unary(int n, @Nullable PInfo right) {
            int prec;
            PInfo pInfo;
            if (right == null) {
                pInfo = this;
                if (pInfo == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.unary must not return null");
                return pInfo;
            }
            if (n == 0) {
                pInfo = right;
                if (pInfo == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.unary must not return null");
                return pInfo;
            }
            if ((n & 1) != 0) {
                this.append("-");
            }
            if ((prec = AbstractXPathParser.precedence(21)) > right.precedence) {
                this.append("(");
            }
            this.addPInfo(right);
            if (prec > right.precedence) {
                this.append(")");
            }
            this.precedence = prec;
            this.setType(right.type);
            pInfo = this;
            if (pInfo != null) return pInfo;
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.unary must not return null");
        }

        boolean isStringConst() {
            return this.stringValue != null;
        }

        private boolean needsCast(TypeRef target) {
            TypeDescription actualTD;
            TypeRef actual = this.type;
            if (actual == null || actual.getKind() == target.getKind()) {
                return false;
            }
            TypeDescription targetTD = target.get();
            return !targetTD.isAssignableFrom(actualTD = actual.get()) && Cast.isConvertible((TypeDescription)actualTD, (TypeDescription)targetTD);
        }

        private void renderAsDecimal() {
            if (this.isStringConst()) {
                String str = this.getStringValue();
                this.clear();
                this.append(str);
                this.precedence = 99;
                this.setType(AbstractXPathParser.this.getType(3));
            }
        }

        private void checkEnumEquality(PInfo right) {
            PInfo other;
            PInfo strInfo;
            if (this.isStringConst()) {
                strInfo = this;
                other = right;
            } else if (right.isStringConst()) {
                strInfo = right;
                other = this;
            } else {
                return;
            }
            TypeRef otherType = other.type;
            if (otherType == null || otherType.getKind() != 17) {
                return;
            }
            ObjectTypeDescription objTD = otherType.get().asObject();
            String labelName = strInfo.getStringValue();
            assert (labelName != null);
            strInfo.clear();
            strInfo.append(this.getEnumName(objTD, labelName));
            strInfo.setType(objTD);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        private String getEnumName(@NotNull ObjectTypeDescription enumTD, @NotNull String enumName) {
            MethodTypeDescription[] members;
            if (enumTD == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.getEnumName must not be null");
            }
            if (enumName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.getEnumName must not be null");
            }
            for (MethodTypeDescription member : members = enumTD.getMembers(18, 0L, 0L, TypeFinder.Scope.ALL)) {
                if (!member.getResultType().equals(enumTD) || !member.getNativeName().equals(enumName)) continue;
                enumName = member.getName();
                break;
            }
            String string = enumName;
            if (string == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser$PInfo.getEnumName must not return null");
            }
            return string;
        }

        private PInfo addOperation(String operator, int prec, PInfo right) {
            PInfo result = this;
            if (this.precedence < prec) {
                result = new PInfo();
                result.append("(");
                result.addPInfo(this);
                result.append(")");
            }
            result.append(operator);
            if (right.precedence <= prec) {
                result.append("(");
            }
            result.addPInfo(right);
            if (right.precedence <= prec) {
                result.append(")");
            }
            result.precedence = prec;
            return result;
        }

        private void addStep(String stepName, boolean isAttribute) throws SemanticException {
            MethodTypeDescription member;
            QName qn = AbstractXPathParser.this.buildQName(stepName);
            String memberName = qn.getLocalPart();
            TypeDescription memberType = null;
            TypeRef context = this.type;
            if (context != null && (member = this.findAttribute(context.get(), qn, isAttribute)) != null) {
                memberName = member.getName();
                memberType = member.getResultType();
            }
            this.append(".");
            this.append(memberName);
            this.setType(memberType);
        }

        private boolean isSameAttr(MethodTypeDescription td, QName step) {
            String nativeName = td.getNativeName();
            if (!step.getLocalPart().equals(nativeName)) {
                return false;
            }
            String nameSpace = td.getProperty(ELEMENT_NAMESPACE);
            return step.getNamespaceURI().equals(nameSpace);
        }

        @Nullable
        private MethodTypeDescription findAttribute(TypeDescription scope, QName step, boolean isXsdAttribute) {
            int count = scope.getMemberCount();
            for (int i = 0; i < count; ++i) {
                String xsdAttributeFlag;
                MethodTypeDescription td = scope.getMemberType(i);
                if (!td.isAttribute() || Boolean.parseBoolean(xsdAttributeFlag = td.getProperty(IS_XSD_ATTRIBUTE)) != isXsdAttribute || !this.isSameAttr(td, step)) continue;
                return td;
            }
            for (SuperType superType : scope.getSuperTypes()) {
                MethodTypeDescription result = this.findAttribute(superType.getObjectType(), step, isXsdAttribute);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        private void addString(String s) {
            boolean empty = this.isEmpty();
            this.append("\"");
            this.append(s.replace("\"", "\\\""));
            this.append("\"");
            if (empty) {
                this.stringValue = s;
            }
        }

        private void clear() {
            this.sb.setLength(0);
            this.stringValue = null;
            this.type = null;
        }

        private void addPInfo(PInfo arg) {
            if (arg.isStringConst()) {
                this.addString(arg.getStringValue());
            } else {
                this.sb.append((CharSequence)arg.sb);
            }
        }

        private void append(String str) {
            this.sb.append(str);
            this.stringValue = null;
            this.type = null;
            this.child = null;
            this.isNullTest = false;
            this.precedence = 100;
        }

        private boolean isEmpty() {
            return this.sb.length() == 0;
        }
    }

    class ComparePInfo
    extends PInfo {
        @NotNull
        PInfo child2;

        ComparePInfo(@NotNull PInfo child1, PInfo child2) {
            if (child1 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/AbstractXPathParser$ComparePInfo.<init> must not be null");
            }
            if (child2 == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/compiler/xpath/AbstractXPathParser$ComparePInfo.<init> must not be null");
            }
            this.child = child1;
            this.child2 = child2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        PInfo relational(int token, PInfo right) throws SemanticException {
            this.checkRight(right);
            PInfo op1 = this.child;
            assert (op1 != null);
            PInfo pInfo = op1.relational(token, this.child2);
            if (pInfo == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/AbstractXPathParser$ComparePInfo.relational must not return null");
            }
            return pInfo;
        }

        @Override
        PInfo equality(int token, PInfo right) throws SemanticException {
            this.checkRight(right);
            PInfo op1 = this.child;
            assert (op1 != null);
            return op1.equality(token, this.child2);
        }

        private void checkRight(PInfo right) throws SemanticException {
            if (right.type.getKind() != 2 || !"0".equals(right.toString())) {
                throw new SemanticException("Unsupported compare");
            }
        }
    }

    private static interface CallGenerator {
        @NotNull
        public PInfo generate(QName var1, List<PInfo> var2) throws SemanticException;
    }
}

