/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaneUtils {
    private static final int WBYCHAR = 12;

    public static void setLaneForFlowNode(@NotNull Lane lane, @NotNull FlowNode flowNode) {
        double offset = 0.5;
        int delta = LaneUtils.calculateLastFlowNodeDelta(lane);
        Point locationInLane = LaneUtils.getLocationFor(lane, 0.5, delta + flowNode.getWidth());
        flowNode.setLocation(locationInLane);
    }

    @NotNull
    public static Sequence<Lane> getLanesForId(@NotNull Process process, final @NotNull String laneId) {
        Predicate<Lane> laneEqualsId = new Predicate<Lane>(){

            @Override
            public boolean check(Lane lane) {
                return lane.getId().equals(laneId);
            }
        };
        return CollectionUtils.filterDuplicates(process.getLanes().select(laneEqualsId));
    }

    @Nullable
    public static Lane getLaneForId(@NotNull Process process, @NotNull String laneId) {
        return CollectionUtils.first(LaneUtils.getLanesForId(process, laneId));
    }

    public static boolean isMandatoryRole(@NotNull Lane lane) {
        Sequence<Event> events = lane.getProcess().getEvents();
        for (Event event : events) {
            if (!event.isStart() && !event.isEnd() || !event.getLane().equals(lane)) continue;
            return true;
        }
        return false;
    }

    public static Point getLocationFor(@NotNull Lane lane, double relativeOffset, @NotNull Point activityLocation) {
        int delta = activityLocation.getY();
        if (ModelUtils.isHorizontal(lane.getProcess())) {
            delta = activityLocation.getX();
        }
        return LaneUtils.getLocationFor(lane, relativeOffset, delta);
    }

    public static Point getLocationFor(@NotNull Lane lane, double relativeOffset, int delta) {
        int relLoc = (int)((double)lane.getSize() * relativeOffset);
        Point result = new Point(lane.getOffset() + relLoc, delta);
        if (ModelUtils.isHorizontal(lane.getProcess())) {
            result = result.transposed();
        }
        return result;
    }

    public static Lane getLastLane(@NotNull Process process) {
        return CollectionUtils.last(process.getLanes());
    }

    public static void setOffsetAfterLastLane(@NotNull Lane lane) {
        Lane last = LaneUtils.getLastLane(lane.getProcess());
        if (last == null) {
            lane.asMutable().setOffset(0);
        } else {
            lane.asMutable().setOffset(last.getOffset() + last.getSize());
        }
    }

    @Nullable
    public static Lane getLane(@NotNull Process process, @NotNull Point location) {
        int offset = ModelUtils.isHorizontal(process) ? location.getY() : location.getX();
        return LaneUtils.getLane(process, offset);
    }

    @Nullable
    public static Lane getLane(@NotNull Process process, int offset) {
        for (Lane lane : process.getLanes()) {
            if (lane.getOffset() > offset || offset >= lane.getOffset() + lane.getSize()) continue;
            return lane;
        }
        return null;
    }

    public static int calculateMinimunLaneSize(@NotNull Lane lane, int newWidth) {
        int width = newWidth;
        Sequence<FlowNode> nodes = lane.getActivities();
        for (FlowNode node : nodes) {
            int boundOffset = ModelUtils.isHorizontal(lane.getProcess()) ? node.getY() + node.getHeight() / 2 : node.getX() + node.getWidth() / 2;
            if (boundOffset <= lane.getOffset() + width) continue;
            width = boundOffset - lane.getOffset();
        }
        return LaneUtils.calculateMinimunLaneSize(width, lane.getDefaultLabel(), lane.getParamName());
    }

    public static int calculateMinimunLaneSize(int width, @Nullable String name, @Nullable String param) {
        name = "AutomaticHandler".equals(name) ? "" : name;
        return Math.max(Math.max(width, 200), ("" + name + " (" + param + ")").length() * 12);
    }

    private static int calculateLastFlowNodeDelta(@NotNull Lane lane) {
        int result = 0;
        for (FlowNode flowNode : lane.getActivities()) {
            int flowNodeDelta = ModelUtils.isHorizontal(lane.getProcess()) ? flowNode.getX() : flowNode.getY();
            result = Math.max(result, flowNodeDelta);
        }
        return result;
    }
}

