/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.organization;

import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.ParticipantAbsence;
import oracle.bpm.project.model.organization.Role;
import org.jetbrains.annotations.NotNull;

public interface Participant
extends AssignableToRole,
AssignableToGroup,
Comparable<Participant> {
    public double getCost();

    public int getEfficiency();

    public boolean receivesMail();

    public String getDisplayName();

    public String getEmployeeId();

    public String getFax();

    public String getFirstName();

    public String getLastName();

    public String getMail();

    public String getManager();

    public OrganizationalUnit getOrganizationalUnit();

    public String getTelephone();

    public boolean isAdministrator();

    public boolean isEnabled();

    public byte[] getPhoto();

    public Locale getLocale();

    public TimeZone getTimeZone();

    public Collection<ParticipantAbsence> getAbsencePeriods();

    public Collection<ParticipantAbsence> getReplacementPeriods();

    public void removeRole(Role var1);

    public Role findAssignedRole(String var1);

    public Group findAssignedGroup(String var1);

    public void removeGroup(Group var1);

    @Override
    @NotNull
    public Mutable asMutable();

    public static interface Mutable
    extends Participant,
    AssignableToRole.Mutable,
    AssignableToGroup.Mutable {
        public void setCost(double var1);

        public void setEfficiency(int var1);

        public void setReceivesMail(boolean var1);

        public void setDisplayName(String var1);

        public void setEmployeeId(String var1);

        public void setFax(String var1);

        public void setFirstName(String var1);

        public void setLastName(String var1);

        public void setMail(String var1);

        public void setManager(String var1);

        public void setOrganizationalUnit(OrganizationalUnit var1);

        public void setTelephone(String var1);

        public void setAdministrator(boolean var1);

        public void setEnabled(boolean var1);

        public void setPhoto(byte[] var1);

        public void setLocale(Locale var1);

        public void setTimeZone(TimeZone var1);

        public ParticipantAbsence.Mutable createAbsencePeriod();

        public void addAbsencePeriod(ParticipantAbsence var1);

        public void removeAbsencePeriod(ParticipantAbsence var1);

        public void addReplacementPeriod(ParticipantAbsence var1);

        public void removeReplacementPeriod(ParticipantAbsence var1);

        public void addGroup(Group var1);

        public void removeOrganizationalUnit();

        public void setOrganizationalUnitId(String var1);
    }
}

