/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.impl.keys;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.impl.keys.ProjectObjectKey;
import oracle.bpm.project.model.organization.OrganizationalUnit;

public class OrganizationalUnitKey
extends ProjectObjectKey {
    public final OrganizationalUnitKey parentKey;
    public static final String ROOT_NAME = "";
    public static final OrganizationalUnitKey rootKey = new OrganizationalUnitKey("", null);

    private OrganizationalUnitKey(String id, OrganizationalUnitKey parentKey) {
        super(id);
        this.parentKey = parentKey;
    }

    public static OrganizationalUnitKey valueOf(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        OrganizationalUnitKey currentParent = rootKey;
        while (st.hasMoreTokens()) {
            currentParent = new OrganizationalUnitKey(st.nextToken(), currentParent);
        }
        return currentParent;
    }

    public static OrganizationalUnitKey valueOf(OrganizationalUnit parent, String id) {
        return parent == null ? new OrganizationalUnitKey(id, null) : new OrganizationalUnitKey(id, (OrganizationalUnitKey)parent.getKey());
    }

    public static List<OrganizationalUnitKey> calculateKeyPath(OrganizationalUnitKey ouKey) {
        if (ouKey == null) {
            return new ArrayList<OrganizationalUnitKey>();
        }
        List<OrganizationalUnitKey> keyPath = OrganizationalUnitKey.calculateKeyPath(ouKey.getParentKey());
        keyPath.add(ouKey);
        return keyPath;
    }

    public OrganizationalUnitKey getParentKey() {
        return this.parentKey;
    }

    @Override
    public int compareTo(Object o) {
        int typeCompare = this.compareTypes(o);
        if (typeCompare != 0) {
            return typeCompare;
        }
        OrganizationalUnitKey organizationalUnitKey = (OrganizationalUnitKey)o;
        int parentCompare = this == rootKey ? (organizationalUnitKey == rootKey ? 0 : -1) : (organizationalUnitKey == rootKey ? 1 : this.parentKey.compareTo(organizationalUnitKey.parentKey));
        return parentCompare != 0 ? parentCompare : this.id.compareTo(organizationalUnitKey.id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationalUnitKey)) {
            return false;
        }
        OrganizationalUnitKey organizationalUnitKey = (OrganizationalUnitKey)o;
        if (this.id != null ? !this.id.toLowerCase().equals(organizationalUnitKey.id.toLowerCase()) : organizationalUnitKey.id != null) {
            return false;
        }
        return !(this.parentKey != null ? !this.parentKey.equals(organizationalUnitKey.parentKey) : organizationalUnitKey.parentKey != null);
    }

    @Override
    public ProjectObjectType getType() {
        return ProjectObjectType.OU;
    }

    @Override
    public int hashCode() {
        int result = this.id != null ? this.id.toLowerCase().hashCode() : 0;
        result = 29 * result + (this.parentKey != null ? this.parentKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getType().name() + ":" + this.id + ":" + (this.parentKey == null ? ROOT_NAME : this.parentKey.toString());
    }
}

