/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.Map;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FileUtils;

public class ProcessPath
extends StringFeature {
    protected ProcessPath(String featureName, Msg label, Msg description, String value) {
        super(featureName, label, description, value);
    }

    public static ProcessPath create() {
        return new ProcessPath("targetModelPath", null, null, "");
    }

    @Override
    public void setValue(String value) {
        if (value != null && !(value = FileUtils.removeExtension(value)).startsWith(Path.PROCESSES.toString()) && value.startsWith("/")) {
            value = value.substring(1);
            value = Path.PROCESSES.create(value).toString();
        }
        super.setValue(value);
    }

    @Override
    public void fill(Map<String, Object> propertiesFor) {
        Object path = propertiesFor.get("relatedProcessPath");
        if (path != null) {
            this.setObjectValue(path);
        } else {
            super.fill(propertiesFor);
        }
    }
}

