/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.OperationNameFeature;
import oracle.bpm.project.model.features.ParticipantNameFeature;
import oracle.bpm.type.AmbiguousTypeNameException;

public class ParticipantFeature
extends FeatureSet {
    protected OperationNameFeature operationName;
    protected ParticipantNameFeature participantName;
    protected Project project;

    protected ParticipantFeature(String name, Project project) {
        super(name, null, null);
        this.project = project;
        this.participantName = new ParticipantNameFeature();
        this.addFeature(this.participantName);
        this.operationName = new OperationNameFeature();
        this.addFeature(this.operationName);
    }

    public static ParticipantFeature create(Project project) {
        return new ParticipantFeature("participant", project);
    }

    public String getParticipantName() {
        return this.participantName.getValue();
    }

    public String getOperationName() {
        return this.operationName.getValue();
    }

    public void setOperationName(String operationName) {
        this.operationName.setValue(operationName);
    }

    public void setParticipant(CatalogObject participant) {
        this.participantName.setValue(participant != null ? participant.getText() : "");
    }

    public void setParticipantName(String participantName) {
        this.participantName.setValue(participantName);
    }

    public CatalogMember getOperation() {
        CatalogMember result = null;
        CatalogObject participant = this.getParticipant();
        String operationName = this.getOperationName();
        if (participant != null && !Str.isEmpty(operationName)) {
            result = participant.findMember(operationName);
        }
        return result;
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof ParticipantFeature) {
            ParticipantFeature source = (ParticipantFeature)feature;
            this.setParticipantName(source.getParticipantName());
            this.setOperationName(source.getOperationName());
        }
    }

    public CatalogObject getParticipant() {
        CatalogObject result = null;
        if (this.project != null && !Str.isEmpty(this.getParticipantName())) {
            try {
                result = this.project.findCatalogObject(this.getParticipantName());
            }
            catch (AmbiguousTypeNameException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setOperation(CatalogMember operation) throws ProjectException {
        if (operation != null) {
            this.setParticipant(operation.getParentObject());
            this.operationName.setValue(operation.getName());
        } else {
            this.setParticipant(null);
            this.operationName.setValue("");
        }
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }
}

