/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.features.AbstractDataAssociationFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;

public class InOutDataAssociationFeature
extends AbstractDataAssociationFeature {
    private IncomingDataAssociationFeature inputDataAssignmentFeature;
    private OutgoingDataAssociationFeature outputDataAssignmentFeature;

    protected InOutDataAssociationFeature(String featureName, Msg label, Process node) {
        super(featureName, label);
        this.inputDataAssignmentFeature = IncomingDataAssociationFeature.create(node);
        this.addFeature(this.inputDataAssignmentFeature);
        this.outputDataAssignmentFeature = OutgoingDataAssociationFeature.create(node);
        this.addFeature(this.outputDataAssignmentFeature);
        this.initDataAssociationSet();
    }

    protected InOutDataAssociationFeature(String featureName, Msg label, FlowNode node) {
        super(featureName, label);
        this.inputDataAssignmentFeature = IncomingDataAssociationFeature.create(node);
        this.addFeature(this.inputDataAssignmentFeature);
        this.outputDataAssignmentFeature = OutgoingDataAssociationFeature.create(node);
        this.addFeature(this.outputDataAssignmentFeature);
        this.initDataAssociationSet();
    }

    public static InOutDataAssociationFeature create(Process process) {
        return new InOutDataAssociationFeature("inOutDataAssociation", null, process);
    }

    public static InOutDataAssociationFeature create(FlowNode node) {
        return new InOutDataAssociationFeature("inOutDataAssociation", null, node);
    }

    public DataAssociationSet getInputDataAssociationSet() {
        return this.inputDataAssignmentFeature.getDataAssociationSet();
    }

    public DataAssociationSet getOutputDataAssociationSet() {
        return this.outputDataAssignmentFeature.getDataAssociationSet();
    }

    public boolean usesTransformations() {
        return this.inputDataAssignmentFeature.usesTransformations() || this.outputDataAssignmentFeature.usesTransformations();
    }

    public void setUsesTransformations(boolean value) {
        this.inputDataAssignmentFeature.setUsesTransformations(value);
        this.outputDataAssignmentFeature.setUsesTransformations(value);
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
    }

    @Override
    protected void initDataAssociationSet() {
        this.inputDataAssignmentFeature.initDataAssociationSet();
        this.outputDataAssignmentFeature.initDataAssociationSet();
    }
}

