/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.Locale;
import oracle.bpm.lang.Any;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public class BooleanFeature
extends PersistentFeature<Boolean> {
    boolean value;
    private boolean prevValue;
    public static final BooleanFeature DEFAULT = new BooleanFeature("default", null, null, false);

    protected BooleanFeature(@NonNls String featureName, Msg label, Msg description, boolean value) {
        super(featureName, label, description);
        this.setValue(value);
    }

    public static BooleanFeature create(String featureName, boolean value) {
        return BooleanFeature.create(featureName, null, null, value);
    }

    public static BooleanFeature create(String featureName, Msg label) {
        return BooleanFeature.create(featureName, label, null, false);
    }

    public static BooleanFeature create(@NonNls String featureName, Msg label, Msg description, boolean value) {
        return new BooleanFeature(featureName, label, description, value);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        boolean fire = false;
        if (!Any.equals(this.value, value)) {
            this.prevValue = this.value;
            fire = true;
        }
        this.value = value;
        if (fire) {
            this.fireChanged();
        }
    }

    public void toggleValue() {
        this.setValue(this.getValue() == false);
    }

    @Override
    public Boolean getPrevValue() {
        return this.prevValue;
    }

    public Feature getDefault() {
        return DEFAULT;
    }

    @Override
    public void setValue(String value) {
        this.setValue(Boolean.parseBoolean(value));
    }

    @Override
    public String getPresentableValue(Locale locale) {
        return this.getValue() != false ? CoreMsg.YES.getString(locale) : CoreMsg.NO.getString(locale);
    }
}

