/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.AnnotationsEnabled;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class AnnotationsFeature
extends FeatureSet
implements AnnotationsEnabled {
    protected AnnotationsFeature(@NotNull String featureName, @NotNull Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(UserAnnotationsFeature.create());
        this.addFeature(HiddenAnnotationsFeature.create());
    }

    public static AnnotationsFeature create() {
        return new AnnotationsFeature("annotations", ProjectModelMsg.ANNOTATIONS, null);
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getCorrectFeature(visible).getAnnotations();
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getCorrectFeature(visible).addAnnotation(key, value);
    }

    @Override
    public void fill(Map<String, Object> propertiesFor) {
    }

    public void fill(Map<String, Object> userAnnotations, Map<String, Object> hiddenAnnotations) {
        this.getFeature(UserAnnotationsFeature.class).fill(userAnnotations);
        this.getFeature(HiddenAnnotationsFeature.class).fill(hiddenAnnotations);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getCorrectFeature(visible).removeAnnotation(key);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getCorrectFeature(visible).getAnnotationValue(key);
    }

    public boolean hasAnnotations() {
        return this.getFeature(UserAnnotationsFeature.class).hasAnnotations() || this.getFeature(HiddenAnnotationsFeature.class).hasAnnotations();
    }

    private AnnotationsMapFeature getCorrectFeature(boolean visible) {
        AnnotationsMapFeature correctFeature = visible ? (AnnotationsMapFeature)this.getFeature(UserAnnotationsFeature.class) : (AnnotationsMapFeature)this.getFeature(HiddenAnnotationsFeature.class);
        return correctFeature;
    }

    public static class UserAnnotationsFeature
    extends AnnotationsMapFeature {
        protected UserAnnotationsFeature(String featureName, Msg label, Msg description) {
            super(featureName, label, description);
        }

        public static UserAnnotationsFeature create() {
            return new UserAnnotationsFeature("userAnnotations", ProjectModelMsg.USER_ANNOTATIONS, null);
        }
    }

    public static class HiddenAnnotationsFeature
    extends AnnotationsMapFeature {
        protected HiddenAnnotationsFeature(String featureName, Msg label, Msg description) {
            super(featureName, label, description);
        }

        public static HiddenAnnotationsFeature create() {
            return new HiddenAnnotationsFeature("hiddenAnnotations", ProjectModelMsg.HIDDEN_ANNOTATIONS, null);
        }
    }

    public static class AnnotationsMapFeature
    extends FeatureSet {
        protected AnnotationsMapFeature(String featureName, Msg label, Msg description) {
            super(featureName, label, description);
        }

        public Map<String, String> getAnnotations() {
            HashMap<String, String> retMap = new HashMap<String, String>();
            for (Feature feature : this.getFeatures()) {
                if (!(feature instanceof StringFeature)) continue;
                StringFeature stringFeature = (StringFeature)feature;
                retMap.put(stringFeature.getName(), stringFeature.getValue());
            }
            return Collections.unmodifiableMap(retMap);
        }

        public void removeAnnotation(String key) {
            this.removeFeature(this.findByName(key));
        }

        public void addAnnotation(String key, String value) {
            this.addFeature(StringFeature.create(key, value));
        }

        public String getAnnotationValue(@NotNull String key) {
            String value = null;
            Feature feature = this.findByName(key);
            if (feature != null && feature instanceof StringFeature) {
                value = ((StringFeature)feature).getValue();
            }
            return value;
        }

        @Override
        public void fill(Map<String, Object> propertiesFor) {
            Iterator<String> i$ = propertiesFor.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                Object propertyValue = propertiesFor.get(key = i$.next());
                this.addAnnotation(key, propertyValue instanceof String ? (String)propertyValue : "");
            }
        }

        public boolean hasAnnotations() {
            return !this.getFeatures().isEmpty();
        }

        @Override
        public void copyFrom(Feature feature) {
            if (!feature.isSet() || !(feature instanceof AnnotationsMapFeature)) {
                return;
            }
            this.resetAllFeatures();
            AnnotationsMapFeature set = (AnnotationsMapFeature)feature;
            for (Map.Entry<String, String> entry : set.getAnnotations().entrySet()) {
                this.addAnnotation(entry.getKey(), entry.getValue());
            }
        }

        private void resetAllFeatures() {
            for (Feature child : new ArrayList<Feature>(this.getFeatures())) {
                this.removeFeature(child);
            }
        }
    }
}

